/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.osgi.framework.Bundle;

public class WizardUtil
extends Assert {
    private static boolean projectCreated = false;
    private static final String FACESCONFIG_PROJECT_NAME = "FacesConfigUnitTest";
    private static final String FACESCONFIG_EAR_PROJECT_NAME = "FacesConfigUnitTestEAR";

    public static boolean isProjectCreated() {
        return projectCreated;
    }

    public static void createProject(String nameSuffix) {
        if (!WizardUtil.isProjectCreated()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject oldWebProj = workspace.getRoot().getProject(WizardUtil.createProjectName(nameSuffix));
            IProject oldEarProj = workspace.getRoot().getProject(WizardUtil.createEarProjectName(nameSuffix));
            try {
                workspace.delete(new IResource[]{oldWebProj, oldEarProj}, true, null);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            try {
                WebProjectTestEnvironment testEnv = new WebProjectTestEnvironment(WizardUtil.createProjectName(nameSuffix));
                testEnv.createProject(false);
                WizardUtil.assertNotNull((Object)testEnv);
                WizardUtil.assertNotNull((Object)testEnv.getTestProject());
                WizardUtil.assertTrue((boolean)testEnv.getTestProject().isAccessible());
                IProject project = testEnv.getTestProject();
                WizardUtil.checkAndAddFacesConfig(project);
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
            projectCreated = true;
        }
    }

    protected static IProject createWebProject(String projectName) throws Exception {
        if (!WizardUtil.isProjectCreated()) {
            IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
            dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
            dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static void setProjectDirtied() {
        projectCreated = false;
    }

    public static void recreateProject(String nameSuffix) {
        WizardUtil.setProjectDirtied();
        WizardUtil.createProject(nameSuffix);
    }

    public static IProject getTestProject(String nameSuffix) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getProject(WizardUtil.createProjectName(nameSuffix));
    }

    private static String createProjectName(String nameSuffix) {
        return FACESCONFIG_PROJECT_NAME;
    }

    private static String createEarProjectName(String nameSuffix) {
        return FACESCONFIG_EAR_PROJECT_NAME;
    }

    private static void checkAndAddFacesConfig(IProject project) {
        IContainer container = ComponentCore.createComponent((IProject)project).getRootFolder().getFolder("/WEB-INF").getUnderlyingFolder();
        IFile facesConfigFile = ResourcesPlugin.getWorkspace().getRoot().getFile(container.getFullPath().append((IPath)new Path("faces-config.xml")));
        IFile facesConfigFile1 = ResourcesPlugin.getWorkspace().getRoot().getFile(container.getFullPath().append((IPath)new Path("faces-config1.xml")));
        IFile facesConfigFile2 = ResourcesPlugin.getWorkspace().getRoot().getFile(container.getFullPath().append((IPath)new Path("faces-config2.xml")));
        IFile facesConfigFileExtData = ResourcesPlugin.getWorkspace().getRoot().getFile(container.getFullPath().append((IPath)new Path("faces-config-ext-data1.xml")));
        IFile facesConfig_1_2File = ResourcesPlugin.getWorkspace().getRoot().getFile(container.getFullPath().append((IPath)new Path("faces-config_1_2.xml")));
        if (facesConfigFile.exists()) {
            return;
        }
        Path facesConfigPath = new Path("/template/faces-config.xml");
        Path facesConfig1Path = new Path("/template/faces-config1.xml");
        Path facesConfig2Path = new Path("/template/faces-config2.xml");
        Path facesConfigExtData1Path = new Path("/template/faces-config-ext-data1.xml");
        Path facesConfig_1_2_Path = new Path("/template/faces-config_1_2.xml");
        Bundle myBundle = Platform.getBundle((String)"org.eclipse.jst.jsf.facesconfig.tests");
        try {
            String sourcePath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)myBundle, (IPath)facesConfigPath, null)).getPath().toString();
            File f = new File(sourcePath);
            FileInputStream sourceStream = new FileInputStream(f);
            facesConfigFile.create((InputStream)sourceStream, true, null);
            sourceStream.close();
            String sourcePath1 = FileLocator.toFileURL((URL)FileLocator.find((Bundle)myBundle, (IPath)facesConfig1Path, null)).getPath().toString();
            File f1 = new File(sourcePath1);
            FileInputStream sourceStream1 = new FileInputStream(f1);
            facesConfigFile1.create((InputStream)sourceStream1, true, null);
            sourceStream1.close();
            String sourcePath2 = FileLocator.toFileURL((URL)FileLocator.find((Bundle)myBundle, (IPath)facesConfig2Path, null)).getPath().toString();
            File f2 = new File(sourcePath2);
            FileInputStream sourceStream2 = new FileInputStream(f2);
            facesConfigFile2.create((InputStream)sourceStream2, true, null);
            sourceStream2.close();
            String sourcePathExtData1 = FileLocator.toFileURL((URL)FileLocator.find((Bundle)myBundle, (IPath)facesConfigExtData1Path, null)).getPath().toString();
            File fext = new File(sourcePathExtData1);
            FileInputStream sourceStreamExt1 = new FileInputStream(fext);
            facesConfigFileExtData.create((InputStream)sourceStreamExt1, true, null);
            sourceStreamExt1.close();
            String sourcePathFacesConfig_1_2 = FileLocator.toFileURL((URL)FileLocator.find((Bundle)myBundle, (IPath)facesConfig_1_2_Path, null)).getPath().toString();
            fext = new File(sourcePathFacesConfig_1_2);
            sourceStreamExt1 = new FileInputStream(fext);
            facesConfig_1_2File.create((InputStream)sourceStreamExt1, true, null);
            sourceStreamExt1.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
    }
}

