/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEEObjectImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.NoModuleFileException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public abstract class ModuleRefImpl
extends J2EEEObjectImpl
implements ModuleRef {
    protected ModuleFile moduleFile = null;
    protected Module module = null;

    protected ModuleRefImpl() {
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.MODULE_REF;
    }

    protected CommonarchiveFactory getCommonArchiveFactory() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory();
    }

    protected void buildComponentList(EList list) {
    }

    public ModuleFile getModuleFileGen() {
        if (this.moduleFile != null && this.moduleFile.eIsProxy()) {
            InternalEObject oldModuleFile = (InternalEObject)this.moduleFile;
            this.moduleFile = (ModuleFile)this.eResolveProxy(oldModuleFile);
            if (this.moduleFile != oldModuleFile && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldModuleFile, (Object)this.moduleFile));
            }
        }
        return this.moduleFile;
    }

    public ModuleFile getModuleFile() {
        if (this.moduleFile == null) {
            this.initModuleFileFromEAR();
        }
        return this.moduleFile;
    }

    public ModuleFile basicGetModuleFile() {
        return this.moduleFile;
    }

    protected void initModuleFileFromEAR() {
        this.checkEARFile();
        ModuleFile aFile = null;
        try {
            aFile = (ModuleFile)this.getEarFile().getFile(this.module.getUri());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (ClassCastException classCastException) {}
        this.checkType(this.module, aFile);
        this.setModuleFile(aFile);
    }

    public void setModuleFile(ModuleFile newModuleFile) {
        ModuleFile oldModuleFile = this.moduleFile;
        this.moduleFile = newModuleFile;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldModuleFile, (Object)this.moduleFile));
        }
    }

    public boolean usesAltDD() {
        if (this.module == null) {
            return false;
        }
        return !ArchiveUtil.isNullOrEmpty(this.module.getAltDD());
    }

    public EObject getAltDeploymentDescriptor() throws ArchiveWrappedException {
        if (this.getEarFile() == null) {
            return null;
        }
        try {
            return this.getEarFile().getAltDeploymentDescriptor(this.getModule());
        }
        catch (Exception ex) {
            throw new ArchiveWrappedException(ex);
        }
    }

    public EObject getDeploymentDescriptor() throws ArchiveWrappedException {
        if (this.getEarFile() == null) {
            return this.getStandardDeploymentDescriptor();
        }
        try {
            return this.getEarFile().getDeploymentDescriptor(this.getModule());
        }
        catch (Exception ex) {
            throw new ArchiveWrappedException(ex);
        }
    }

    public EObject getStandardDeploymentDescriptor() {
        if (this.getModuleFile() == null) {
            return null;
        }
        return this.getModuleFile().getStandardDeploymentDescriptor();
    }

    public void setURI(String uri) {
        if (this.getModuleFile() != null) {
            this.getModuleFile().setURI(uri);
        }
        if (this.getModule() != null) {
            this.getModule().setUri(uri);
        }
    }

    public boolean isClient() {
        return false;
    }

    public boolean isConnector() {
        return false;
    }

    public boolean isEJB() {
        return false;
    }

    public boolean isWeb() {
        return false;
    }

    public EARFile getEarFile() {
        if (this.eContainerFeatureID != 1) {
            return null;
        }
        return (EARFile)this.eContainer();
    }

    public NotificationChain basicSetEarFile(EARFile newEarFile, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newEarFile, 1, msgs);
        return msgs;
    }

    public void setEarFile(EARFile newEarFile) {
        if (newEarFile != this.eInternalContainer() || this.eContainerFeatureID != 1 && newEarFile != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newEarFile)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newEarFile != null) {
                msgs = ((InternalEObject)newEarFile).eInverseAdd((InternalEObject)this, 9, EARFile.class, msgs);
            }
            if ((msgs = this.basicSetEarFile(newEarFile, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newEarFile, (Object)newEarFile));
        }
    }

    public Module getModule() {
        if (this.module != null && this.module.eIsProxy()) {
            Module oldModule = this.module;
            this.module = (Module)EcoreUtil.resolve((EObject)this.module, (EObject)this);
            if (this.module != oldModule && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldModule, (Object)this.module));
            }
        }
        return this.module;
    }

    public Module basicGetModule() {
        return this.module;
    }

    public void setModule(Module newModule) {
        Module oldModule = this.module;
        this.module = newModule;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldModule, (Object)this.module));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetEarFile((EARFile)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetEarFile(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID) {
            case 1: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 9, EARFile.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getModuleFile();
                }
                return this.basicGetModuleFile();
            }
            case 1: {
                return this.getEarFile();
            }
            case 2: {
                if (resolve) {
                    return this.getModule();
                }
                return this.basicGetModule();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setModuleFile((ModuleFile)newValue);
                return;
            }
            case 1: {
                this.setEarFile((EARFile)newValue);
                return;
            }
            case 2: {
                this.setModule((Module)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setModuleFile(null);
                return;
            }
            case 1: {
                this.setEarFile(null);
                return;
            }
            case 2: {
                this.setModule(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.moduleFile != null;
            }
            case 1: {
                return this.getEarFile() != null;
            }
            case 2: {
                return this.module != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public InputStream getResourceInputStream(String uri) throws IOException {
        if (this.usesAltDD()) {
            return this.getAltResourceInputStream(uri);
        }
        return this.getLocalResourceInputStream(uri);
    }

    public InputStream getLocalResourceInputStream(String uri) throws IOException {
        this.checkModuleFile();
        return this.moduleFile.getResourceInputStream(uri);
    }

    public InputStream getAltResourceInputStream(String uri) throws IOException {
        this.checkEARFile();
        return this.getEarFile().getResourceInputStream(uri);
    }

    public String getUri() {
        if (this.module != null) {
            return this.module.getUri();
        }
        if (this.moduleFile != null) {
            return this.moduleFile.getURI();
        }
        return null;
    }

    public Resource getAltMofResource(String uri) throws FileNotFoundException, ResourceLoadException {
        this.checkEARFile();
        return this.getEarFile().getMofResource(uri);
    }

    public Resource getLocalMofResource(String uri) throws FileNotFoundException, ResourceLoadException {
        this.checkModuleFile();
        return this.moduleFile.getMofResource(uri);
    }

    public Resource getMofResource(String uri) throws FileNotFoundException, ResourceLoadException {
        if (this.usesAltDD()) {
            return this.getAltMofResource(uri);
        }
        return this.getLocalMofResource(uri);
    }

    public Resource makeAltMofResource(String uri) throws DuplicateObjectException {
        this.checkEARFile();
        return this.getEarFile().makeMofResource(uri);
    }

    protected void checkEARFile() {
        if (this.getEarFile() == null) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.Module_not_in_EAR, new Object[]{this.getUri()}));
        }
    }

    public Resource makeLocalMofResource(String uri) throws DuplicateObjectException {
        this.checkModuleFile();
        return this.moduleFile.makeMofResource(uri);
    }

    protected void checkModuleFile() {
        this.getModuleFile();
        if (this.moduleFile == null) {
            throw new NoModuleFileException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.Module_file_does_not_exist_2, new Object[]{this.getUri()}));
        }
    }

    protected void checkType(Module moduleDescriptor, File aFile) {
        if (aFile == null) {
            String message = CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.A_file_does_not_exist_for_module, new Object[]{moduleDescriptor.getUri()});
            throw new NoModuleFileException(message);
        }
        boolean isValid = true;
        String type = CommonArchiveResourceHandler.Module_file;
        if (moduleDescriptor.isWebModule() && !aFile.isWARFile()) {
            isValid = false;
            type = CommonArchiveResourceHandler.A_WAR_file;
        } else if (moduleDescriptor.isEjbModule() && !aFile.isEJBJarFile()) {
            isValid = false;
            type = CommonArchiveResourceHandler.An_EJB_JAR_file;
        } else if (moduleDescriptor.isJavaModule() && !aFile.isApplicationClientFile()) {
            isValid = false;
            type = CommonArchiveResourceHandler.An_Application_Client_JAR_file;
        } else if (moduleDescriptor.isConnectorModule() && !aFile.isRARFile()) {
            isValid = false;
            type = CommonArchiveResourceHandler.A_RAR_file;
        } else if (!aFile.isModuleFile()) {
            isValid = false;
        }
        if (isValid) {
            return;
        }
        String earUri = "";
        if (this.getEarFile() != null) {
            earUri = this.getEarFile().getURI();
        }
        String message = CommonArchiveResourceHandler.getString("File_not_correct_type", new Object[]{aFile.getURI(), earUri, type});
        throw new ArchiveRuntimeException(message);
    }

    public Resource makeMofResource(String uri) throws DuplicateObjectException {
        if (this.usesAltDD()) {
            return this.makeAltMofResource(uri);
        }
        return this.makeLocalMofResource(uri);
    }
}

