/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.component;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.designtime.DTAppManagerUtil;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.view.DTUIViewRoot;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.IViewRootHandle;
import org.eclipse.jst.jsf.ui.internal.component.Messages;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

class DTJSFViewModel {
    private final IStructuredDocument _document;
    private final IProject _project;
    private final IFile _file;
    private final IStructuredDocumentContext _context;
    private final AtomicBoolean _alreadyUpdating = new AtomicBoolean(false);
    private Runnable _runnable;
    private final IViewRootHandle _viewRootHandle;
    private DTUIViewRoot.StalenessListener _stalenessListener;

    public DTJSFViewModel(IStructuredDocument document) {
        this._document = document;
        this._context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._document, -1);
        IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(this._context);
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        this._project = resolver.getProject();
        this._file = (IFile)resolver.getResource();
        if (this._project == null || this._file == null) {
            throw new IllegalArgumentException();
        }
        DTFacesContext facesContext = this.getFacesContext();
        this._viewRootHandle = facesContext.getViewRootHandle();
    }

    public void init(Runnable runnable) {
        this._runnable = runnable;
        this._viewRootHandle.addListener(this.getOrCreateListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this._stalenessListener != null) {
            this._viewRootHandle.removeListener(this._stalenessListener);
        }
        DTJSFViewModel dTJSFViewModel = this;
        synchronized (dTJSFViewModel) {
            this._runnable = null;
        }
    }

    public final IStructuredDocument getDocument() {
        return this._document;
    }

    public final IProject getProject() {
        return this._project;
    }

    public final String getViewId() {
        DTFacesContext facesContext = this.getFacesContext();
        IDTViewHandler viewHandler = DTAppManagerUtil.getViewHandler((IProject)this._project);
        if (facesContext != null && viewHandler != null) {
            return viewHandler.getViewId(facesContext, (IResource)this._file);
        }
        return null;
    }

    private DTFacesContext getFacesContext() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._project);
        if (manager != null) {
            return manager.getFacesContext(this._file);
        }
        return null;
    }

    public void update() {
        DTFacesContext facesContext = this.getFacesContext();
        if (facesContext != null && this._alreadyUpdating.compareAndSet(false, true)) {
            UpdateRootAndRefreshJob job = new UpdateRootAndRefreshJob(this._viewRootHandle);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IJobChangeEvent event) {
                    DTJSFViewModel.this._alreadyUpdating.set(false);
                    if (event.getResult().isOK()) {
                        DTJSFViewModel dTJSFViewModel = DTJSFViewModel.this;
                        synchronized (dTJSFViewModel) {
                            if (DTJSFViewModel.this._runnable != null) {
                                DTJSFViewModel.this._runnable.run();
                            }
                        }
                    }
                }
            });
            job.schedule();
        }
    }

    public DTUIViewRoot getRoot() {
        DTFacesContext facesContext = this.getFacesContext();
        if (facesContext != null) {
            DTUIViewRoot viewRoot = this._viewRootHandle.getCachedViewRoot();
            if (viewRoot == null || viewRoot.isStale()) {
                this.update();
            }
            return viewRoot;
        }
        return null;
    }

    private DTUIViewRoot.StalenessListener getOrCreateListener() {
        if (this._stalenessListener == null) {
            this._stalenessListener = new DTUIViewRoot.StalenessListener(){

                protected void stalenessChanged(DTUIViewRoot.StalenessEvent event) {
                    switch (event.getChangeType()) {
                        case VIEW_DEFN_CHANGED: 
                        case PROJECT_CLEANED: {
                            DTJSFViewModel.this.update();
                        }
                        case VIEW_DEFN_DELETED: 
                        case VIEW_DEFN_PROJECT_CLOSED: {
                            DTUIViewRoot root = DTJSFViewModel.this._viewRootHandle.getCachedViewRoot();
                            if (root == null) break;
                            root.removeListener(DTJSFViewModel.this._stalenessListener);
                        }
                    }
                }
            };
        }
        return this._stalenessListener;
    }

    private static class UpdateRootAndRefreshJob
    extends Job {
        private final IViewRootHandle _viewRootHandle;

        public UpdateRootAndRefreshJob(IViewRootHandle viewRootHandle) {
            super(Messages.DTJSFViewModel_JobDesc);
            this._viewRootHandle = viewRootHandle;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this._viewRootHandle.updateViewRoot();
            return Status.OK_STATUS;
        }
    }
}

