/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.application.internal.operations.ComputeEARsForContextRootUpdateDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.IUpdateModuleContextRootProperties;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class ComputeEARsForContextRootUpdateOp
extends AbstractDataModelOperation
implements IUpdateModuleContextRootProperties {
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        IProject project = (IProject)this.model.getProperty("IServerContextRootDataModelProperties.PROJECT");
        ArrayList<IProject> earsToUpdate = new ArrayList<IProject>();
        try {
            try {
                IProject[] ears = J2EEProjectUtilities.getReferencingEARProjects(project);
                int i = 0;
                while (i < ears.length) {
                    if (this.currentRootEqualsEARRoot(ears[i], project)) {
                        earsToUpdate.add(ears[i]);
                    }
                    ++i;
                }
                IDataModel nestedModel = DataModelFactory.createDataModel((IDataModelProvider)new ComputeEARsForContextRootUpdateDataModelProvider());
                nestedModel.setProperty("IUpdateModuleContextRootProperties.EARS_TO_UPDATE", earsToUpdate);
                this.model.addNestedModel("UpdateModuleContextRootModel", nestedModel);
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return OK_STATUS;
    }

    private boolean currentRootEqualsEARRoot(IProject earProject, IProject moduleProject) {
        EARArtifactEdit earEdit = null;
        try {
            Properties props;
            earEdit = EARArtifactEdit.getEARArtifactEditForRead(earProject);
            if (earEdit == null) {
                return false;
            }
            Application app = earEdit.getApplication();
            IVirtualComponent comp = ComponentCore.createComponent((IProject)moduleProject);
            if (app == null || comp == null) {
                return false;
            }
            String moduleURI = earEdit.getModuleURI(comp);
            Module module = app.getFirstModule(moduleURI);
            if (module != null && module instanceof WebModule && (props = comp.getMetaProperties()) != null && props.containsKey("context-root")) {
                boolean bl = ((WebModule)module).getContextRoot().equals(props.getProperty("context-root"));
                return bl;
            }
        }
        finally {
            if (earEdit != null) {
                earEdit.dispose();
            }
        }
        return false;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

