/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTagParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.CoreNodeList;
import org.eclipse.wst.sse.core.internal.text.MinimalDocument;
import org.eclipse.wst.sse.core.internal.text.StructuredDocumentRegionIterator;
import org.eclipse.wst.sse.core.internal.text.SubSetTextStore;
import org.eclipse.wst.sse.core.internal.text.TextRegionListImpl;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class StructuredDocumentReParser
implements IStructuredTextReParser {
    protected IStructuredDocumentRegion dirtyEnd = null;
    protected IStructuredDocumentRegion dirtyStart = null;
    private final String doubleQuote = new String(new char[]{'\"'});
    protected final CoreNodeList EMPTY_LIST = new CoreNodeList();
    protected String fChanges;
    protected String fDeletedText;
    private FindReplaceDocumentAdapter fFindReplaceDocumentAdapter = null;
    protected int fLengthDifference;
    protected int fLengthToReplace;
    protected Object fRequester;
    protected int fStart;
    protected BasicStructuredDocument fStructuredDocument;
    protected boolean isParsing;
    private final String singleQuote = new String(new char[]{'\''});

    public StructuredDocumentEvent _checkBlockNodeList(List blockTagList) {
        StructuredDocumentEvent result = null;
        if (blockTagList != null) {
            int i = 0;
            while (i < blockTagList.size()) {
                BlockMarker blockTag = (BlockMarker)blockTagList.get(i);
                String tagName = blockTag.getTagName();
                result = this.checkForCriticalName("<" + tagName);
                if (result != null || (result = this.checkForCriticalName("</" + tagName)) != null) break;
                ++i;
            }
        }
        return result;
    }

    private StructuredDocumentEvent _checkForCriticalWord(String criticalTarget, boolean checkEnd) {
        boolean toBeCriticalString;
        int oldlen;
        int endNeighborhood;
        StructuredDocumentEvent result = null;
        int propLen = this.fLengthToReplace;
        int documentLength = this.fStructuredDocument.getLength();
        if (propLen > documentLength) {
            propLen = documentLength;
        }
        int startNeighborhood = this.fStart - criticalTarget.length();
        int adjustInsert = 0;
        if (startNeighborhood < 0) {
            adjustInsert = 0 - startNeighborhood;
            startNeighborhood = 0;
        }
        if ((endNeighborhood = this.fStart + this.fLengthToReplace + criticalTarget.length() - 1) > documentLength) {
            endNeighborhood = documentLength - 1;
        }
        if ((oldlen = endNeighborhood - startNeighborhood) + startNeighborhood > documentLength) {
            oldlen = documentLength - startNeighborhood;
        }
        String oldText = this.fStructuredDocument.get(startNeighborhood, oldlen);
        String peek = StringUtils.paste(oldText, this.fChanges, criticalTarget.length() - adjustInsert, this.fLengthToReplace);
        boolean isCriticalString = this.checkTagNames(oldText, criticalTarget, checkEnd);
        if (isCriticalString != (toBeCriticalString = this.checkTagNames(peek, criticalTarget, checkEnd)) || isCriticalString && toBeCriticalString && this.changeInIsEndedState(oldText, peek)) {
            result = this.reparse(0, documentLength - 1);
        }
        return result;
    }

    private int _computeStartOfDifferences(CoreNodeList oldNodes, CoreNodeList newNodes) {
        int startOfDifferences = -1;
        int newNodesLength = newNodes.getLength();
        boolean foundDifference = false;
        boolean done = false;
        int oldNodesLength = oldNodes.getLength();
        while (!done && ++startOfDifferences < oldNodesLength) {
            IStructuredDocumentRegion oldNode = oldNodes.item(startOfDifferences);
            if (this._lessThanEffectedRegion(oldNode)) {
                if (startOfDifferences > newNodesLength) {
                    foundDifference = false;
                    done = true;
                    continue;
                }
                IStructuredDocumentRegion newNode = newNodes.item(startOfDifferences);
                if (!oldNode.sameAs(newNode, 0)) {
                    foundDifference = true;
                    done = true;
                    continue;
                }
                oldNode.setParentDocument(this.fStructuredDocument);
                continue;
            }
            foundDifference = true;
            done = true;
        }
        if (!foundDifference) {
            if (newNodesLength == oldNodesLength) {
                startOfDifferences = -1;
            } else if (newNodesLength > oldNodesLength) {
                startOfDifferences = oldNodesLength;
            } else if (newNodesLength < oldNodesLength) {
                startOfDifferences = newNodesLength;
            }
        }
        return startOfDifferences;
    }

    private int _computeStartOfDifferences(IStructuredDocumentRegion oldNodeParam, ITextRegionList oldRegions, IStructuredDocumentRegion newNodeParam, ITextRegionList newRegions) {
        int startOfDifferences = -1;
        int newRegionsLength = newRegions.size();
        boolean foundDifference = false;
        boolean done = false;
        int oldRegionsLength = oldRegions.size();
        while (!done && ++startOfDifferences < oldRegionsLength) {
            ITextRegion oldRegion = oldRegions.get(startOfDifferences);
            if (this._lessThanEffectedRegion(oldNodeParam, oldRegion)) {
                if (startOfDifferences > newRegionsLength) {
                    foundDifference = false;
                    done = true;
                    continue;
                }
                ITextRegion newRegion = newRegions.get(startOfDifferences);
                if (oldNodeParam.sameAs(oldRegion, newNodeParam, newRegion, 0)) continue;
                foundDifference = true;
                done = true;
                continue;
            }
            foundDifference = true;
            done = true;
        }
        if (!foundDifference) {
            if (newRegionsLength == oldRegionsLength) {
                startOfDifferences = -1;
            } else if (newRegionsLength > oldRegionsLength) {
                startOfDifferences = oldRegionsLength;
            } else if (newRegionsLength < oldRegionsLength) {
                startOfDifferences = newRegionsLength;
            }
        }
        return startOfDifferences;
    }

    private IStructuredDocumentRegion _core_reparse_text(int rescanStart, int rescanEnd) {
        this.fStructuredDocument.resetParser(rescanStart, rescanEnd);
        return this.fStructuredDocument.getParser().getDocumentRegions();
    }

    private StructuredDocumentEvent _core_reparse_update_model(IStructuredDocumentRegion newNodesHead, int rescanStart, int rescanEnd, CoreNodeList oldNodes, boolean firstTime) {
        StructuredDocumentEvent result = null;
        CoreNodeList newNodes = null;
        newNodes = new CoreNodeList(newNodesHead);
        StructuredDocumentRegionIterator.adjustStart(newNodesHead, rescanStart);
        StructuredDocumentRegionIterator.setParentDocument(newNodesHead, (IStructuredDocument)this.fStructuredDocument);
        if (firstTime) {
            this.fStructuredDocument.setCachedDocumentRegion(newNodesHead);
            this.fStructuredDocument.initializeFirstAndLastDocumentRegion();
            result = new StructuredDocumentRegionsReplacedEvent(this.fStructuredDocument, this.fRequester, oldNodes, newNodes, this.fChanges, this.fStart, this.fLengthToReplace);
        } else {
            result = this.minimumEvent(oldNodes, newNodes);
        }
        result.setDeletedText(this.fDeletedText);
        return result;
    }

    private CoreNodeList _formMinimumList(CoreNodeList flatnodes, int startOfDifferences, int endOfDifferences) {
        CoreNodeList minimalNodes = null;
        minimalNodes = startOfDifferences == -1 ? this.EMPTY_LIST : (flatnodes.getLength() == 0 ? this.EMPTY_LIST : (startOfDifferences > endOfDifferences ? this.EMPTY_LIST : (endOfDifferences > -1 ? new CoreNodeList(flatnodes.item(startOfDifferences), flatnodes.item(endOfDifferences)) : flatnodes)));
        return minimalNodes;
    }

    private boolean _greaterThanEffectedRegion(IStructuredDocumentRegion oldNode) {
        int changedRegionEnd;
        boolean result = false;
        int nodeStart = oldNode.getStartOffset();
        result = nodeStart > (changedRegionEnd = this.fStart + this.fLengthToReplace - 1);
        return result;
    }

    private boolean _greaterThanEffectedRegion(IStructuredDocumentRegion oldNode, ITextRegion oldRegion) {
        int effectedRegionEnd;
        boolean result = false;
        int regionStartOffset = oldNode.getStartOffset(oldRegion);
        result = regionStartOffset > (effectedRegionEnd = this.fStart + this.fLengthToReplace - 1);
        return result;
    }

    private boolean _lessThanEffectedRegion(IStructuredDocumentRegion oldNode) {
        boolean result = false;
        int nodeEnd = oldNode.getEndOffset() - 1;
        result = nodeEnd < this.fStart;
        return result;
    }

    private boolean _lessThanEffectedRegion(IStructuredDocumentRegion oldNode, ITextRegion oldRegion) {
        boolean result = false;
        int nodeEnd = oldNode.getEndOffset(oldRegion) - 1;
        result = nodeEnd < this.fStart;
        return result;
    }

    private boolean _regionsSameKind(ITextRegion newRegion, ITextRegion oldRegion) {
        boolean result = false;
        if (this.isCollectionRegion(oldRegion) != this.isCollectionRegion(newRegion)) {
            result = false;
        } else if (oldRegion.getType() == newRegion.getType()) {
            result = true;
        }
        return result;
    }

    private boolean changeInIsEndedState(String oldText, String newText) {
        int nNew;
        int nOld = StringUtils.occurrencesOf(oldText, '>');
        return nOld != (nNew = StringUtils.occurrencesOf(newText, '>'));
    }

    private void checkAndAssignParent(IStructuredDocumentRegion oldNode, ITextRegion region) {
        if (region instanceof ITextRegionContainer) {
            ((ITextRegionContainer)region).setParent(oldNode);
            return;
        }
        if (region instanceof ITextRegionCollection) {
            ITextRegionCollection textRegionCollection = (ITextRegionCollection)region;
            ITextRegionList regionList = textRegionCollection.getRegions();
            int i = 0;
            while (i < regionList.size()) {
                ITextRegion innerRegion = regionList.get(i);
                this.checkAndAssignParent(oldNode, innerRegion);
                ++i;
            }
        }
    }

    private StructuredDocumentEvent checkForCDATA() {
        StructuredDocumentEvent result = null;
        result = this.checkForCriticalKey("<![CDATA[");
        if (result == null) {
            result = this.checkForCriticalKey("]]>");
        }
        return result;
    }

    protected StructuredDocumentEvent checkForComments() {
        StructuredDocumentEvent result = null;
        result = this.checkForCriticalKey("<!--");
        if (result == null) {
            result = this.checkForCriticalKey("-->");
        }
        if (result == null) {
            result = this.checkForCriticalKey("<!--->");
        }
        return result;
    }

    protected StructuredDocumentEvent checkForCriticalKey(String criticalTarget) {
        return this._checkForCriticalWord(criticalTarget, false);
    }

    private StructuredDocumentEvent checkForCriticalName(String criticalTarget) {
        return this._checkForCriticalWord(criticalTarget, true);
    }

    protected StructuredDocumentEvent checkForCrossStructuredDocumentRegionBoundryCases() {
        RegionParser parser;
        StructuredDocumentEvent result = null;
        if (result == null) {
            result = this.checkForCrossStructuredDocumentRegionSyntax();
        }
        if (result == null && (parser = this.fStructuredDocument.getParser()) instanceof BlockTagParser) {
            List blockTags = ((BlockTagParser)((Object)parser)).getBlockMarkers();
            result = this._checkBlockNodeList(blockTags);
        }
        if (result != null) {
            result.setDeletedText(this.fDeletedText);
        }
        return result;
    }

    protected StructuredDocumentEvent checkForCrossStructuredDocumentRegionSyntax() {
        StructuredDocumentEvent result = this.checkForQuotes();
        if (result == null) {
            result = this.checkForComments();
        }
        if (result == null) {
            result = this.checkForPI();
        }
        if (result == null) {
            result = this.checkForCDATA();
        }
        return result;
    }

    private StructuredDocumentEvent checkForNoChange() {
        NoChangeEvent result = null;
        if (this.fChanges != null && this.fDeletedText != null && this.fChanges.length() == this.fDeletedText.length() && this.fChanges.equals(this.fDeletedText)) {
            result = new NoChangeEvent(this.fStructuredDocument, this.fRequester, this.fChanges, this.fStart, this.fLengthToReplace);
        }
        return result;
    }

    private StructuredDocumentEvent checkForPI() {
        StructuredDocumentEvent result = null;
        result = this.checkForCriticalKey("<?");
        if (result == null) {
            result = this.checkForCriticalKey("?>");
        }
        return result;
    }

    private StructuredDocumentEvent checkForQuotes() {
        if (this.fChanges == null) {
            this.fChanges = "";
        }
        StructuredDocumentEvent result = null;
        try {
            int dirtyStartPos = -1;
            String proposedDeletion = this.fStructuredDocument.get(this.fStart, this.fLengthToReplace);
            if (this.fStart < this.fStructuredDocument.getLength()) {
                IRegion doubleQuoteRegion;
                if (this.fChanges.indexOf(this.singleQuote) > -1 || proposedDeletion.indexOf(this.singleQuote) > -1) {
                    IRegion singleQuoteRegion = this.getFindReplaceDocumentAdapter().find(this.fStart, this.singleQuote, false, false, false, false);
                    if (singleQuoteRegion != null) {
                        dirtyStartPos = singleQuoteRegion.getOffset();
                    }
                } else if ((this.fChanges.indexOf(this.doubleQuote) > -1 || proposedDeletion.indexOf(this.doubleQuote) > -1) && (doubleQuoteRegion = this.getFindReplaceDocumentAdapter().find(this.fStart, this.doubleQuote, false, false, false, false)) != null) {
                    dirtyStartPos = doubleQuoteRegion.getOffset();
                }
            }
            if (dirtyStartPos > -1) {
                result = this.reparse(dirtyStartPos, this.fStructuredDocument.getLength() - 1);
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        if (result != null) {
            result.setDeletedText(this.fDeletedText);
        }
        return result;
    }

    private StructuredDocumentEvent checkHeuristics() {
        StructuredDocumentEvent result = null;
        result = this.checkForNoChange();
        if (result == null && (result = this.checkForCrossStructuredDocumentRegionBoundryCases()) == null) {
            result = this.quickCheck();
        }
        return result;
    }

    private boolean checkTagNames(String compareText, String criticalTarget, boolean checkEnd) {
        int lastPos;
        boolean result = false;
        if (compareText == null || criticalTarget == null) {
            return false;
        }
        int posOfCriticalWord = compareText.toLowerCase().indexOf(criticalTarget.toLowerCase());
        boolean bl = result = posOfCriticalWord > -1;
        if (checkEnd && result && (lastPos = posOfCriticalWord + criticalTarget.length()) < compareText.length()) {
            char lastChar = compareText.charAt(lastPos);
            result = !Character.isLetterOrDigit(lastChar);
        }
        return result;
    }

    protected StructuredDocumentEvent core_reparse(int rescanStart, int rescanEnd, CoreNodeList oldNodes, boolean firstTime) {
        IStructuredDocumentRegion newNodesHead = null;
        StructuredDocumentEvent result = null;
        newNodesHead = this._core_reparse_text(rescanStart, rescanEnd);
        result = this._core_reparse_update_model(newNodesHead, rescanStart, rescanEnd, oldNodes, firstTime);
        return result;
    }

    private synchronized void endReParse() {
        this.isParsing = false;
        this.dirtyStart = null;
        this.dirtyEnd = null;
    }

    protected IStructuredDocumentRegion findDirtyEnd(int end) {
        IStructuredDocumentRegion result = this.fStructuredDocument.getRegionAtCharacterOffset(end);
        if (result != null && !result.isEnded() && result.getNext() != null) {
            result = result.getNext();
        }
        if (result != null && end == result.getEnd() && result.getNext() != null) {
            result = result.getNext();
        }
        if (result != null) {
            this.fStructuredDocument.setCachedDocumentRegion(result);
        }
        this.dirtyEnd = result;
        return this.dirtyEnd;
    }

    protected void findDirtyStart(int start) {
        IStructuredDocumentRegion result = this.fStructuredDocument.getRegionAtCharacterOffset(start);
        if (result != null) {
            IStructuredDocumentRegion potential;
            IStructuredDocumentRegion previous = result.getPrevious();
            if (!(previous == null || previous.isEnded() && start != result.getStart())) {
                result = previous;
            }
            if ((potential = result) != null) {
                result = potential;
                this.fStructuredDocument.setCachedDocumentRegion(result);
            }
        }
        this.dirtyStart = result;
    }

    protected CoreNodeList formOldNodes(IStructuredDocumentRegion dirtyStart, IStructuredDocumentRegion dirtyEnd) {
        CoreNodeList oldNodes = new CoreNodeList(dirtyStart, dirtyEnd);
        String oldText = null;
        int oldStart = -1;
        int oldEnd = -1;
        if (dirtyStart != null) {
            oldStart = dirtyStart.getStart();
            oldEnd = dirtyEnd.getEnd();
            oldText = this.fStructuredDocument.get(oldStart, oldEnd - oldStart);
        } else {
            oldStart = 0;
            oldEnd = 0;
            oldText = "";
        }
        SubSetTextStore subTextStore = new SubSetTextStore(oldText, oldStart, oldEnd, this.fStructuredDocument.getLength());
        StructuredDocumentRegionIterator.setParentDocument(oldNodes, (IStructuredDocument)new MinimalDocument(subTextStore));
        return oldNodes;
    }

    public FindReplaceDocumentAdapter getFindReplaceDocumentAdapter() {
        if (this.fFindReplaceDocumentAdapter == null) {
            this.fFindReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fStructuredDocument);
        }
        return this.fFindReplaceDocumentAdapter;
    }

    public void initialize(Object requester, int start, int lengthToReplace, String changes) {
        this.isParsing = true;
        this.fRequester = requester;
        this.fStart = start;
        this.fLengthToReplace = lengthToReplace;
        this.fChanges = changes;
        this.fLengthDifference = Utilities.calculateLengthDifference(this.fChanges, this.fLengthToReplace);
        this.fDeletedText = this.fStructuredDocument.get(this.fStart, this.fLengthToReplace);
    }

    protected void insertNodes(IStructuredDocumentRegion previousOldNode, IStructuredDocumentRegion nextOldNode, CoreNodeList newNodes) {
        IStructuredDocumentRegion firstNew = null;
        IStructuredDocumentRegion lastNew = null;
        IStructuredDocumentRegion oldPrevious = previousOldNode;
        IStructuredDocumentRegion oldNext = nextOldNode;
        if (newNodes.getLength() > 0) {
            firstNew = newNodes.item(0);
            lastNew = newNodes.item(newNodes.getLength() - 1);
            if (oldPrevious != null) {
                oldPrevious.setNext(firstNew);
            }
            if (oldNext != null) {
                oldNext.setPrevious(lastNew);
            } else {
                this.fStructuredDocument.setLastDocumentRegion(newNodes.item(newNodes.getLength() - 1));
            }
            if (firstNew != null) {
                firstNew.setPrevious(oldPrevious);
            }
            if (lastNew != null) {
                lastNew.setNext(oldNext);
            }
        }
    }

    private boolean isCollectionRegion(ITextRegion aRegion) {
        return aRegion instanceof ITextRegionCollection;
    }

    public boolean isParsing() {
        return this.isParsing;
    }

    protected StructuredDocumentEvent minimumEvent(CoreNodeList oldNodes, CoreNodeList newNodes) {
        StructuredDocumentEvent event = null;
        CoreNodeList minimalOldNodes = null;
        CoreNodeList minimalNewNodes = null;
        int startOfDifferences = this._computeStartOfDifferences(oldNodes, newNodes);
        int endOfDifferencesOld = -1;
        int endOfDifferencesNew = -1;
        if (startOfDifferences >= oldNodes.getLength() || startOfDifferences >= newNodes.getLength()) {
            if (oldNodes.getLength() < newNodes.getLength()) {
                minimalOldNodes = this.EMPTY_LIST;
                endOfDifferencesNew = newNodes.getLength() - 1;
                minimalNewNodes = this._formMinimumList(newNodes, startOfDifferences, endOfDifferencesNew);
            } else if (oldNodes.getLength() > newNodes.getLength()) {
                endOfDifferencesOld = oldNodes.getLength() - 1;
                minimalOldNodes = this._formMinimumList(oldNodes, startOfDifferences, endOfDifferencesOld);
                minimalNewNodes = this.EMPTY_LIST;
            } else {
                event = new NoChangeEvent(this.fStructuredDocument, this.fRequester, this.fChanges, this.fStart, this.fLengthToReplace);
            }
        } else {
            int indexOld = oldNodes.getLength() - 1;
            int indexNew = newNodes.getLength() - 1;
            while (indexOld >= startOfDifferences && this._greaterThanEffectedRegion(oldNodes.item(indexOld))) {
                if (!oldNodes.item(indexOld).sameAs(newNodes.item(indexNew), this.fLengthDifference)) break;
                oldNodes.item(indexOld).setParentDocument(this.fStructuredDocument);
                --indexOld;
                --indexNew;
            }
            endOfDifferencesOld = indexOld;
            endOfDifferencesNew = indexNew;
            minimalOldNodes = this._formMinimumList(oldNodes, startOfDifferences, endOfDifferencesOld);
            minimalNewNodes = this._formMinimumList(newNodes, startOfDifferences, endOfDifferencesNew);
        }
        IStructuredDocumentRegion firstDownStreamNode = null;
        event = this.regionCheck(minimalOldNodes, minimalNewNodes);
        if (event != null) {
            firstDownStreamNode = minimalOldNodes.item(0).getNext();
            if (firstDownStreamNode != null && this.fLengthDifference != 0) {
                StructuredDocumentRegionIterator.adjustStart(firstDownStreamNode, this.fLengthDifference);
            }
        } else {
            event = this.nodesReplacedCheck(minimalOldNodes, minimalNewNodes);
            if (minimalOldNodes.getLength() == 0 && minimalNewNodes.getLength() > 0) {
                int insertOffset = minimalNewNodes.item(0).getStartOffset();
                IStructuredDocumentRegion lastOldUnchangedNode = null;
                if (insertOffset > 0) {
                    lastOldUnchangedNode = this.fStructuredDocument.getRegionAtCharacterOffset(insertOffset - 1);
                    firstDownStreamNode = lastOldUnchangedNode.getNext();
                } else {
                    firstDownStreamNode = this.fStructuredDocument.getFirstStructuredDocumentRegion();
                    this.fStructuredDocument.setFirstDocumentRegion(minimalNewNodes.item(0));
                }
                StructuredDocumentRegionIterator.adjustStart(firstDownStreamNode, this.fLengthDifference);
                this.insertNodes(lastOldUnchangedNode, firstDownStreamNode, minimalNewNodes);
                this.reSetCachedNode(minimalOldNodes, minimalNewNodes);
            } else {
                firstDownStreamNode = this.switchNodeLists(minimalOldNodes, minimalNewNodes);
                if (firstDownStreamNode != null) {
                    StructuredDocumentRegionIterator.adjustStart(firstDownStreamNode, this.fLengthDifference);
                }
                this.reSetCachedNode(minimalOldNodes, minimalNewNodes);
            }
        }
        return event;
    }

    public IStructuredTextReParser newInstance() {
        return new StructuredDocumentReParser();
    }

    protected StructuredDocumentEvent nodesReplacedCheck(CoreNodeList oldNodes, CoreNodeList newNodes) {
        StructuredDocumentRegionsReplacedEvent result = new StructuredDocumentRegionsReplacedEvent(this.fStructuredDocument, this.fRequester, oldNodes, newNodes, this.fChanges, this.fStart, this.fLengthToReplace);
        return result;
    }

    public StructuredDocumentEvent quickCheck() {
        IStructuredDocumentRegion targetNode;
        StructuredDocumentEvent result = null;
        if (this.dirtyStart != null && this.dirtyStart == this.dirtyEnd && (result = this.dirtyStart.updateRegion(this.fRequester, targetNode = this.dirtyStart, this.fChanges, this.fStart, this.fLengthToReplace)) != null) {
            this.fStructuredDocument.updateDocumentData(this.fStart, this.fLengthToReplace, this.fChanges);
            IStructuredDocumentRegion firstDownStreamNode = targetNode.getNext();
            if (firstDownStreamNode != null) {
                StructuredDocumentRegionIterator.adjustStart(firstDownStreamNode, this.fLengthDifference);
            }
        }
        if (result != null) {
            result.setDeletedText(this.fDeletedText);
        }
        return result;
    }

    protected StructuredDocumentEvent regionCheck(CoreNodeList oldNodes, CoreNodeList newNodes) {
        StructuredDocumentEvent result = null;
        int oldLength = oldNodes.getLength();
        int newLength = newNodes.getLength();
        if (oldLength != 1 || newLength != 1) {
            result = null;
        } else {
            IStructuredDocumentRegion oldNode = oldNodes.item(0);
            IStructuredDocumentRegion newNode = newNodes.item(0);
            result = this.regionCheck(oldNode, newNode);
        }
        return result;
    }

    protected StructuredDocumentEvent regionCheck(IStructuredDocumentRegion oldNode, IStructuredDocumentRegion newNode) {
        StructuredDocumentEvent result = null;
        ITextRegionList oldRegions = oldNode.getRegions();
        ITextRegionList newRegions = newNode.getRegions();
        ITextRegion[] oldRegionsArray = oldRegions.toArray();
        ITextRegion[] newRegionsArray = newRegions.toArray();
        int startOfDifferences = this._computeStartOfDifferences(oldNode, oldRegions, newNode, newRegions);
        int endOfDifferencesOld = -1;
        int endOfDifferencesNew = -1;
        if (startOfDifferences >= oldRegions.size() || startOfDifferences >= newRegions.size()) {
            if (oldRegions.size() < newRegions.size()) {
                startOfDifferences = oldRegionsArray.length;
                endOfDifferencesOld = oldRegionsArray.length - 1;
                endOfDifferencesNew = newRegionsArray.length - 1;
            } else if (oldRegions.size() > newRegions.size()) {
                startOfDifferences = newRegionsArray.length;
                endOfDifferencesOld = oldRegionsArray.length - 1;
                endOfDifferencesNew = newRegionsArray.length - 1;
            } else {
                result = new NoChangeEvent(this.fStructuredDocument, this.fRequester, this.fChanges, this.fStart, this.fLengthToReplace);
            }
        } else if (startOfDifferences > -1 && endOfDifferencesOld < 0 && endOfDifferencesNew < 0) {
            int indexOld = oldRegionsArray.length - 1;
            int indexNew = newRegionsArray.length - 1;
            while (indexOld >= startOfDifferences && this._greaterThanEffectedRegion(oldNode, oldRegionsArray[indexOld])) {
                if (!oldNode.sameAs(oldRegionsArray[indexOld], newNode, newRegionsArray[indexNew], this.fLengthDifference)) break;
                --indexOld;
                --indexNew;
            }
            endOfDifferencesOld = indexOld;
            endOfDifferencesNew = indexNew;
        }
        if (result == null) {
            int i;
            TextRegionListImpl holdOldRegions = new TextRegionListImpl();
            TextRegionListImpl holdNewRegions = new TextRegionListImpl();
            if (startOfDifferences > -1 && endOfDifferencesOld > -1) {
                i = startOfDifferences;
                while (i <= endOfDifferencesOld) {
                    holdOldRegions.add(oldRegionsArray[i]);
                    ++i;
                }
            }
            if (startOfDifferences > -1 && endOfDifferencesNew > -1) {
                i = startOfDifferences;
                while (i <= endOfDifferencesNew) {
                    holdNewRegions.add(newRegionsArray[i]);
                    ++i;
                }
            }
            if (holdOldRegions.size() == 0 && holdNewRegions.size() == 0) {
                result = new NoChangeEvent(this.fStructuredDocument, this.fRequester, this.fChanges, this.fStart, this.fLengthToReplace);
            } else if (holdOldRegions.size() == 1 && holdNewRegions.size() == 1 && this._regionsSameKind(holdNewRegions.get(0), holdOldRegions.get(0))) {
                ITextRegion newOldRegion = this.swapNewForOldRegion(oldNode, holdOldRegions.get(0), newNode, holdNewRegions.get(0));
                this.updateDownStreamRegions(oldNode, newOldRegion);
                result = new RegionChangedEvent(this.fStructuredDocument, this.fRequester, oldNode, newOldRegion, this.fChanges, this.fStart, this.fLengthToReplace);
            } else {
                this.replaceRegions(oldNode, holdOldRegions, newNode, holdNewRegions);
                result = new RegionsReplacedEvent(this.fStructuredDocument, this.fRequester, oldNode, holdOldRegions, holdNewRegions, this.fChanges, this.fStart, this.fLengthToReplace);
            }
        }
        return result;
    }

    public StructuredDocumentEvent reparse() {
        StructuredDocumentEvent result = null;
        if (this.fStructuredDocument.getCachedDocumentRegion() != null) {
            this.findDirtyStart(this.fStart);
            int end = this.fStart + this.fLengthToReplace;
            this.findDirtyEnd(end);
        }
        if (this.fStructuredDocument.getCachedDocumentRegion() != null) {
            result = this.checkHeuristics();
        }
        if (result == null) {
            result = this.reparse(this.dirtyStart, this.dirtyEnd);
        }
        this.endReParse();
        return result;
    }

    protected StructuredDocumentEvent reparse(int reScanStartHint, int reScanEndHint) {
        StructuredDocumentEvent result = null;
        if (this.fStructuredDocument.getCachedDocumentRegion() != null) {
            this.findDirtyStart(reScanStartHint);
            this.findDirtyEnd(reScanEndHint);
        }
        result = this.reparse(this.dirtyStart, this.dirtyEnd);
        this.isParsing = false;
        return result;
    }

    protected StructuredDocumentEvent reparse(IStructuredDocumentRegion dirtyStart, IStructuredDocumentRegion dirtyEnd) {
        StructuredDocumentEvent result = null;
        int rescanStart = -1;
        int rescanEnd = -1;
        boolean firstTime = false;
        CoreNodeList oldNodes = this.formOldNodes(dirtyStart, dirtyEnd);
        if (dirtyStart == null || dirtyEnd == null) {
            rescanStart = 0;
            rescanEnd = this.fChanges.length();
            firstTime = true;
        } else {
            rescanStart = dirtyStart.getStart();
            rescanEnd = dirtyEnd.getEnd() + this.fLengthDifference;
        }
        this.fStructuredDocument.updateDocumentData(this.fStart, this.fLengthToReplace, this.fChanges);
        result = this.core_reparse(rescanStart, rescanEnd, oldNodes, firstTime);
        return result;
    }

    protected void replaceRegions(IStructuredDocumentRegion oldNode, ITextRegionList oldRegions, IStructuredDocumentRegion newNode, ITextRegionList newRegions) {
        int insertPos = -1;
        ITextRegionList regions = oldNode.getRegions();
        if (oldRegions.size() == 0) {
            ITextRegion regionAtOffset;
            ITextRegion firstNewRegion = newRegions.get(0);
            int firstOffset = newNode.getStartOffset(firstNewRegion);
            insertPos = firstOffset == 0 ? 0 : ((regionAtOffset = oldNode.getRegionAtCharacterOffset(firstOffset)) == null ? regions.size() : regions.indexOf(regionAtOffset));
        } else {
            ITextRegion firstOldRegion = oldRegions.get(0);
            insertPos = regions.indexOf(firstOldRegion);
            regions.removeAll(oldRegions);
        }
        regions.addAll(insertPos, newRegions);
        ITextRegionList allNewRegions = newNode.getRegions();
        int i = 0;
        while (i < regions.size()) {
            ITextRegion nextOldishRegion = regions.get(i);
            ITextRegion nextNewRegion = allNewRegions.get(i);
            nextOldishRegion.equatePositions(nextNewRegion);
            this.checkAndAssignParent(oldNode, nextOldishRegion);
            ++i;
        }
        oldNode.setLength(newNode.getLength());
        oldNode.setEnded(newNode.isEnded());
        oldNode.setParentDocument(newNode.getParentDocument());
    }

    private void reSetCachedNode(CoreNodeList oldNodes, CoreNodeList newNodes) {
        if (newNodes.getLength() > 0) {
            this.fStructuredDocument.setCachedDocumentRegion(newNodes.item(newNodes.getLength() - 1));
        } else {
            if (this.fStructuredDocument.getCachedDocumentRegion() != null && oldNodes.getLength() > 0 && oldNodes.includes(this.fStructuredDocument.getCachedDocumentRegion())) {
                this.fStructuredDocument.setCachedDocumentRegion(this.fStructuredDocument.getFirstStructuredDocumentRegion());
            }
            this.fStructuredDocument.getCachedDocumentRegion();
        }
    }

    public void setStructuredDocument(IStructuredDocument newStructuredDocument) {
        this.fStructuredDocument = (BasicStructuredDocument)newStructuredDocument;
        this.fFindReplaceDocumentAdapter = null;
    }

    private IStructuredDocumentRegion splice(CoreNodeList oldNodes, CoreNodeList newNodes) {
        IStructuredDocumentRegion firstOld = null;
        IStructuredDocumentRegion firstNew = null;
        IStructuredDocumentRegion lastOld = null;
        IStructuredDocumentRegion lastNew = null;
        IStructuredDocumentRegion oldPrevious = null;
        IStructuredDocumentRegion oldNext = null;
        IStructuredDocumentRegion newPrevious = null;
        IStructuredDocumentRegion newNext = null;
        if (oldNodes.getLength() == 0 && newNodes.getLength() == 0) {
            return null;
        }
        if (newNodes.getLength() > 0) {
            firstNew = newNodes.item(0);
            lastNew = newNodes.item(newNodes.getLength() - 1);
        }
        if (oldNodes.getLength() > 0) {
            firstOld = oldNodes.item(0);
            lastOld = oldNodes.item(oldNodes.getLength() - 1);
            if (firstOld != null) {
                oldPrevious = firstOld.getPrevious();
            }
            if (lastOld != null) {
                oldNext = lastOld.getNext();
            }
        }
        if (newNodes.getLength() > 0) {
            if (oldPrevious != null) {
                oldPrevious.setNext(firstNew);
            }
            if (newPrevious != null) {
                newPrevious.setNext(firstOld);
            }
            if (oldNext != null) {
                oldNext.setPrevious(lastNew);
            }
            if (newNext != null) {
                newNext.setPrevious(lastOld);
            }
            if (firstOld != null) {
                firstOld.setPrevious(newPrevious);
            }
            if (lastOld != null) {
                lastOld.setNext(newNext);
            }
            if (firstNew != null) {
                firstNew.setPrevious(oldPrevious);
            }
            if (lastNew != null) {
                lastNew.setNext(oldNext);
            }
        } else {
            if (oldPrevious != null) {
                oldPrevious.setNext(oldNext);
            }
            if (oldNext != null) {
                oldNext.setPrevious(oldPrevious);
            }
        }
        if (oldNext == null && oldNodes.getLength() > 0) {
            if (newNodes.getLength() > 0) {
                this.fStructuredDocument.setLastDocumentRegion(lastNew);
            } else {
                this.fStructuredDocument.setLastDocumentRegion(firstOld.getPrevious());
            }
        }
        if (oldPrevious == null && oldNodes.getLength() > 0) {
            if (newNodes.getLength() > 0) {
                this.fStructuredDocument.setFirstDocumentRegion(firstNew);
            } else {
                this.fStructuredDocument.setFirstDocumentRegion(lastOld.getNext());
            }
        }
        return oldNext;
    }

    private ITextRegion swapNewForOldRegion(IStructuredDocumentRegion oldNode, ITextRegion oldRegion, IStructuredDocumentRegion newNode, ITextRegion newRegion) {
        oldRegion.equatePositions(newRegion);
        oldNode.setLength(newNode.getLength());
        oldNode.setEnded(newNode.isEnded());
        oldNode.setParentDocument(newNode.getParentDocument());
        if (this.isCollectionRegion(oldRegion)) {
            this.transferEmbeddedRegions(oldNode, (ITextRegionContainer)oldRegion, (ITextRegionContainer)newRegion);
        }
        return oldRegion;
    }

    private IStructuredDocumentRegion switchNodeLists(CoreNodeList oldNodes, CoreNodeList newNodes) {
        IStructuredDocumentRegion result = this.splice(oldNodes, newNodes);
        if (oldNodes.getLength() > 0) {
            IStructuredDocumentRegion firstItem = oldNodes.item(0);
            firstItem.setPrevious(null);
            IStructuredDocumentRegion lastItem = oldNodes.item(oldNodes.getLength() - 1);
            lastItem.setNext(null);
        }
        return result;
    }

    private void transferEmbeddedRegions(IStructuredDocumentRegion oldNode, ITextRegionContainer oldRegion, ITextRegionContainer newRegion) {
        ITextRegionList newRegionsToTransfer = newRegion.getRegions();
        oldRegion.setRegions(newRegionsToTransfer);
        Iterator newRegionsInOldOne = newRegionsToTransfer.iterator();
        while (newRegionsInOldOne.hasNext()) {
            ITextRegion newOne = (ITextRegion)newRegionsInOldOne.next();
            if (!this.isCollectionRegion(newOne)) continue;
            oldRegion.setRegions(newRegion.getRegions());
        }
    }

    private void updateDownStreamRegions(IStructuredDocumentRegion flatNode, ITextRegion lastKnownRegion) {
        ITextRegion region;
        ITextRegionList regions = flatNode.getRegions();
        int listLength = regions.size();
        int startIndex = 0;
        int i = 0;
        while (i < listLength) {
            region = regions.get(i);
            if (region == lastKnownRegion) {
                startIndex = i;
                break;
            }
            ++i;
        }
        int j = ++startIndex;
        while (j < listLength) {
            region = regions.get(j);
            region.adjustStart(this.fLengthDifference);
            ++j;
        }
    }
}

