/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.RegressionTestSetup;
import org.eclipse.wst.jsdt.core.tests.junit.extension.TestCase;
import org.eclipse.wst.jsdt.core.tests.util.CompilerTestSetup;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;

public class AbstractCompilerTest
extends TestCase {
    public static final String COMPLIANCE_1_3 = "1.3";
    public static final String COMPLIANCE_1_4 = "1.4";
    public static final String COMPLIANCE_1_5 = "1.5";
    public static final String COMPLIANCE_1_6 = "1.6";
    public static final String COMPLIANCE_1_7 = "1.7";
    public static final int F_1_3 = 1;
    public static final int F_1_4 = 2;
    public static final int F_1_5 = 4;
    public static final int F_1_6 = 8;
    public static final int F_1_7 = 16;
    protected static boolean RUN_JAVAC = "enabled".equals(System.getProperty("run.javac"));
    private static int possibleComplianceLevels = RUN_JAVAC ? 4 : -1;
    protected String complianceLevel;
    protected IPath outputRootDirectoryPath = new Path(Util.getOutputDirectory());
    protected File outputTestDirectory;
    protected static Map TESTS_COUNTERS = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Test buildAllCompliancesTestSuite(Class evaluationTestClass) {
        TestSuite suite = new TestSuite(evaluationTestClass.getName());
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        if ((complianceLevels & 1) != 0) {
            suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, COMPLIANCE_1_3));
        }
        if ((complianceLevels & 2) != 0) {
            suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, COMPLIANCE_1_4));
        }
        if ((complianceLevels & 4) != 0) {
            suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, COMPLIANCE_1_5));
        }
        if ((complianceLevels & 8) != 0) {
            suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, COMPLIANCE_1_6));
        }
        if ((complianceLevels & 0x10) != 0) {
            suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, COMPLIANCE_1_7));
        }
        return suite;
    }

    public static Test buildAllCompliancesTestSuite(Class testSuiteClass, Class setupClass, List testClasses) {
        TestSuite suite = new TestSuite(testSuiteClass.getName());
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        if ((complianceLevels & 1) != 0) {
            suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, COMPLIANCE_1_3));
        }
        if ((complianceLevels & 2) != 0) {
            suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, COMPLIANCE_1_4));
        }
        if ((complianceLevels & 4) != 0) {
            suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, COMPLIANCE_1_5));
        }
        if ((complianceLevels & 8) != 0) {
            suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, COMPLIANCE_1_6));
        }
        if ((complianceLevels & 0x10) != 0) {
            suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, COMPLIANCE_1_7));
        }
        return suite;
    }

    public static Test buildComplianceTestSuite(String complianceLevel, List testClasses) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.RegressionTestSetup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return AbstractCompilerTest.buildComplianceTestSuite(testClasses, clazz, complianceLevel);
    }

    private static Test buildComplianceTestSuite(List testClasses, Class setupClass, String complianceLevel) {
        TestSuite complianceSuite = new TestSuite(complianceLevel);
        int i = 0;
        int m = testClasses.size();
        while (i < m) {
            Class testClass = (Class)testClasses.get(i);
            TestSuite suite = new TestSuite(testClass.getName());
            List tests = AbstractCompilerTest.buildTestsList(testClass);
            int index = 0;
            int size = tests.size();
            while (index < size) {
                suite.addTest((Test)tests.get(index));
                ++index;
            }
            complianceSuite.addTest((Test)suite);
            ++i;
        }
        try {
            Class[] classArray = new Class[2];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("junit.framework.Test");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Constructor constructor = setupClass.getConstructor(classArray);
            Test setUp = (Test)constructor.newInstance(complianceSuite, complianceLevel);
            return setUp;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Test buildMinimalComplianceTestSuite(Class evaluationTestClass, int minimalCompliance) {
        int level17;
        int level16;
        int level15;
        int level14;
        TestSuite suite = new TestSuite(evaluationTestClass.getName());
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        int level13 = complianceLevels & 1;
        if (level13 != 0) {
            if (level13 < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + COMPLIANCE_1_3 + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, COMPLIANCE_1_3));
            }
        }
        if ((level14 = complianceLevels & 2) != 0) {
            if (level14 < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + COMPLIANCE_1_4 + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, COMPLIANCE_1_4));
            }
        }
        if ((level15 = complianceLevels & 4) != 0) {
            if (level15 < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + COMPLIANCE_1_5 + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, COMPLIANCE_1_5));
            }
        }
        if ((level16 = complianceLevels & 8) != 0) {
            if (level16 < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + COMPLIANCE_1_6 + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, COMPLIANCE_1_6));
            }
        }
        if ((level17 = complianceLevels & 0x10) != 0) {
            if (level17 < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + COMPLIANCE_1_7 + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, COMPLIANCE_1_7));
            }
        }
        return suite;
    }

    public static Test buildUniqueComplianceTestSuite(Class evaluationTestClass, String uniqueCompliance) {
        String highestLevel = AbstractCompilerTest.highestComplianceLevels();
        if (highestLevel.compareTo(uniqueCompliance) < 0) {
            System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + highestLevel + "!");
            return new TestSuite();
        }
        TestSuite complianceSuite = new TestSuite(uniqueCompliance);
        List tests = AbstractCompilerTest.buildTestsList(evaluationTestClass);
        int index = 0;
        int size = tests.size();
        while (index < size) {
            complianceSuite.addTest((Test)tests.get(index));
            ++index;
        }
        TestSuite suite = new TestSuite(evaluationTestClass.getName());
        suite.addTest((Test)new RegressionTestSetup((Test)complianceSuite, uniqueCompliance));
        return suite;
    }

    public static String highestComplianceLevels() {
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        if ((complianceLevels & 0x10) != 0) {
            return COMPLIANCE_1_7;
        }
        if ((complianceLevels & 8) != 0) {
            return COMPLIANCE_1_6;
        }
        if ((complianceLevels & 4) != 0) {
            return COMPLIANCE_1_5;
        }
        if ((complianceLevels & 2) != 0) {
            return COMPLIANCE_1_4;
        }
        return COMPLIANCE_1_3;
    }

    public static int getPossibleComplianceLevels() {
        if (possibleComplianceLevels == -1) {
            String compliance = System.getProperty("compliance");
            if (compliance != null) {
                if (COMPLIANCE_1_3.equals(compliance)) {
                    possibleComplianceLevels = 1;
                } else if (COMPLIANCE_1_4.equals(compliance)) {
                    possibleComplianceLevels = 2;
                } else if (COMPLIANCE_1_5.equals(compliance)) {
                    possibleComplianceLevels = 4;
                } else if (COMPLIANCE_1_6.equals(compliance)) {
                    possibleComplianceLevels = 8;
                } else if (COMPLIANCE_1_7.equals(compliance)) {
                    possibleComplianceLevels = 16;
                } else {
                    System.out.println("Invalid compliance specified (" + compliance + ")");
                    System.out.print("Use one of ");
                    System.out.print("1.3, ");
                    System.out.print("1.4, ");
                    System.out.print("1.5, ");
                    System.out.print("1.6, ");
                    System.out.println(COMPLIANCE_1_7);
                    System.out.println("Defaulting to all possible compliances");
                }
            }
            if (possibleComplianceLevels == -1) {
                boolean canRun1_7;
                boolean canRun1_6;
                boolean canRun1_5;
                boolean canRun1_4;
                possibleComplianceLevels = 1;
                String specVersion = System.getProperty("java.specification.version");
                boolean bl = canRun1_4 = !"1.0".equals(specVersion) && !"1.1".equals(specVersion) && !"1.2".equals(specVersion) && !COMPLIANCE_1_3.equals(specVersion);
                if (canRun1_4) {
                    possibleComplianceLevels |= 2;
                }
                boolean bl2 = canRun1_5 = canRun1_4 && !COMPLIANCE_1_4.equals(specVersion);
                if (canRun1_5) {
                    possibleComplianceLevels |= 4;
                }
                boolean bl3 = canRun1_6 = canRun1_5 && !COMPLIANCE_1_5.equals(specVersion);
                if (canRun1_6) {
                    possibleComplianceLevels |= 8;
                }
                boolean bl4 = canRun1_7 = canRun1_6 && !COMPLIANCE_1_6.equals(specVersion);
                if (canRun1_7) {
                    possibleComplianceLevels |= 0x10;
                }
            }
        }
        return possibleComplianceLevels;
    }

    public static Test suite(String suiteName, Class setupClass, ArrayList testClasses) {
        TestSuite all = new TestSuite(suiteName);
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        if ((complianceLevels & 1) != 0) {
            all.addTest(AbstractCompilerTest.suiteForComplianceLevel(COMPLIANCE_1_3, setupClass, testClasses));
        }
        if ((complianceLevels & 2) != 0) {
            all.addTest(AbstractCompilerTest.suiteForComplianceLevel(COMPLIANCE_1_4, setupClass, testClasses));
        }
        if ((complianceLevels & 4) != 0) {
            all.addTest(AbstractCompilerTest.suiteForComplianceLevel(COMPLIANCE_1_5, setupClass, testClasses));
        }
        return all;
    }

    public static Test suiteForComplianceLevel(String complianceLevel, Class setupClass, ArrayList testClasses) {
        TestSuite suite;
        if (testClasses.size() == 1) {
            Class testClass = (Class)testClasses.get(0);
            suite = new TestSuite(testClass, complianceLevel);
            TESTS_COUNTERS.put(testClass.getName(), new Integer(suite.countTestCases()));
        } else {
            suite = new TestSuite(complianceLevel);
            int i = 0;
            int length = testClasses.size();
            while (i < length) {
                Class testClass = (Class)testClasses.get(i);
                TestSuite innerSuite = new TestSuite(testClass);
                TESTS_COUNTERS.put(testClass.getName(), new Integer(innerSuite.countTestCases()));
                suite.addTest((Test)innerSuite);
                ++i;
            }
        }
        try {
            Class[] classArray = new Class[2];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("junit.framework.Test");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Constructor constructor = setupClass.getConstructor(classArray);
            Test setUp = (Test)constructor.newInstance(suite, complianceLevel);
            return setUp;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Test setupSuite(Class clazz) {
        ArrayList<Class> testClasses = new ArrayList<Class>();
        testClasses.add(clazz);
        String string = clazz.getName();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.RegressionTestSetup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return AbstractCompilerTest.suite(string, clazz2, testClasses);
    }

    public static Test buildTestSuite(Class evaluationTestClass) {
        if (TESTS_PREFIX != null || TESTS_NAMES != null || TESTS_NUMBERS != null || TESTS_RANGE != null) {
            return AbstractCompilerTest.buildTestSuite(evaluationTestClass, AbstractCompilerTest.highestComplianceLevels());
        }
        return AbstractCompilerTest.setupSuite(evaluationTestClass);
    }

    public static Test buildTestSuite(Class evaluationTestClass, String complianceLevel) {
        TestSuite suite = new TestSuite(complianceLevel);
        List tests = AbstractCompilerTest.buildTestsList(evaluationTestClass);
        int index = 0;
        int size = tests.size();
        while (index < size) {
            suite.addTest((Test)tests.get(index));
            ++index;
        }
        TestSuite test = new TestSuite(evaluationTestClass.getName());
        test.addTest((Test)new RegressionTestSetup((Test)suite, complianceLevel));
        String className = evaluationTestClass.getName();
        int newTestsNb = test.countTestCases();
        Integer testsNb = (Integer)TESTS_COUNTERS.get(className);
        if (testsNb != null) {
            newTestsNb += testsNb.intValue();
        }
        TESTS_COUNTERS.put(className, new Integer(newTestsNb));
        return test;
    }

    public static boolean isJRELevel(int compliance) {
        return (AbstractCompilerTest.getPossibleComplianceLevels() & compliance) != 0;
    }

    public AbstractCompilerTest(String name) {
        super(name);
    }

    protected Map getCompilerOptions() {
        Map options = new CompilerOptions().getMap();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "ignore");
        if (COMPLIANCE_1_3.equals(this.complianceLevel)) {
            options.put("org.eclipse.wst.jsdt.core.compiler.compliance", COMPLIANCE_1_3);
            options.put("org.eclipse.wst.jsdt.core.compiler.source", COMPLIANCE_1_3);
            options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.1");
        } else if (COMPLIANCE_1_4.equals(this.complianceLevel)) {
            options.put("org.eclipse.wst.jsdt.core.compiler.compliance", COMPLIANCE_1_4);
            options.put("org.eclipse.wst.jsdt.core.compiler.source", COMPLIANCE_1_4);
            options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", COMPLIANCE_1_4);
        } else if (COMPLIANCE_1_5.equals(this.complianceLevel)) {
            options.put("org.eclipse.wst.jsdt.core.compiler.compliance", COMPLIANCE_1_5);
            options.put("org.eclipse.wst.jsdt.core.compiler.source", COMPLIANCE_1_5);
            options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", COMPLIANCE_1_5);
        } else if (COMPLIANCE_1_6.equals(this.complianceLevel)) {
            options.put("org.eclipse.wst.jsdt.core.compiler.compliance", COMPLIANCE_1_6);
            options.put("org.eclipse.wst.jsdt.core.compiler.source", COMPLIANCE_1_6);
            options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", COMPLIANCE_1_6);
        } else if (COMPLIANCE_1_7.equals(this.complianceLevel)) {
            options.put("org.eclipse.wst.jsdt.core.compiler.compliance", COMPLIANCE_1_7);
            options.put("org.eclipse.wst.jsdt.core.compiler.source", COMPLIANCE_1_7);
            options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", COMPLIANCE_1_7);
        }
        return options;
    }

    public String getName() {
        String name = super.getName();
        if (this.complianceLevel != null) {
            name = String.valueOf(name) + " - " + this.complianceLevel;
        }
        return name;
    }

    public void initialize(CompilerTestSetup setUp) {
        this.complianceLevel = setUp.complianceLevel;
    }

    protected String testName() {
        return super.getName();
    }

    protected void createOutputTestDirectory(String suffixPath) {
        this.outputTestDirectory = new File(this.outputRootDirectoryPath.toFile(), suffixPath);
        if (!this.outputTestDirectory.exists()) {
            this.outputTestDirectory.mkdirs();
        }
    }

    protected void writeFiles(String[] testFiles) {
        this.createOutputTestDirectory(this.testName());
        int i = 0;
        int length = testFiles.length;
        while (i < length) {
            File dir;
            String fileName = testFiles[i++];
            String contents = testFiles[i++];
            File file = new File(this.outputTestDirectory, fileName);
            if (fileName.lastIndexOf(47) >= 0 && !(dir = file.getParentFile()).exists()) {
                dir.mkdirs();
            }
            Util.writeToFile(contents, file.getPath());
        }
    }
}

