/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.Cascade;
import org.eclipse.jpt.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.CascadeType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmCascadeTests
extends ContextModelTestCase {
    public OrmCascadeTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateCascadeAll() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isAll());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
        oneToOne.setCascade((CascadeType)OrmFactory.eINSTANCE.createCascadeTypeImpl());
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isAll());
        OrmCascadeTests.assertNotNull((Object)oneToOne.getCascade());
        oneToOne.getCascade().setCascadeAll(true);
        OrmCascadeTests.assertEquals((boolean)true, (boolean)cascade.isAll());
        OrmCascadeTests.assertEquals((boolean)true, (boolean)oneToOne.getCascade().isCascadeAll());
        oneToOne.getCascade().setCascadeAll(false);
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isAll());
        OrmCascadeTests.assertEquals((boolean)false, (boolean)oneToOne.getCascade().isCascadeAll());
    }

    public void testModifyCascadeAll() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isAll());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
        cascade.setAll(true);
        OrmCascadeTests.assertEquals((boolean)true, (boolean)cascade.isAll());
        OrmCascadeTests.assertEquals((boolean)true, (boolean)oneToOne.getCascade().isCascadeAll());
        cascade.setAll(false);
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isAll());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
    }

    public void testUpdateCascadePersist() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isPersist());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
        oneToOne.setCascade((CascadeType)OrmFactory.eINSTANCE.createCascadeTypeImpl());
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isPersist());
        OrmCascadeTests.assertNotNull((Object)oneToOne.getCascade());
        oneToOne.getCascade().setCascadePersist(true);
        OrmCascadeTests.assertEquals((boolean)true, (boolean)cascade.isPersist());
        OrmCascadeTests.assertEquals((boolean)true, (boolean)oneToOne.getCascade().isCascadePersist());
        oneToOne.getCascade().setCascadePersist(false);
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isPersist());
        OrmCascadeTests.assertEquals((boolean)false, (boolean)oneToOne.getCascade().isCascadePersist());
    }

    public void testModifyCascadePersist() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isPersist());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
        cascade.setPersist(true);
        OrmCascadeTests.assertEquals((boolean)true, (boolean)cascade.isPersist());
        OrmCascadeTests.assertEquals((boolean)true, (boolean)oneToOne.getCascade().isCascadePersist());
        cascade.setPersist(false);
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isPersist());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
    }

    public void testUpdateCascadeMerge() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isMerge());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
        oneToOne.setCascade((CascadeType)OrmFactory.eINSTANCE.createCascadeTypeImpl());
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isMerge());
        OrmCascadeTests.assertNotNull((Object)oneToOne.getCascade());
        oneToOne.getCascade().setCascadeMerge(true);
        OrmCascadeTests.assertEquals((boolean)true, (boolean)cascade.isMerge());
        OrmCascadeTests.assertEquals((boolean)true, (boolean)oneToOne.getCascade().isCascadeMerge());
        oneToOne.getCascade().setCascadeMerge(false);
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isMerge());
        OrmCascadeTests.assertEquals((boolean)false, (boolean)oneToOne.getCascade().isCascadeMerge());
    }

    public void testModifyCascadeMerge() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isMerge());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
        cascade.setMerge(true);
        OrmCascadeTests.assertEquals((boolean)true, (boolean)cascade.isMerge());
        OrmCascadeTests.assertEquals((boolean)true, (boolean)oneToOne.getCascade().isCascadeMerge());
        cascade.setMerge(false);
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isMerge());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
    }

    public void testUpdateCascadeRemove() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isRemove());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
        oneToOne.setCascade((CascadeType)OrmFactory.eINSTANCE.createCascadeTypeImpl());
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isRemove());
        OrmCascadeTests.assertNotNull((Object)oneToOne.getCascade());
        oneToOne.getCascade().setCascadeRemove(true);
        OrmCascadeTests.assertEquals((boolean)true, (boolean)cascade.isRemove());
        OrmCascadeTests.assertEquals((boolean)true, (boolean)oneToOne.getCascade().isCascadeRemove());
        oneToOne.getCascade().setCascadeRemove(false);
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isRemove());
        OrmCascadeTests.assertEquals((boolean)false, (boolean)oneToOne.getCascade().isCascadeRemove());
    }

    public void testModifyCascadeRemove() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isRemove());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
        cascade.setRemove(true);
        OrmCascadeTests.assertEquals((boolean)true, (boolean)cascade.isRemove());
        OrmCascadeTests.assertEquals((boolean)true, (boolean)oneToOne.getCascade().isCascadeRemove());
        cascade.setRemove(false);
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isRemove());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
    }

    public void testUpdateCascadeRefresh() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isRefresh());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
        oneToOne.setCascade((CascadeType)OrmFactory.eINSTANCE.createCascadeTypeImpl());
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isRefresh());
        OrmCascadeTests.assertNotNull((Object)oneToOne.getCascade());
        oneToOne.getCascade().setCascadeRefresh(true);
        OrmCascadeTests.assertEquals((boolean)true, (boolean)cascade.isRefresh());
        OrmCascadeTests.assertEquals((boolean)true, (boolean)oneToOne.getCascade().isCascadeRefresh());
        oneToOne.getCascade().setCascadeRefresh(false);
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isRefresh());
        OrmCascadeTests.assertEquals((boolean)false, (boolean)oneToOne.getCascade().isCascadeRefresh());
    }

    public void testModifyCascadeRefresh() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        Cascade cascade = ormOneToOneMapping.getCascade();
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isRefresh());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
        cascade.setRefresh(true);
        OrmCascadeTests.assertEquals((boolean)true, (boolean)cascade.isRefresh());
        OrmCascadeTests.assertEquals((boolean)true, (boolean)oneToOne.getCascade().isCascadeRefresh());
        cascade.setRefresh(false);
        OrmCascadeTests.assertEquals((boolean)false, (boolean)cascade.isRefresh());
        OrmCascadeTests.assertNull((Object)oneToOne.getCascade());
    }
}

