/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterables.CloneIterable;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaPersistentType
extends AbstractJavaJpaContextNode
implements JavaPersistentType {
    protected String name;
    protected JavaTypeMapping mapping;
    protected final Vector<JavaPersistentAttribute> attributes = new Vector();
    protected PersistentType parentPersistentType;
    protected JavaResourcePersistentType resourcePersistentType;
    protected AccessType defaultAccess;

    protected AbstractJavaPersistentType(PersistentType.Owner parent, JavaResourcePersistentType jrpt) {
        super(parent);
        this.initialize(jrpt);
    }

    @Override
    public IResource getResource() {
        return this.resourcePersistentType.getFile();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.java.persistentType";
    }

    @Override
    public IContentType getContentType() {
        return JptCorePlugin.JAVA_SOURCE_CONTENT_TYPE;
    }

    @Override
    public JavaResourcePersistentType getResourcePersistentType() {
        return this.resourcePersistentType;
    }

    @Override
    public PersistentType.Owner getParent() {
        return (PersistentType.Owner)super.getParent();
    }

    protected PersistentType.Owner getOwner() {
        return this.getParent();
    }

    @Override
    public AccessType getAccess() {
        return this.getSpecifiedAccess() != null ? this.getSpecifiedAccess() : this.getDefaultAccess();
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType newDefaultAccess) {
        AccessType oldAccess = this.defaultAccess;
        this.defaultAccess = newDefaultAccess;
        this.firePropertyChanged("defaultAccess", (Object)oldAccess, (Object)newDefaultAccess);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.getName().substring(this.getName().lastIndexOf(46) + 1);
    }

    protected void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("name", oldName, newName);
    }

    @Override
    public JavaTypeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingKey() {
        return this.getMapping().getKey();
    }

    @Override
    public void setMappingKey(String key) {
        JavaTypeMapping newMapping;
        if (key == this.getMapping().getKey()) {
            return;
        }
        JavaTypeMapping oldMapping = this.getMapping();
        this.mapping = newMapping = this.createJavaTypeMappingFromMappingKey(key);
        this.resourcePersistentType.setMappingAnnotation(newMapping.getAnnotationName());
        this.firePropertyChanged("mapping", oldMapping, newMapping);
        if (oldMapping != null) {
            HashBag annotationsToRemove = CollectionTools.collection(oldMapping.correspondingAnnotationNames());
            if (this.getMapping() != null) {
                CollectionTools.removeAll((Collection)annotationsToRemove, this.getMapping().correspondingAnnotationNames());
            }
            for (String annotationName : annotationsToRemove) {
                this.resourcePersistentType.removeSupportingAnnotation(annotationName);
            }
        }
    }

    protected void setMapping(JavaTypeMapping newMapping) {
        JavaTypeMapping oldMapping = this.mapping;
        this.mapping = newMapping;
        this.firePropertyChanged("mapping", oldMapping, newMapping);
    }

    @Override
    public boolean isMapped() {
        return this.getMapping().isMapped();
    }

    @Override
    public AccessType getOwnerOverrideAccess() {
        return this.getOwner().getOverridePersistentTypeAccess();
    }

    @Override
    public AccessType getOwnerDefaultAccess() {
        return this.getOwner().getDefaultPersistentTypeAccess();
    }

    protected Iterator<JavaPersistentAttribute> attributesNamed(final String attributeName) {
        return new FilteringIterator<JavaPersistentAttribute, JavaPersistentAttribute>(this.attributes()){

            protected boolean accept(JavaPersistentAttribute o) {
                return attributeName.equals(o.getName());
            }
        };
    }

    @Override
    public JavaPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.attributesNamed(attributeName);
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public PersistentAttribute resolveAttribute(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.attributesNamed(attributeName);
        if (stream.hasNext()) {
            JavaPersistentAttribute attribute = stream.next();
            return stream.hasNext() ? null : attribute;
        }
        return this.parentPersistentType == null ? null : this.parentPersistentType.resolveAttribute(attributeName);
    }

    @Override
    public ListIterator<JavaPersistentAttribute> attributes() {
        return new CloneListIterator(this.attributes);
    }

    protected Iterable<JavaPersistentAttribute> getAttributes() {
        return new CloneIterable(this.attributes);
    }

    @Override
    public int attributesSize() {
        return this.attributes.size();
    }

    private void addAttribute(int index, JavaPersistentAttribute attribute) {
        this.addItemToList(index, attribute, this.attributes, "specifiedAttributes");
    }

    private void removeAttribute(JavaPersistentAttribute attribute) {
        this.removeItemFromList(attribute, this.attributes, "specifiedAttributes");
    }

    private void moveAttribute(int index, JavaPersistentAttribute attribute) {
        this.moveItemInList(index, this.attributes.indexOf(attribute), this.attributes, "specifiedAttributes");
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.attributeNames(this.attributes());
    }

    protected Iterator<String> attributeNames(Iterator<? extends PersistentAttribute> attrs) {
        return new TransformationIterator<PersistentAttribute, String>(attrs){

            protected String transform(PersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public Iterator<PersistentAttribute> allAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<PersistentType, Iterator<PersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<PersistentAttribute> transform(PersistentType pt) {
                return pt.attributes();
            }
        });
    }

    @Override
    public Iterator<String> allAttributeNames() {
        return this.attributeNames(this.allAttributes());
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        Iterator values = this.mapping.javaCompletionProposals(pos, filter, astRoot);
        if (values != null) {
            return values;
        }
        for (JavaPersistentAttribute attribute : this.getAttributes()) {
            values = attribute.javaCompletionProposals(pos, filter, astRoot);
            if (values == null) continue;
            return values;
        }
        return EmptyIterator.instance();
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        CompilationUnit astRoot = this.buildASTRoot();
        if (this.contains(offset, astRoot)) {
            for (JavaPersistentAttribute persistentAttribute : this.getAttributes()) {
                if (!persistentAttribute.contains(offset, astRoot)) continue;
                return persistentAttribute;
            }
            return this;
        }
        return null;
    }

    protected CompilationUnit buildASTRoot() {
        return this.resourcePersistentType.getJavaResourceCompilationUnit().buildASTRoot();
    }

    public boolean contains(int offset, CompilationUnit astRoot) {
        TextRange fullTextRange = this.getFullTextRange(astRoot);
        return fullTextRange == null ? false : fullTextRange.includes(offset);
    }

    protected TextRange getFullTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentType.getTextRange(astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getSelectionTextRange(astRoot);
    }

    public TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentType.getNameTextRange(astRoot);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getSelectionTextRange(this.buildASTRoot());
    }

    @Override
    public Iterator<PersistentType> inheritanceHierarchy() {
        return AbstractJavaPersistentType.inheritanceHierarchyOf(this);
    }

    @Override
    public Iterator<PersistentType> ancestors() {
        return AbstractJavaPersistentType.inheritanceHierarchyOf(this.parentPersistentType);
    }

    protected static Iterator<PersistentType> inheritanceHierarchyOf(PersistentType persistentType) {
        return new ChainIterator<PersistentType>(persistentType){

            protected PersistentType nextLink(PersistentType pt) {
                return pt.getParentPersistentType();
            }
        };
    }

    @Override
    public PersistentType getParentPersistentType() {
        return this.parentPersistentType;
    }

    public void setParentPersistentType(PersistentType newParentPersistentType) {
        if (this.attributeValueHasNotChanged(this.parentPersistentType, newParentPersistentType)) {
            return;
        }
        PersistentType oldParentPersistentType = this.parentPersistentType;
        this.parentPersistentType = newParentPersistentType;
        this.firePropertyChanged("parentPersistentType", oldParentPersistentType, newParentPersistentType);
    }

    @Override
    public boolean hasAnyAttributePersistenceAnnotations() {
        return this.resourcePersistentType.hasAnyAttributePersistenceAnnotations();
    }

    protected void initialize(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        this.parentPersistentType = this.buildParentPersistentType();
        this.name = this.buildName();
        this.initializeAccess();
        this.initializeMapping();
        this.initializeAttributes();
    }

    protected void initializeAccess() {
        this.defaultAccess = this.buildDefaultAccess();
    }

    protected void initializeMapping() {
        this.mapping = this.getJpaPlatform().buildJavaTypeMappingFromAnnotation(this.getJavaMappingAnnotationName(), this);
        this.mapping.initialize(this.resourcePersistentType);
    }

    protected void initializeAttributes() {
        Iterator<JavaResourcePersistentAttribute> stream = this.resourceAttributes();
        while (stream.hasNext()) {
            this.attributes.add(this.createAttribute(stream.next()));
        }
    }

    protected Iterator<JavaResourcePersistentAttribute> resourceAttributes() {
        return this.getAccess() == AccessType.PROPERTY ? this.resourcePersistentType.persistableProperties() : this.resourcePersistentType.persistableFields();
    }

    @Override
    public void update(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        this.update();
    }

    @Override
    public void update() {
        JpaFile jpaFile = this.getJpaFile();
        if (jpaFile != null) {
            jpaFile.addRootStructureNode(this.resourcePersistentType.getQualifiedName(), this);
        }
        this.setParentPersistentType(this.buildParentPersistentType());
        this.setName(this.buildName());
        this.updateAccess();
        this.updateMapping();
        this.updateAttributes();
    }

    protected JpaFile getJpaFile() {
        return this.getJpaFile(this.resourcePersistentType.getFile());
    }

    protected void updateAccess() {
        this.setDefaultAccess(this.buildDefaultAccess());
    }

    protected AccessType buildDefaultAccess() {
        AccessType accessType = AccessType.fromJavaResourceModel(this.resourcePersistentType.getAccess());
        if (accessType != null) {
            return accessType;
        }
        accessType = this.getOwnerOverrideAccess();
        if (accessType != null) {
            return accessType;
        }
        if (this.parentPersistentType != null && (accessType = this.parentPersistentType.getDefaultAccess()) != null) {
            return accessType;
        }
        accessType = this.getOwnerDefaultAccess();
        if (accessType != null) {
            return accessType;
        }
        return AccessType.FIELD;
    }

    protected String buildName() {
        return this.resourcePersistentType.getQualifiedName();
    }

    protected void updateMapping() {
        String javaMappingAnnotationName = this.getJavaMappingAnnotationName();
        if (this.getMapping().getAnnotationName() == javaMappingAnnotationName) {
            this.getMapping().update(this.resourcePersistentType);
        } else {
            this.setMapping(this.createJavaTypeMappingFromAnnotation(javaMappingAnnotationName));
        }
    }

    protected JavaTypeMapping createJavaTypeMappingFromMappingKey(String key) {
        return this.getJpaPlatform().buildJavaTypeMappingFromMappingKey(key, this);
    }

    protected JavaTypeMapping createJavaTypeMappingFromAnnotation(String annotationName) {
        JavaTypeMapping typeMapping = this.getJpaPlatform().buildJavaTypeMappingFromAnnotation(annotationName, this);
        typeMapping.initialize(this.resourcePersistentType);
        return typeMapping;
    }

    protected String getJavaMappingAnnotationName() {
        Annotation mappingAnnotation = this.resourcePersistentType.getMappingAnnotation();
        return mappingAnnotation == null ? null : mappingAnnotation.getAnnotationName();
    }

    protected void updateAttributes() {
        HashBag contextAttributesToRemove = CollectionTools.bag(this.attributes(), (int)this.attributesSize());
        ArrayList<JavaPersistentAttribute> contextAttributesToUpdate = new ArrayList<JavaPersistentAttribute>(this.attributesSize());
        int resourceIndex = 0;
        Iterator<JavaResourcePersistentAttribute> resourceAttributes = this.resourceAttributes();
        while (resourceAttributes.hasNext()) {
            JavaResourcePersistentAttribute resourceAttribute = resourceAttributes.next();
            boolean match = false;
            Iterator contextAttributes = contextAttributesToRemove.iterator();
            while (contextAttributes.hasNext()) {
                JavaPersistentAttribute contextAttribute = (JavaPersistentAttribute)contextAttributes.next();
                if (contextAttribute.getResourcePersistentAttribute() != resourceAttribute) continue;
                this.moveAttribute(resourceIndex, contextAttribute);
                contextAttributes.remove();
                contextAttributesToUpdate.add(contextAttribute);
                match = true;
                break;
            }
            if (!match) {
                this.addAttribute(resourceIndex, this.createAttribute(resourceAttribute));
            }
            ++resourceIndex;
        }
        for (JavaPersistentAttribute contextAttribute : contextAttributesToRemove) {
            this.removeAttribute(contextAttribute);
        }
        for (JavaPersistentAttribute contextAttribute : contextAttributesToUpdate) {
            contextAttribute.update();
        }
    }

    protected JavaPersistentAttribute createAttribute(JavaResourcePersistentAttribute jrpa) {
        return this.getJpaFactory().buildJavaPersistentAttribute(this, jrpa);
    }

    protected PersistentType buildParentPersistentType() {
        HashSet<JavaResourcePersistentType> visited = new HashSet<JavaResourcePersistentType>();
        visited.add(this.resourcePersistentType);
        PersistentType parent = this.getParent(this.resourcePersistentType.getSuperclassQualifiedName(), visited);
        if (parent == null) {
            return null;
        }
        if (CollectionTools.contains(parent.inheritanceHierarchy(), (Object)this)) {
            return null;
        }
        return parent.isMapped() ? parent : parent.getParentPersistentType();
    }

    protected PersistentType getParent(String typeName, Collection<JavaResourcePersistentType> visited) {
        if (typeName == null) {
            return null;
        }
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType(typeName);
        if (resourceType == null || visited.contains(resourceType)) {
            return null;
        }
        visited.add(resourceType);
        PersistentType parent = this.getPersistentType(typeName);
        return parent != null ? parent : this.getParent(resourceType.getSuperclassQualifiedName(), visited);
    }

    protected PersistentType getPersistentType(String fullyQualifiedTypeName) {
        return this.getPersistenceUnit().getPersistentType(fullyQualifiedTypeName);
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.getMapping().postUpdate();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        IFile file = this.resourcePersistentType.getFile();
        if (file != null && file.getProject().equals((Object)this.getJpaProject().getProject()) && this.resourcePersistentType instanceof SourceNode) {
            this.validate(messages, reporter, this.buildASTRoot());
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateMapping(messages, reporter, astRoot);
        this.validateAttributes(messages, reporter, astRoot);
    }

    protected void validateMapping(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        try {
            this.mapping.validate(messages, reporter, astRoot);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    protected void validateAttributes(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        for (JavaPersistentAttribute attribute : this.getAttributes()) {
            this.validateAttribute(attribute, reporter, messages, astRoot);
        }
    }

    protected void validateAttribute(JavaPersistentAttribute attribute, IReporter reporter, List<IMessage> messages, CompilationUnit astRoot) {
        try {
            attribute.validate(messages, reporter, astRoot);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }

    @Override
    public void dispose() {
        JpaFile jpaFile = this.getJpaFile();
        if (jpaFile != null) {
            jpaFile.removeRootStructureNode(this.resourcePersistentType.getQualifiedName());
        }
    }
}

