/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.context.Convert;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkBasicMapping;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmBasicMapping;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class EclipseLinkOrmBasicMappingTests
extends EclipseLinkOrmContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableBasicDate() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public EclipseLinkOrmBasicMappingTests(String name) {
        super(name);
    }

    public void testUpdateMutable() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        EclipseLinkOrmBasicMapping contextBasic = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic resourceBasic = (XmlBasic)resourceEntity.getAttributes().getBasics().get(0);
        EclipseLinkBasicMapping javaBasicMapping = (EclipseLinkBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        javaBasicMapping.getMutable().setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)javaBasicMapping.getMutable().isMutable());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        contextBasic = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)javaBasicMapping.getMutable().isMutable());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        contextBasic = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)javaBasicMapping.getMutable().isMutable());
    }

    public void testUpdateMutableDate() throws Exception {
        this.createTestEntityWithMutableBasicDate();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "myDate");
        EclipseLinkOrmBasicMapping contextBasic = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic resourceBasic = (XmlBasic)resourceEntity.getAttributes().getBasics().get(0);
        EclipseLinkBasicMapping javaBasicMapping = (EclipseLinkBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("myDate").getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        javaBasicMapping.getMutable().setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)javaBasicMapping.getMutable().isMutable());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        contextBasic = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)javaBasicMapping.getMutable().isMutable());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        contextBasic = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)javaBasicMapping.getMutable().isMutable());
    }

    public void testModifyMutable() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basic");
        EclipseLinkOrmBasicMapping contextBasic = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic resourceBasic = (XmlBasic)resourceEntity.getAttributes().getBasics().get(0);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        contextBasic.getMutable().setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        contextBasic.getMutable().setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        contextBasic.getMutable().setSpecifiedMutable(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
    }

    public void testUpdateConvert() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((org.eclipse.jpt.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        basicResource.setConvert("myConvert");
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"myConvert", (String)basicResource.getConvert());
        basicResource.setConvert(null);
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        javaBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        ((Convert)javaBasicMapping.getSpecifiedConverter()).setSpecifiedConverterName("foo");
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"foo", (String)((Convert)javaBasicMapping.getSpecifiedConverter()).getSpecifiedConverterName());
        ormPersistentType.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormBasicMapping.getSpecifiedConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"foo", (String)((Convert)ormBasicMapping.getSpecifiedConverter()).getSpecifiedConverterName());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"foo", (String)((Convert)javaBasicMapping.getSpecifiedConverter()).getSpecifiedConverterName());
        ((Convert)javaBasicMapping.getSpecifiedConverter()).setSpecifiedConverterName("bar");
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormBasicMapping.getSpecifiedConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"bar", (String)((Convert)ormBasicMapping.getSpecifiedConverter()).getSpecifiedConverterName());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"bar", (String)((Convert)javaBasicMapping.getSpecifiedConverter()).getSpecifiedConverterName());
        javaBasicMapping.setSpecifiedConverter("noConverter");
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (Object)javaBasicMapping.getSpecifiedConverter());
    }

    public void testModifyConvert() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((org.eclipse.jpt.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        ormBasicMapping.setSpecifiedConverter("eclipseLinkConverter");
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"", (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormBasicMapping.getConverter().getType());
        ((Convert)ormBasicMapping.getSpecifiedConverter()).setSpecifiedConverterName("bar");
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"bar", (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"eclipseLinkConverter", (String)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"bar", (String)((Convert)ormBasicMapping.getConverter()).getSpecifiedConverterName());
        ((Convert)ormBasicMapping.getSpecifiedConverter()).setSpecifiedConverterName(null);
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        ormBasicMapping.setSpecifiedConverter(null);
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (Object)ormBasicMapping.getSpecifiedConverter());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
    }
}

