/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.ui.internal.tabs.processor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xsl.jaxp.launching.IOutputProperty;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorType;
import org.eclipse.wst.xsl.jaxp.launching.JAXPRuntime;
import org.eclipse.wst.xsl.jaxp.launching.LaunchProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputPropertyDialog
extends StatusDialog {
    private Table table;
    private TableViewer tViewer;
    private Text text;
    private List<IOutputProperty> properties = new ArrayList<IOutputProperty>();
    private List<IOutputProperty> selectedProperties = new ArrayList<IOutputProperty>();

    public OutputPropertyDialog(Shell parent, LaunchProperties launchProperties) {
        super(parent);
        this.setTitle("Select Output Properties");
        HashSet<String> propertySet = new HashSet<String>();
        for (String att : launchProperties.getProperties().keySet()) {
            propertySet.add(att);
        }
        IProcessorType[] iProcessorTypeArray = JAXPRuntime.getProcessorTypes();
        int n = iProcessorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorType type = iProcessorTypeArray[n2];
            IOutputProperty[] iOutputPropertyArray = type.getOutputProperties();
            int n3 = iOutputPropertyArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IOutputProperty property = iOutputPropertyArray[n4];
                if (!propertySet.contains(property.getURI())) {
                    propertySet.add(property.getURI());
                    this.properties.add(property);
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        comp.setLayoutData((Object)gd);
        comp.setLayout((Layout)new GridLayout());
        Label label = new Label(comp, 0);
        label.setText("Select one or more output properties for the transformation.");
        this.table = new Table(comp, 68098);
        this.table.setHeaderVisible(false);
        gd = new GridData(4, 4, true, true);
        gd.verticalIndent = 10;
        gd.heightHint = 200;
        this.table.setLayoutData((Object)gd);
        this.tViewer = new TableViewer(this.table);
        this.tViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return OutputPropertyDialog.this.properties.toArray(new IOutputProperty[0]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IOutputProperty property = (IOutputProperty)element;
                return property.getURI();
            }
        });
        this.tViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IOutputProperty a1 = (IOutputProperty)e1;
                IOutputProperty a2 = (IOutputProperty)e2;
                return a1.getURI().compareTo(a2.getURI());
            }
        });
        this.tViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                OutputPropertyDialog.this.selectedProperties = sel.toList();
                if (sel.isEmpty()) {
                    OutputPropertyDialog.this.text.setText("");
                } else {
                    IOutputProperty property = (IOutputProperty)sel.getFirstElement();
                    OutputPropertyDialog.this.text.setText(property.getDescription());
                }
            }
        });
        this.tViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                OutputPropertyDialog.this.buttonPressed(0);
            }
        });
        this.tViewer.setInput(this.properties);
        this.text = new Text(comp, 2632);
        this.text.setEditable(false);
        gd = new GridData(4, 4, true, false);
        gd.heightHint = 80;
        this.text.setLayoutData((Object)gd);
        if (this.properties.size() > 0) {
            this.tViewer.setSelection((ISelection)new StructuredSelection(this.tViewer.getElementAt(0)), true);
        }
        return comp;
    }

    public List<IOutputProperty> getOutpuProperties() {
        return this.selectedProperties;
    }
}

