/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSRuleListImpl;
import org.eclipse.wst.css.core.internal.document.MediaListImpl;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSMediaRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.stylesheets.MediaList;

class CSSMediaRuleImpl
extends CSSRuleImpl
implements ICSSMediaRule {
    CSSMediaRuleImpl() {
    }

    CSSMediaRuleImpl(CSSMediaRuleImpl that) {
        super(that);
    }

    public CSSRule appendRule(CSSRule rule) throws DOMException {
        if (rule == null) {
            return null;
        }
        CSSRule ret = (CSSRule)((Object)this.appendChild((CSSNodeImpl)((Object)rule)));
        return ret;
    }

    public ICSSNode cloneNode(boolean deep) {
        CSSMediaRuleImpl cloned = new CSSMediaRuleImpl(this);
        if (deep) {
            this.cloneChildNodes(cloned, deep);
        }
        return cloned;
    }

    public void deleteRule(int index) throws DOMException {
        CSSRuleImpl node = this.getIndexedRule(index);
        if (node != null) {
            this.removeChild(node);
        }
    }

    public CSSRuleList getCssRules() {
        CSSRuleListImpl list = new CSSRuleListImpl();
        ICSSNode node = this.getFirstChild();
        while (node != null) {
            if (node instanceof CSSRule) {
                list.appendNode(node);
            }
            node = node.getNextSibling();
        }
        return list;
    }

    CSSRuleImpl getIndexedRule(int index) {
        if (index < 0) {
            return null;
        }
        int i = 0;
        ICSSNode node = this.getFirstChild();
        while (node != null) {
            if (node instanceof CSSRule && i++ == index) {
                return (CSSRuleImpl)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public MediaList getMedia() {
        ICSSNode node = this.getFirstChild();
        while (node != null) {
            if (node instanceof MediaListImpl) {
                return (MediaList)((Object)node);
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public short getNodeType() {
        return 4;
    }

    public short getType() {
        return 4;
    }

    public int insertRule(String rule, int index) throws DOMException {
        int length = this.getCssRules().getLength();
        if (index < 0 || length < index) {
            throw new DOMException(1, "");
        }
        CSSRuleImpl refRule = length != index ? this.getIndexedRule(index) : null;
        CSSRuleImpl newRule = (CSSRuleImpl)this.getOwnerDocument().createCSSRule(rule);
        if (newRule.getType() == 4) {
            throw new DOMException(12, "");
        }
        this.insertBefore(newRule, refRule);
        return index;
    }

    public CSSRule insertRuleBefore(CSSRule newRule, CSSRule refRule) throws DOMException {
        if (newRule == null && refRule == null) {
            return null;
        }
        CSSRule ret = (CSSRule)((Object)this.insertBefore((CSSNodeImpl)((Object)newRule), (CSSNodeImpl)((Object)refRule)));
        return ret;
    }

    public CSSRule removeRule(CSSRule rule) throws DOMException {
        if (rule == null) {
            return null;
        }
        CSSRule ret = (CSSRule)((Object)this.removeChild((CSSNodeImpl)((Object)rule)));
        return ret;
    }

    public CSSRule replaceRule(CSSRule newRule, CSSRule oldRule) throws DOMException {
        if (newRule == null && oldRule == null) {
            return null;
        }
        CSSRule ret = (CSSRule)((Object)this.replaceChild((CSSNodeImpl)((Object)newRule), (CSSNodeImpl)((Object)oldRule)));
        return ret;
    }
}

