/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.code;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.util.RowLayouter;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;

public class ExtractMethodInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "ExtractMethodInputPage";
    private ExtractMethodRefactoring fRefactoring;
    private Text fTextField;
    private boolean fFirstTime;
    private JavaSourceViewer fSignaturePreview;
    private Document fSignaturePreviewDocument;
    private IDialogSettings fSettings;
    private static final String DESCRIPTION = RefactoringMessages.ExtractMethodInputPage_description;
    private static final String THROW_RUNTIME_EXCEPTIONS = "ThrowRuntimeExceptions";
    private static final String GENERATE_JAVADOC = "GenerateJavadoc";

    public ExtractMethodInputPage() {
        super(PAGE_NAME);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_REFACTOR_CU);
        this.setDescription(DESCRIPTION);
        this.fFirstTime = true;
        this.fSignaturePreviewDocument = new Document();
    }

    public void createControl(Composite parent) {
        this.fRefactoring = (ExtractMethodRefactoring)this.getRefactoring();
        this.loadSettings();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        RowLayouter layouter = new RowLayouter(2);
        GridData gd = null;
        this.initializeDialogUnits((Control)result);
        Label label = new Label(result, 0);
        label.setText(this.getLabelText());
        this.fTextField = this.createTextInputField(result, 2048);
        this.fTextField.setLayoutData((Object)new GridData(768));
        layouter.perform((Control)label, (Control)this.fTextField, 1);
        ASTNode[] destinations = this.fRefactoring.getDestinations();
        if (destinations.length > 1) {
            label = new Label(result, 0);
            label.setText(RefactoringMessages.ExtractMethodInputPage_destination_type);
            final Combo combo = new Combo(result, 12);
            int i = 0;
            while (i < destinations.length) {
                ASTNode declaration = destinations[i];
                combo.add(this.getLabel(declaration));
                ++i;
            }
            combo.select(0);
            combo.setLayoutData((Object)new GridData(768));
            combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ExtractMethodInputPage.this.fRefactoring.setDestination(combo.getSelectionIndex());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (!this.fRefactoring.getParameterInfos().isEmpty()) {
            ChangeParametersControl cp = new ChangeParametersControl(result, 0, RefactoringMessages.ExtractMethodInputPage_parameters, new IParameterListChangeListener(){

                public void parameterChanged(ParameterInfo parameter) {
                    ExtractMethodInputPage.this.parameterModified();
                }

                public void parameterListChanged() {
                    ExtractMethodInputPage.this.parameterModified();
                }

                public void parameterAdded(ParameterInfo parameter) {
                    ExtractMethodInputPage.this.updatePreview(ExtractMethodInputPage.this.getText());
                }
            }, ChangeParametersControl.Mode.EXTRACT_METHOD);
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            cp.setLayoutData(gd);
            cp.setInput(this.fRefactoring.getParameterInfos());
        }
        Button checkBox = new Button(result, 32);
        checkBox.setText(RefactoringMessages.ExtractMethodInputPage_generateJavadocComment);
        boolean generate = this.computeGenerateJavadoc();
        this.setGenerateJavadoc(generate);
        checkBox.setSelection(generate);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractMethodInputPage.this.setGenerateJavadoc(((Button)e.widget).getSelection());
            }
        });
        layouter.perform((Control)checkBox);
        int duplicates = this.fRefactoring.getNumberOfDuplicates();
        checkBox = new Button(result, 32);
        if (duplicates == 0) {
            checkBox.setText(RefactoringMessages.ExtractMethodInputPage_duplicates_none);
        } else if (duplicates == 1) {
            checkBox.setText(RefactoringMessages.ExtractMethodInputPage_duplicates_single);
        } else {
            checkBox.setText(Messages.format(RefactoringMessages.ExtractMethodInputPage_duplicates_multi, new Integer(duplicates)));
        }
        checkBox.setSelection(this.fRefactoring.getReplaceDuplicates());
        checkBox.setEnabled(duplicates > 0);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractMethodInputPage.this.fRefactoring.setReplaceDuplicates(((Button)e.widget).getSelection());
            }
        });
        layouter.perform((Control)checkBox);
        label = new Label(result, 258);
        label.setLayoutData((Object)new GridData(768));
        layouter.perform((Control)label);
        this.createSignaturePreview(result, layouter);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.extract_method_wizard_page_context");
    }

    private String getLabel(ASTNode node) {
        if (node instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)node).getName().getIdentifier();
        }
        if (node instanceof AnonymousClassDeclaration && node.getLocationInParent() == ClassInstanceCreation.ANONYMOUS_CLASS_DECLARATION_PROPERTY) {
            ClassInstanceCreation creation = (ClassInstanceCreation)node.getParent();
            return Messages.format(RefactoringMessages.ExtractMethodInputPage_anonymous_type_label, ASTNodes.asString((ASTNode)creation.getType()));
        }
        return "UNKNOWN";
    }

    private Text createTextInputField(Composite parent, int style) {
        Text result = new Text(parent, style);
        result.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExtractMethodInputPage.this.textModified(ExtractMethodInputPage.this.getText());
            }
        });
        TextFieldNavigationHandler.install(result);
        return result;
    }

    private String getText() {
        if (this.fTextField == null) {
            return null;
        }
        return this.fTextField.getText();
    }

    private String getLabelText() {
        return RefactoringMessages.ExtractMethodInputPage_label_text;
    }

    private boolean computeGenerateJavadoc() {
        boolean result = this.fRefactoring.getGenerateJavadoc();
        if (result) {
            return result;
        }
        return this.fSettings.getBoolean(GENERATE_JAVADOC);
    }

    private void setGenerateJavadoc(boolean value) {
        this.fSettings.put(GENERATE_JAVADOC, value);
        this.fRefactoring.setGenerateJavadoc(value);
    }

    private void createSignaturePreview(Composite composite, RowLayouter layouter) {
        Label previewLabel = new Label(composite, 0);
        previewLabel.setText(RefactoringMessages.ExtractMethodInputPage_signature_preview);
        layouter.perform((Control)previewLabel);
        IPreferenceStore store = JavaScriptPlugin.getDefault().getCombinedPreferenceStore();
        this.fSignaturePreview = new JavaSourceViewer(composite, null, null, false, 584, store);
        this.fSignaturePreview.configure((SourceViewerConfiguration)new JavaScriptSourceViewerConfiguration(JavaScriptPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, null));
        this.fSignaturePreview.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont"));
        this.fSignaturePreview.getTextWidget().setBackground(composite.getBackground());
        this.fSignaturePreview.setDocument((IDocument)this.fSignaturePreviewDocument);
        this.fSignaturePreview.setEditable(false);
        Control signaturePreviewControl = this.fSignaturePreview.getControl();
        PixelConverter pixelConverter = new PixelConverter(signaturePreviewControl);
        GridData gdata = new GridData(1808);
        gdata.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        gdata.heightHint = pixelConverter.convertHeightInCharsToPixels(2);
        signaturePreviewControl.setLayoutData((Object)gdata);
        layouter.perform(signaturePreviewControl);
    }

    private void updatePreview(String text) {
        String signature;
        if (this.fSignaturePreview == null) {
            return;
        }
        if (text.length() == 0) {
            text = "someMethodName";
        }
        int top = this.fSignaturePreview.getTextWidget().getTopPixel();
        try {
            signature = this.fRefactoring.getSignature(text);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            signature = "";
        }
        this.fSignaturePreviewDocument.set(signature);
        this.fSignaturePreview.getTextWidget().setTopPixel(top);
    }

    private void loadSettings() {
        this.fSettings = this.getDialogSettings().getSection("ExtractMethodWizard");
        if (this.fSettings == null) {
            this.fSettings = this.getDialogSettings().addNewSection("ExtractMethodWizard");
            this.fSettings.put(THROW_RUNTIME_EXCEPTIONS, false);
            this.fSettings.put(GENERATE_JAVADOC, JavaPreferencesSettings.getCodeGenerationSettings((IJavaScriptProject)this.fRefactoring.getCompilationUnit().getJavaScriptProject()).createComments);
        }
        this.fRefactoring.setThrowRuntimeExceptions(this.fSettings.getBoolean(THROW_RUNTIME_EXCEPTIONS));
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.setPageComplete(false);
                this.updatePreview(this.getText());
                this.fTextField.setFocus();
            } else {
                this.setPageComplete(this.validatePage(true));
            }
        }
        super.setVisible(visible);
    }

    private void textModified(String text) {
        this.fRefactoring.setMethodName(text);
        RefactoringStatus status = this.validatePage(true);
        if (!status.hasFatalError()) {
            this.updatePreview(text);
        } else {
            this.fSignaturePreviewDocument.set("");
        }
        this.setPageComplete(status);
    }

    private void parameterModified() {
        this.updatePreview(this.getText());
        this.setPageComplete(this.validatePage(false));
    }

    private RefactoringStatus validatePage(boolean text) {
        RefactoringStatus result = new RefactoringStatus();
        if (text) {
            result.merge(this.validateMethodName());
            result.merge(this.validateParameters());
        } else {
            result.merge(this.validateParameters());
            result.merge(this.validateMethodName());
        }
        return result;
    }

    private RefactoringStatus validateMethodName() {
        RefactoringStatus result = new RefactoringStatus();
        String text = this.getText();
        if ("".equals(text)) {
            result.addFatalError(RefactoringMessages.ExtractMethodInputPage_validation_emptyMethodName);
            return result;
        }
        result.merge(this.fRefactoring.checkMethodName());
        return result;
    }

    private RefactoringStatus validateParameters() {
        RefactoringStatus result = new RefactoringStatus();
        List parameters = this.fRefactoring.getParameterInfos();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!"".equals(info.getNewName())) continue;
            result.addFatalError(RefactoringMessages.ExtractMethodInputPage_validation_emptyParameterName);
            return result;
        }
        result.merge(this.fRefactoring.checkParameterNames());
        result.merge(this.fRefactoring.checkVarargOrder());
        return result;
    }
}

