/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.performance.scalability;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.tests.performance.internal.scalability.RunValidatorTestCase;
import org.eclipse.wst.common.tests.performance.internal.util.EditorTestHelper;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.core.ValidationException;

public abstract class RunWSDLValidatorTestCase
extends RunValidatorTestCase {
    protected String getValidatorId() {
        return "org.eclipse.wst.wsdl.validation.wsdl";
    }

    protected String getBundleId() {
        return "org.eclipse.wst.wsdl.tests.performance";
    }

    protected void runValidator(IFile file) throws CoreException, ValidationException {
        this.waitForJobs();
        this.turnoffOtherValidators(this.getValidatorId());
        ValidationFramework vf = ValidationFramework.getDefault();
        IProject[] projects = new IProject[]{file.getProject()};
        try {
            vf.validate(projects, true, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            RunWSDLValidatorTestCase.fail((String)e.getMessage());
        }
    }

    private void waitForJobs() {
        try {
            EditorTestHelper.joinBackgroundActivities();
        }
        catch (CoreException e) {
            RunWSDLValidatorTestCase.fail((String)e.getMessage());
        }
    }

    private void turnoffOtherValidators(String id) {
        Validator[] vals = ValManager.getDefault().getValidators();
        int length = vals.length;
        int i = 0;
        while (i < length) {
            Validator v = vals[i];
            if (!v.getValidatorClassname().startsWith(id)) {
                v.setBuildValidation(false);
                v.setManualValidation(false);
            }
            ++i;
        }
    }
}

