/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.validation;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.jsp.core.internal.validation.JSPContentValidator;
import org.eclipse.jst.jsp.ui.tests.util.ProjectUtil;
import org.eclipse.jst.jsp.ui.tests.validation.ReporterForTest;
import org.eclipse.jst.jsp.ui.tests.validation.ValidationContextForTest;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSPHTMLValidatorTest
extends TestCase {
    String wtp_autotest_noninteractive = null;
    private static final String PROJECT_NAME = "bug_143209";

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists()) {
            ProjectUtil.createProject(PROJECT_NAME, null, new String[]{"org.eclipse.jdt.core.javanature"});
            ProjectUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug_143209", "/bug_143209");
        }
        JSPHTMLValidatorTest.assertTrue((String)"project could not be created", (boolean)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty("wtp.autotest.noninteractive", this.wtp_autotest_noninteractive);
        }
    }

    public void testJSPinAttributes() throws Exception {
        JSPContentValidator validator = new JSPContentValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/bug_143209/WebContent/usejspinattribute.jsp";
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPHTMLValidatorTest.assertTrue((String)"jsp in attributes are errors when they should not be (in .jsp)", (boolean)reporter.getMessages().isEmpty());
    }

    public void testJSPinAttributesHTML() throws Exception {
        JSPContentValidator validator = new JSPContentValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/bug_143209/WebContent/usejspinattribute.html";
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPHTMLValidatorTest.assertTrue((String)"jsp in attributes are not errors when they should be (in .html)", (!reporter.getMessages().isEmpty() ? 1 : 0) != 0);
    }

    public void testBadAttributeName() throws Exception {
        JSPContentValidator validator = new JSPContentValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/bug_143209/WebContent/badattributenames.jsp";
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPHTMLValidatorTest.assertTrue((String)"bad attribute name is not error when it should be", (!reporter.getMessages().isEmpty() ? 1 : 0) != 0);
    }

    /*
     * Exception decompiling
     */
    public void testRemoveAndAddBackCommentEndTag() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 336->340)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class TestReporter
    implements IReporter {
        private boolean messageReported = false;

        public void addMessage(IValidator origin, IMessage message) {
            this.messageReported = true;
        }

        public boolean isMessageReported() {
            return this.messageReported;
        }

        public void displaySubtask(IValidator validator, IMessage message) {
        }

        public List getMessages() {
            return null;
        }

        public boolean isCancelled() {
            return false;
        }

        public void removeAllMessages(IValidator origin, Object object) {
        }

        public void removeAllMessages(IValidator origin) {
        }

        public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        }
    }
}

