/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadata.tests.taglibprocessing;

import junit.framework.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.metadata.tests.taglibprocessing.TaglibProcessingTestCase;
import org.eclipse.jst.jsf.metadataprocessors.features.ELIsNotValidException;
import org.eclipse.jst.jsf.metadataprocessors.features.IDefaultValue;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidELValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;

public class ColorTypeTest
extends TaglibProcessingTestCase {
    public void testPossibleValues() {
        Assert.assertNotNull((Object)this.possibleValueAdapters);
        Assert.assertFalse((boolean)this.possibleValueAdapters.isEmpty());
        IPossibleValues pvs = (IPossibleValues)this.possibleValueAdapters.get(0);
        Assert.assertTrue((pvs.getPossibleValues().size() == 16 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(pvs.getPossibleValues().get(1) instanceof IPossibleValue));
        IPossibleValue pv = (IPossibleValue)pvs.getPossibleValues().get(1);
        Assert.assertTrue((boolean)pv.getValue().equalsIgnoreCase("silver"));
        Assert.assertNotNull((Object)pv.getIcon());
        Assert.assertTrue((boolean)(pv.getIcon() instanceof ImageDescriptor));
        Assert.assertEquals((int)192, (int)pv.getIcon().getImageData().getRGBs()[0].red);
        Assert.assertEquals((int)192, (int)pv.getIcon().getImageData().getRGBs()[0].green);
        Assert.assertEquals((int)192, (int)pv.getIcon().getImageData().getRGBs()[0].blue);
    }

    public void testValidValues() {
        Assert.assertNotNull((Object)this.validValuesAdapters);
        Assert.assertFalse((boolean)this.validValuesAdapters.isEmpty());
        IValidValues vv = (IValidValues)this.validValuesAdapters.get(0);
        Assert.assertTrue((boolean)vv.isValidValue("Black"));
        Assert.assertTrue((boolean)vv.isValidValue("BLACK"));
        Assert.assertTrue((boolean)vv.isValidValue("black"));
        Assert.assertTrue((boolean)vv.isValidValue("    BLACK     "));
        Assert.assertTrue((boolean)vv.isValidValue("Silver"));
        Assert.assertTrue((boolean)vv.isValidValue("Gray"));
        Assert.assertTrue((boolean)vv.isValidValue("White"));
        Assert.assertTrue((boolean)vv.isValidValue("Red"));
        Assert.assertTrue((boolean)vv.isValidValue("Purple"));
        Assert.assertTrue((boolean)vv.isValidValue("Fuchsia"));
        Assert.assertTrue((boolean)vv.isValidValue("Green"));
        Assert.assertTrue((boolean)vv.isValidValue("Lime"));
        Assert.assertTrue((boolean)vv.isValidValue("Olive"));
        Assert.assertTrue((boolean)vv.isValidValue("Yellow"));
        Assert.assertTrue((boolean)vv.isValidValue("Navy"));
        Assert.assertTrue((boolean)vv.isValidValue("Blue"));
        Assert.assertTrue((boolean)vv.isValidValue("Teal"));
        Assert.assertTrue((boolean)vv.isValidValue("Aqua"));
        Assert.assertFalse((boolean)vv.isValidValue("BlackAndBlue"));
        vv.getValidationMessages().clear();
        Assert.assertTrue((boolean)vv.isValidValue("#FFFFFF"));
        Assert.assertTrue((boolean)vv.isValidValue("#0FFFFF"));
        Assert.assertTrue((boolean)vv.isValidValue("#000001"));
        Assert.assertFalse((boolean)vv.isValidValue("1#FFFFF"));
        vv.getValidationMessages().clear();
        Assert.assertFalse((boolean)vv.isValidValue("FFFFFF"));
        vv.getValidationMessages().clear();
    }

    public void testDefaultValues() {
        Assert.assertNotNull((Object)this.defaultValueAdapters);
        Assert.assertFalse((boolean)this.defaultValueAdapters.isEmpty());
        IDefaultValue dv = (IDefaultValue)this.defaultValueAdapters.get(0);
        Assert.assertTrue((dv.getDefaultValue() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dv.getDefaultValue().equalsIgnoreCase("Black"));
    }

    public void testCreateValues() {
        Assert.assertNotNull((Object)this.createValuesAdapters);
        Assert.assertTrue((boolean)this.createValuesAdapters.isEmpty());
    }

    public void testGetExpectedReturnType() {
        Assert.assertNotNull((Object)this.validELValuesAdapters);
        IValidELValues vvel = (IValidELValues)this.validELValuesAdapters.get(0);
        try {
            Assert.assertEquals((String)"String", (String)vvel.getExpectedRuntimeType().toUserReadableString());
        }
        catch (ELIsNotValidException eLIsNotValidException) {
            ColorTypeTest.fail((String)"testGetExpectedReturnType");
        }
    }
}

