/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.classpath.tests;

import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.classpath.tests.AbstractTests;
import org.eclipse.jst.j2ee.classpath.tests.util.ClasspathDependencyTestUtil;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyCreationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;

public class ClasspathDependencyWebTests
extends AbstractTests {
    private static final String UTIL_PROJECT = "TestUtil";
    private static final String WEB_PROJECT = "TestWeb";

    private ClasspathDependencyWebTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Classpath Dependency Web Tests");
        suite.addTest((Test)new ClasspathDependencyWebTests("testWebExportJ2EE"));
        suite.addTest((Test)new ClasspathDependencyWebTests("testWebPublishJ2EE"));
        suite.addTest((Test)new ClasspathDependencyWebTests("testWebPublishJEE5"));
        return suite;
    }

    public void testWebExportJ2EE() throws Exception {
        this.testWebExport(false);
    }

    public void testWebExportJEE5() throws Exception {
        this.testWebExport(true);
    }

    private void testWebExport(boolean JEE5) throws Exception {
        IVirtualComponent webComp = this.createProjects(JEE5);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        this.verifyExportedWebInfLibs(webComp, archiveNames, false);
        this.addDependencyAttribute();
        this.verifyExportedWebInfLibs(webComp, archiveNames, true);
    }

    private void verifyExportedWebInfLibs(IVirtualComponent comp, Set archiveNames, boolean shouldHaveDependencies) throws Exception {
        WebArtifactEdit webEdit = null;
        WARFile warFile = null;
        try {
            webEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)comp);
            if (webEdit != null) {
                warFile = (WARFile)webEdit.asArchive(true);
                List libArchives = warFile.getLibArchives();
                for (String name : archiveNames) {
                    boolean hasArchive = false;
                    int i = 0;
                    while (i < libArchives.size()) {
                        File archive = (File)libArchives.get(i);
                        if (archive.isArchive() && archive.getName().equals(name)) {
                            hasArchive = true;
                        }
                        ++i;
                    }
                    if (shouldHaveDependencies) {
                        ClasspathDependencyWebTests.assertTrue((String)("Exported WAR missing classpath dependency Jar " + name), (boolean)hasArchive);
                        continue;
                    }
                    ClasspathDependencyWebTests.assertFalse((String)("Exported WAR has unexpected classpath dependency Jar " + name), (boolean)hasArchive);
                }
                List webInfClasses = warFile.getClasses();
                Iterator it = webInfClasses.iterator();
                boolean hasNestedTest = false;
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof FileImpl) || !((FileImpl)o).getURI().toString().equals("WEB-INF/classes/nested/test")) continue;
                    hasNestedTest = true;
                }
                if (shouldHaveDependencies) {
                    ClasspathDependencyWebTests.assertTrue((String)"Exported WAR missing nested class folder file", (boolean)hasNestedTest);
                } else {
                    ClasspathDependencyWebTests.assertFalse((String)"Exported WAR has unexpected nested class folder file", (boolean)hasNestedTest);
                }
            }
        }
        finally {
            if (webEdit != null) {
                webEdit.dispose();
            }
            if (warFile != null) {
                warFile.close();
            }
        }
    }

    public void testWebPublishJ2EE() throws Exception {
        this.testWebPublish(false);
    }

    public void testWebPublishJEE5() throws Exception {
        this.testWebPublish(true);
    }

    private void testWebPublish(boolean JEE5) throws Exception {
        IVirtualComponent webComp = this.createProjects(JEE5);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        this.verifyPublishedWebInfLibs(webComp, archiveNames, false);
        this.addDependencyAttribute();
        this.verifyPublishedWebInfLibs(webComp, archiveNames, true);
    }

    private void verifyPublishedWebInfLibs(IVirtualComponent comp, Set archiveNames, boolean shouldHaveDependencies) throws Exception {
        J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(comp.getProject(), comp);
        try {
            IModuleResource[] members = deployable.members();
            ClasspathDependencyWebTests.assertTrue((members.length == 2 ? 1 : 0) != 0);
            int i = 0;
            while (i < members.length) {
                String name = members[i].getName();
                if (name.equals("WEB-INF")) {
                    IModuleResource[] webInf = ((ModuleFolder)members[i]).members();
                    int j = 0;
                    while (j < webInf.length) {
                        IModuleResource[] webresMembers;
                        IModuleResource webResource = webInf[j];
                        ClasspathDependencyWebTests.assertTrue((boolean)webResource.getModuleRelativePath().toString().equals("WEB-INF"));
                        if (webResource.getName().equals("lib")) {
                            webresMembers = ((ModuleFolder)webResource).members();
                            for (String archiveName : archiveNames) {
                                boolean hasArchive = false;
                                int k = 0;
                                while (k < webresMembers.length) {
                                    String localName = webresMembers[k].getName();
                                    if (localName.equals(archiveName)) {
                                        hasArchive = true;
                                    }
                                    ++k;
                                }
                                if (shouldHaveDependencies) {
                                    ClasspathDependencyWebTests.assertTrue((String)("Published WAR missing classpath dependency Jar " + archiveName), (boolean)hasArchive);
                                    continue;
                                }
                                ClasspathDependencyWebTests.assertFalse((String)("Published WAR has unexpected classpath dependency Jar " + archiveName), (boolean)hasArchive);
                            }
                        } else if (webResource.getName().equals("classes")) {
                            webresMembers = ((ModuleFolder)webResource).members();
                            j = 0;
                            while (j < webresMembers.length) {
                                if (webresMembers[j].getName().equals("nested")) {
                                    IModuleResource[] nestedMembers = ((ModuleFolder)webresMembers[j]).members();
                                    ClasspathDependencyWebTests.assertTrue((String)"Published WAR should have have nested folder without class folder dependency", (boolean)shouldHaveDependencies);
                                    boolean hasNestedTest = false;
                                    if (nestedMembers.length == 1 && nestedMembers[0].getName().equals("test")) {
                                        hasNestedTest = true;
                                    }
                                    if (shouldHaveDependencies) {
                                        ClasspathDependencyWebTests.assertTrue((String)"Published WAR missing nested class folder file", (boolean)hasNestedTest);
                                    } else {
                                        ClasspathDependencyWebTests.assertFalse((String)"Published WAR has unexpected nested class folder file", (boolean)hasNestedTest);
                                    }
                                }
                                ++j;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            ClasspathDependencyWebTests.fail((String)e.getMessage());
        }
    }

    private IVirtualComponent createProjects(boolean JEE5) throws Exception {
        IProject util = ProjectUtil.createUtilityProject(UTIL_PROJECT, null, true);
        IJavaProject utilJava = JavaCore.create((IProject)util);
        ComponentCore.createComponent((IProject)util);
        int version = 25;
        if (!JEE5) {
            version = 24;
        }
        IProject webProject = ProjectUtil.createWebProject(WEB_PROJECT, null, version, true);
        IJavaProject webJavaProject = JavaCore.create((IProject)webProject);
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)webProject);
        Path binPath = new Path("bin");
        IFolder webBin = webProject.getFolder((IPath)binPath);
        webBin.create(true, true, null);
        IFolder nested = webBin.getFolder("nested");
        nested.create(true, true, null);
        nested.getFile("test").create((InputStream)new StringBufferInputStream("blah"), true, null);
        ClasspathDependencyTestUtil.addLibraryEntry(webJavaProject, webBin.getFullPath(), true);
        DependencyCreationUtil.createWebLibDependency(webProject, util);
        ClasspathDependencyTestUtil.addCustomClasspathContainer(utilJava);
        return webComp;
    }

    private void addDependencyAttribute() throws Exception {
        IProject util = ProjectUtil.getProject(UTIL_PROJECT);
        IJavaProject utilJava = JavaCore.create((IProject)util);
        IVirtualComponent utilComp = ComponentCore.createComponent((IProject)util);
        IProject web = ProjectUtil.getProject(WEB_PROJECT);
        IJavaProject webJava = JavaCore.create((IProject)web);
        IPath fullWebBinPath = web.getFullPath().append("bin");
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)web);
        HashSet<IPath> entryPaths = new HashSet<IPath>();
        entryPaths.add(ClasspathDependencyTestUtil.CUSTOM_CLASSPATH_CONTAINER);
        List entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(utilJava, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(utilJava);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(utilComp);
        IClasspathEntry entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)util.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(utilJava);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(utilJava, entryPaths);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        ClasspathDependencyTestUtil.verifyClasspathDependencies(utilComp, archiveNames);
        entryPaths.clear();
        entryPaths.add(fullWebBinPath);
        entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(webJava, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(webJava);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(webComp);
        entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)web.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(webJava);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(webJava, entryPaths);
        archiveNames.clear();
        archiveNames.add(fullWebBinPath.toString());
        ClasspathDependencyTestUtil.verifyClasspathDependencies(webComp, archiveNames);
    }
}

