/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.tests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.LifecycleCallback;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.javaee.ejb.ActivationConfigProperty;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.InitMethodType;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.RemoveMethodType;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    public static String getFileContent(IFile file) throws CoreException, IOException {
        InputStream stream = file.getContents();
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int i = 0;
            while ((i = stream.read()) != -1) {
                os.write(i);
            }
            String string = os.toString();
            return string;
        }
        finally {
            stream.close();
        }
    }

    public static EjbLocalRef findLocalRefByName(List<EjbLocalRef> localRefs, String refName) {
        for (EjbLocalRef ref : localRefs) {
            if (!refName.equals(ref.getEjbRefName())) continue;
            return ref;
        }
        return null;
    }

    public static RemoveMethodType findRemoveMethodByName(SessionBean bean, String methodName) {
        for (RemoveMethodType removeMethod : bean.getRemoveMethods()) {
            if (!methodName.equals(removeMethod.getBeanMethod().getMethodName())) continue;
            return removeMethod;
        }
        return null;
    }

    public static InitMethodType findInitMethodByName(SessionBean bean, String methodName) {
        for (InitMethodType iniMethod : bean.getInitMethods()) {
            if (!methodName.equals(iniMethod.getBeanMethod().getMethodName())) continue;
            return iniMethod;
        }
        return null;
    }

    public static LifecycleCallback findLifecycleMethod(List callbacks, String name) {
        for (LifecycleCallback callback : callbacks) {
            if (!name.equals(callback.getLifecycleCallbackMethod())) continue;
            return callback;
        }
        return null;
    }

    public static ResourceRef findResourceRefByName(List<ResourceRef> resourceRefs, String name) {
        for (ResourceRef ref : resourceRefs) {
            if (!name.equals(ref.getResRefName())) continue;
            return ref;
        }
        return null;
    }

    public static ActivationConfigProperty findActivationConfigProperty(MessageDrivenBean result, String name) {
        for (ActivationConfigProperty prop : result.getActivationConfig().getActivationConfigProperties()) {
            if (!name.equals(prop.getActivationConfigPropertyName())) continue;
            return prop;
        }
        return null;
    }

    public static SecurityRole findSecurityRole(List securityRoles, String roleName) {
        for (SecurityRole role : securityRoles) {
            if (!role.getRoleName().equals(roleName)) continue;
            return role;
        }
        return null;
    }

    public static SecurityRoleRef findSecurityRoleRef(List securityRefs, String string) {
        for (SecurityRoleRef ref : securityRefs) {
            if (!ref.getRoleName().equals(string)) continue;
            return ref;
        }
        return null;
    }

    public static Servlet findServletByName(WebApp app, String servletName) {
        for (Servlet servlet : app.getServlets()) {
            if (!servlet.getServletName().equals(servletName)) continue;
            return servlet;
        }
        return null;
    }

    public static SessionBean getSessionBean(EJBJar jar, String name) {
        if (jar.getEnterpriseBeans() == null) {
            return null;
        }
        for (SessionBean bean : jar.getEnterpriseBeans().getSessionBeans()) {
            if (!name.equals(bean.getEjbName())) continue;
            return bean;
        }
        return null;
    }

    public static MessageDrivenBean getMessageDrivenBean(EJBJar jar, String name) {
        if (jar.getEnterpriseBeans() == null) {
            return null;
        }
        for (MessageDrivenBean bean : jar.getEnterpriseBeans().getMessageDrivenBeans()) {
            if (!name.equals(bean.getEjbName())) continue;
            return bean;
        }
        return null;
    }
}

