/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.web.tests;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.internal.web.operations.NewServletClassDataModelProvider;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.SynchronousModelChangedListener;
import org.eclipse.jst.jee.model.tests.TestUtils;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class Web25MergedModelProviderTest
extends TestCase {
    private static IFacetedProject facetedProject;
    private IModelProvider fixture;

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite(Web25MergedModelProviderTest.class);
        return suite;
    }

    protected void setUp() throws Exception {
        this.setUpProject();
        this.fixture = ModelProviderManager.getModelProvider((IProject)facetedProject.getProject());
    }

    protected void tearDown() throws Exception {
        this.deleteProjectAndWait(facetedProject.getProject().getName());
    }

    private void deleteProjectAndWait(String projectName) throws InterruptedException {
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        this.fixture.addListener((IModelProviderListener)listener);
        AbstractTest.deleteProject(projectName);
        Web25MergedModelProviderTest.assertTrue((boolean)listener.waitForEvents());
        this.fixture.removeListener((IModelProviderListener)listener);
    }

    public void setUpProject() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(Web25MergedModelProviderTest.class.getSimpleName()) + this.getName());
        facetedProject = AbstractTest.createWebProject(project.getName());
        Web25MergedModelProviderTest.createProjectContent();
    }

    private static void createProjectContent() throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)facetedProject.getProject());
        IFolder comFolder = javaProject.getProject().getFolder("src/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testAddServletWithOperation() throws Exception {
        IDataModel dataModel = this.createAddServletModel("testAddServletWithOperation");
        this.executeAndWait(dataModel.getDefaultOperation());
        WebApp app = (WebApp)this.fixture.getModelObject();
        Web25MergedModelProviderTest.assertNotNull((Object)TestUtils.findServletByName(app, "testAddServletWithOperation"));
    }

    public void testAddServletFromJSP() throws Exception {
        AbstractTest.saveFile(facetedProject.getProject().getFile("WebContent/index.jsp"), "");
        IDataModel dataModel = this.createAddServletFromJSPModel("index.jsp", "index");
        this.executeAndWait(dataModel.getDefaultOperation());
        WebApp app = (WebApp)this.fixture.getModelObject();
        Web25MergedModelProviderTest.assertNotNull((Object)TestUtils.findServletByName(app, "index"));
    }

    private void saveFileAndUpdate(IFile webXml, String content) throws InterruptedException, Exception {
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        this.fixture.addListener((IModelProviderListener)listener);
        AbstractTest.saveFile(webXml, content);
        Web25MergedModelProviderTest.assertTrue((boolean)listener.waitForEvents());
        this.fixture.removeListener((IModelProviderListener)listener);
    }

    private IDataModel createAddServletFromJSPModel(String className, String dispayName) {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new NewServletClassDataModelProvider());
        dataModel.setStringProperty("NewJavaClassDataModel.CLASS_NAME", className);
        dataModel.setStringProperty("NewServletClassDataModel.DISPLAY_NAME", dispayName);
        dataModel.setStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", facetedProject.getProject().getName());
        dataModel.setBooleanProperty("NewServletClassDataModel.USE_EXISTING_CLASS", Boolean.TRUE.booleanValue());
        dataModel.setBooleanProperty("NewServletClassDataModel.IS_SERVLET_TYPE", Boolean.FALSE.booleanValue());
        return dataModel;
    }

    private IDataModel createAddServletModel(String className) {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new NewServletClassDataModelProvider());
        dataModel.setStringProperty("NewJavaClassDataModel.CLASS_NAME", className);
        dataModel.setStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", facetedProject.getProject().getName());
        dataModel.setBooleanProperty("NewServletClassDataModel.IS_SERVLET_TYPE", Boolean.TRUE.booleanValue());
        dataModel.setStringProperty("NewJavaClassDataModel.JAVA_PACKAGE", "org.eclipse");
        return dataModel;
    }

    private void executeAndWait(IDataModelOperation dataModelOperation) throws InterruptedException, ExecutionException {
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        this.fixture.addListener((IModelProviderListener)listener);
        dataModelOperation.execute(null, null);
        listener.waitForEvents();
        this.fixture.removeListener((IModelProviderListener)listener);
    }
}

