/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.resolver;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolver;

public class URIResolverTest
extends TestCase {
    private URIResolver uriResolver = null;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.validation.internal.resolver.URIResolverTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void setUp() throws Exception {
        this.uriResolver = new URIResolver();
    }

    public void testNormalizeAbsoluteFile() {
        String baseLocation = "file:/c:/somepath/somepath/file.txt";
        String systemId = "file:/c:/somepath/myfile.txt";
        URIResolverTest.assertEquals((String)"systemId is absolute and should not be modified.", (String)systemId, (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFile() {
        String baseLocation = "file:/c:/somepath/somepath/file.txt";
        String systemId = "myfile.txt";
        URIResolverTest.assertEquals((String)"systemId is simple relative and is not modified correctly.", (String)"file:/c:/somepath/somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileStartsWithDotDot() {
        String baseLocation = "file:/c:/somepath/somepath/file.txt";
        String systemId = "../myfile.txt";
        URIResolverTest.assertEquals((String)"systemId is relative with ../ and is not modified correctly.", (String)"file:/c:/somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileStartsWithDotDotTwice() {
        String baseLocation = "file:/c:/somepath/somepath/file.txt";
        String systemId = "../../myfile.txt";
        URIResolverTest.assertEquals((String)"systemId is relative with ../../ and is not modified correctly.", (String)"file:/c:/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileStartsWithDot() {
        String baseLocation = "file:/c:/somepath/somepath/file.txt";
        String systemId = "./myfile.txt";
        URIResolverTest.assertEquals((String)"systemId is relative with ./ and is not modified correctly.", (String)"file:/c:/somepath/somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileStartsWithDotTwice() {
        String baseLocation = "file:/c:/somepath/somepath/file.txt";
        String systemId = "././myfile.txt";
        URIResolverTest.assertEquals((String)"systemId is relative with ././ and is not modified correctly.", (String)"file:/c:/somepath/somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileStartsWithSlash() {
        String baseLocation = "file:/c:/somepath/somepath/file.txt";
        String systemId = "/myfile.txt";
        URIResolverTest.assertEquals((String)"systemId is relative beginning with / and is not modified correctly.", (String)"file:/c:/somepath/somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileDotDotInMiddle() {
        String baseLocation = "file:/c:/somepath/somepath/file.txt";
        String systemId = "somepath/../myfile.txt";
        URIResolverTest.assertEquals((String)"systemId is relative and contains ../ in the middle and is not modified correctly.", (String)"file:/c:/somepath/somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileFotInMiddle() {
        String baseLocation = "file:/c:/somepath/somepath/file.txt";
        String systemId = "somepath/./myfile.txt";
        URIResolverTest.assertEquals((String)"systemId is relative and contains ./ in the middle and is not modified correctly.", (String)"file:/c:/somepath/somepath/somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormlizeRelativeFileDotDotInMiddleOfBase() {
        String baseLocation = "file:/c:/somepath/../somepath/file.txt";
        String systemId = "myfile.txt";
        URIResolverTest.assertEquals((String)"baseLocation contains ../ in the middle and is not modified correctly.", (String)"file:/c:/somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileDotInMiddleOfBase() {
        String baseLocation = "file:/c:/somepath/./somepath/file.txt";
        String systemId = "myfile.txt";
        URIResolverTest.assertEquals((String)"baseLocation contains ./ in the middle and is not modified correctly.", (String)"file:/c:/somepath/somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileBaseStartsWithSlashDotDot() {
        String baseLocation = "file:/../somepath/file.txt";
        String systemId = "myfile.txt";
        URIResolverTest.assertEquals((String)"baseLocation starts with ../ and is not modified correctly.", (String)"file:/../somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileBaseStartsWithSlashDot() {
        String baseLocation = "file:/./somepath/file.txt";
        String systemId = "myfile.txt";
        URIResolverTest.assertEquals((String)"baseLocation starts with ./ and is not modified correctly.", (String)"file:/somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileBaseStartsWithDotDot() {
        String baseLocation = "file:../somepath/file.txt";
        String systemId = "myfile.txt";
        URIResolverTest.assertEquals((String)"baseLocation starts with ../ and is not modified correctly.", (String)"file:../somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileBaseStartsWithDot() {
        String baseLocation = "file:./somepath/file.txt";
        String systemId = "myfile.txt";
        URIResolverTest.assertEquals((String)"baseLocation starts with ./ and is not modified correctly.", (String)"file:somepath/myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileSomedirDotDot() {
        String baseLocation = "file:/somepath/file.txt";
        String systemId = "somedir../myfile.txt";
        URIResolverTest.assertEquals((String)"systemId has somedir../ and is not modified correctly.", (String)"file:/somepath/somedir../myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeRelativeFileSomedirDot() {
        String baseLocation = "file:/somepath/file.txt";
        String systemId = "somedir./myfile.txt";
        URIResolverTest.assertEquals((String)"systemId has somedir./ and is not modified correctly.", (String)"file:/somepath/somedir./myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeNullSystemId() {
        String baseLocation = "file:/somepath/file.txt";
        String systemId = null;
        URIResolverTest.assertEquals((String)"systemId is null.", null, (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeNullBaseLocation() {
        String baseLocation = null;
        String systemId = "somedir./myfile.txt";
        URIResolverTest.assertEquals((String)"systemId is null.", null, (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }

    public void testNormalizeSystemIdAbsoluteNullBaseLocation() {
        String baseLocation = "null";
        String systemId = "file:/somedir./myfile.txt";
        URIResolverTest.assertEquals((String)"systemId is null.", (String)"file:/somedir./myfile.txt", (String)this.uriResolver.resolve(baseLocation, null, systemId).getLogicalLocation());
    }
}

