/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests.performance;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.ui.tests.performance.Accessor;
import org.eclipse.wst.xml.ui.tests.performance.EditorTestHelper;
import org.eclipse.wst.xml.ui.tests.performance.util.FileUtil;
import org.eclipse.wst.xml.ui.tests.performance.util.ProjectUnzipUtility;

public class BasicEditorTest
extends PerformanceTestCase {
    protected StructuredTextEditor fEditor;
    private StyledText fTextWidget;
    private Accessor fAccessor;
    private IDocument fDocument;
    private ProjectUnzipUtility fProjUtil;
    protected String ZIP_FILE_NAME;
    protected String PROJECT_NAME;
    protected String FILE_NAME;
    protected final String F_SLASH = "/";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        this.unzipProject();
        this.setUpPrefs();
    }

    protected void setUpPrefs() {
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        EditorTestHelper.closeAllEditors();
    }

    private void unzipProject() {
        this.fProjUtil = new ProjectUnzipUtility();
        Location platformLocation = Platform.getInstanceLocation();
        File zipFile = null;
        try {
            zipFile = FileUtil.makeFileFor("projecttestfiles", this.ZIP_FILE_NAME, "projecttestfiles");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (zipFile != null) {
            this.fProjUtil.unzipAndImport(zipFile, platformLocation.getURL().getPath());
            try {
                this.fProjUtil.initProject(this.PROJECT_NAME);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void setUpEditor(String filename) {
        this.fEditor = this.openEditor((IPath)new Path("/" + this.PROJECT_NAME + "/" + filename));
        BasicEditorTest.assertNotNull((Object)this.fEditor);
        this.fTextWidget = this.fEditor.getTextViewer().getTextWidget();
        BasicEditorTest.assertNotNull((Object)this.fTextWidget);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.custom.StyledText");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fAccessor = new Accessor(this.fTextWidget, clazz);
        this.fDocument = this.getEditor().getDocumentProvider().getDocument((Object)this.getEditor().getEditorInput());
        BasicEditorTest.assertNotNull((Object)this.fDocument);
    }

    protected StructuredTextEditor openEditor(IPath path) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        BasicEditorTest.assertTrue((file != null && file.exists() ? 1 : 0) != 0);
        try {
            Object editor;
            IEditorPart part = EditorTestHelper.openInEditor(file, true);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((editor = part.getAdapter((Class)clazz)) instanceof StructuredTextEditor) {
                return (StructuredTextEditor)editor;
            }
            BasicEditorTest.fail();
            return null;
        }
        catch (PartInitException partInitException) {
            BasicEditorTest.fail();
            return null;
        }
    }

    protected void type(char character) {
        this.type(character, 0, 0);
    }

    protected void type(char character, int keyCode, int stateMask) {
        Event event = new Event();
        event.character = character;
        event.keyCode = keyCode;
        event.stateMask = stateMask;
        this.fAccessor.invoke("handleKeyDown", new Object[]{event});
    }

    protected void type(int keyCode, int stateMask) {
        Event event = new Event();
        event.keyCode = keyCode;
        event.stateMask = stateMask;
        this.fAccessor.invoke("handleKeyDown", new Object[]{event});
    }

    protected void typeString(String text) {
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            this.type(chars[i]);
            ++i;
        }
    }

    protected void typeAndRun(char character) {
        this.type(character);
        this.runEvents();
    }

    protected void runEvents() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null) {
            while (display.readAndDispatch()) {
            }
        }
    }

    protected void setCaret(int offset) {
        this.fEditor.getTextViewer().setSelection((ISelection)new TextSelection(offset, 0));
    }

    protected synchronized void sleep(int time) {
        try {
            ((Object)((Object)this)).wait(time);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected StructuredTextEditor getEditor() {
        return this.fEditor;
    }
}

