/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.validation.tests.internal;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xsd.core.internal.validation.XSDValidationConfiguration;
import org.eclipse.wst.xsd.core.internal.validation.eclipse.XSDValidator;
import org.eclipse.wst.xsd.validation.tests.internal.XSDValidationTestsPlugin;

public class BaseTestCase
extends TestCase {
    protected String FILE_PROTOCOL = "file:///";
    protected String PLUGIN_ABSOLUTE_PATH;
    protected String SAMPLES_DIR = "testresources/samples/";
    protected String GENERATED_RESULTS_DIR = "testresources/generatedResults/";
    protected String IDEAL_RESULTS_DIR = "testresources/idealResults/";
    protected String LOG_FILE_LOCATION = "results.log";
    protected static final String PLUGIN_NAME = "org.eclipse.wst.xsd.validation.tests";
    private XSDValidator validator = XSDValidator.getInstance();

    protected void setUp() {
        this.PLUGIN_ABSOLUTE_PATH = XSDValidationTestsPlugin.getInstallURL();
    }

    public void runTest(String testfile, String loglocation, String idealloglocation) {
        this.runTest(testfile, loglocation, idealloglocation, new XSDValidationConfiguration());
    }

    public void runTest(String testfile, String loglocation, String idealloglocation, XSDValidationConfiguration configuration) {
        ValidationReport valreport = this.validator.validate(testfile, null, configuration);
        try {
            this.createLog(loglocation, valreport);
            String generatedLog = this.getStringFromFile(loglocation);
            String idealLog = this.getStringFromFile(idealloglocation);
            BaseTestCase.assertEquals((String)idealLog, (String)generatedLog);
        }
        catch (Exception exception) {
            BaseTestCase.fail((String)"Could not compare log files");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getStringFromFile(String filename) throws Exception {
        StringBuffer filestring = new StringBuffer();
        Reader reader = null;
        BufferedReader bufreader = null;
        try {
            try {
                File file = new File(filename);
                reader = new FileReader(file);
                bufreader = new BufferedReader(reader);
                while (bufreader.ready()) {
                    filestring.append(String.valueOf(bufreader.readLine()) + "\n");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Exception();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            bufreader.close();
            reader.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        bufreader.close();
        reader.close();
        return filestring.toString();
    }

    private String createLog(String filename, ValidationReport valreport) {
        ValidationMessage[] valmessages = valreport.getValidationMessages();
        int nummessages = valmessages.length;
        StringBuffer errorsString = new StringBuffer();
        StringBuffer warningsString = new StringBuffer();
        int numerrors = 0;
        int numwarnings = 0;
        int i = 0;
        while (i < nummessages) {
            String message;
            ValidationMessage valmes = valmessages[i];
            if (valmes.getSeverity() == ValidationMessage.SEV_LOW) {
                ++numwarnings;
                message = valmes.getMessage();
                message = message.replaceAll("'[^']*" + this.getPluginName() + "[^'/]*/", "'");
                message = message.replaceAll("[(][^(]*" + this.getPluginName() + "[^'/]*/", "(");
                warningsString.append(String.valueOf(message) + " [" + valmes.getLineNumber() + ", " + valmes.getColumnNumber() + "]\n");
                warningsString.append(this.createNestedMessageString(valmes.getNestedMessages()));
            } else {
                ++numerrors;
                message = valmes.getMessage();
                message = message.replaceAll("'[^']*" + this.getPluginName() + "[^'/]*/", "'");
                message = message.replaceAll("[(][^(]*" + this.getPluginName() + "[^'/]*/", "(");
                errorsString.append(String.valueOf(message) + " [" + valmes.getLineNumber() + ", " + valmes.getColumnNumber() + "]\n");
                errorsString.append(this.createNestedMessageString(valmes.getNestedMessages()));
            }
            ++i;
        }
        StringBuffer log = new StringBuffer();
        log.append("number of errors      : " + numerrors + "\n");
        if (numwarnings > 0) {
            log.append("number of warnings    : " + numwarnings + "\n");
        }
        log.append("\n------------error list-------------------------------------------\n");
        if (numerrors == 0) {
            log.append("(none)\n");
        } else {
            log.append(errorsString.toString());
        }
        if (numwarnings > 0) {
            log.append("------------warning list-----------------------------------------\n");
            log.append(errorsString.toString());
        }
        log.append(warningsString.toString());
        log.append("-----------------------------------------------------------------\n");
        DataOutputStream outStream = null;
        try {
            File logfile = new File(filename);
            File parent = logfile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (logfile.exists()) {
                logfile.delete();
            }
            logfile.createNewFile();
            outStream = new DataOutputStream(new FileOutputStream(filename, true));
            outStream.writeBytes(log.toString());
            outStream.close();
        }
        catch (IOException iOException) {
            log.delete(0, log.length());
        }
        return log.toString();
    }

    protected String getPluginName() {
        return PLUGIN_NAME;
    }

    private String createNestedMessageString(List nestedMessages) {
        return this.createNestedMessageString(nestedMessages, 0);
    }

    private String createNestedMessageString(List nestedMessages, int depth) {
        if (nestedMessages != null && nestedMessages.size() > 0) {
            String messageString = "";
            Iterator nestedMesIter = nestedMessages.iterator();
            while (nestedMesIter.hasNext()) {
                ValidationMessage nesvalmes = (ValidationMessage)nestedMesIter.next();
                int i = 0;
                while (i < depth) {
                    messageString = String.valueOf(messageString) + " ";
                    ++i;
                }
                String message = nesvalmes.getMessage();
                message = message.replaceAll("'[^']*" + this.getPluginName() + "[^'/]*/", "'");
                message = message.replaceAll("[(][^(]*" + this.getPluginName() + "[^'/]*/", "[(]");
                messageString = String.valueOf(messageString) + "-> " + message + " [" + nesvalmes.getLineNumber() + ", " + nesvalmes.getColumnNumber() + "]\n";
                messageString = String.valueOf(messageString) + this.createNestedMessageString(nesvalmes.getNestedMessages(), depth + 1);
            }
            return messageString;
        }
        return "";
    }

    protected IProject createSimpleProject(String projectName, String[] files) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (!project.exists()) {
            try {
                project.create(null);
            }
            catch (CoreException e) {
                BaseTestCase.fail((String)("Could not create project " + projectName + (Object)((Object)e)));
            }
        }
        if (!project.isOpen()) {
            try {
                project.open(null);
            }
            catch (CoreException e) {
                BaseTestCase.fail((String)("Could not open project " + projectName + (Object)((Object)e)));
            }
        }
        try {
            IProjectDescription projectDescription = project.getDescription();
            projectDescription.setName(projectName);
            project.setDescription(projectDescription, null);
        }
        catch (Exception e) {
            BaseTestCase.fail((String)("Unable to set project properties for project " + projectName + ". " + e));
        }
        if (files != null) {
            int numfiles = files.length;
            int i = 0;
            while (i < numfiles) {
                try {
                    String filename = files[i];
                    filename = filename.replace('\\', '/');
                    if (filename.startsWith("file:")) {
                        filename = filename.substring(5);
                        while (filename.startsWith("/")) {
                            filename = filename.substring(1);
                        }
                    }
                    File file = new File(filename);
                    FileInputStream in = new FileInputStream(file);
                    IFile iFile = project.getFile(file.getName());
                    if (!iFile.exists()) {
                        iFile.create((InputStream)in, true, null);
                        in.close();
                    }
                }
                catch (Exception exception) {
                    BaseTestCase.fail((String)("Unable to locate file " + files[i]));
                }
                ++i;
            }
        }
        try {
            project.refreshLocal(-1, null);
        }
        catch (Exception exception) {}
        return project;
    }
}

