/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests.performance.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.eclipse.core.runtime.Platform;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;

public class EclipseTestRunner
implements TestListener {
    private PerformanceMeter perfMeter;
    public static final int SUCCESS = 0;
    public static final int FAILURES = 1;
    public static final int ERRORS = 2;
    private static final String SUITE_METHODNAME = "suite";
    private TestResult fTestResult;
    private String fTestPluginName;
    private Test fSuite;
    private static Vector fgFromCmdLine = new Vector();
    private Vector formatters = new Vector();
    private boolean fHaltOnError = false;
    private boolean fHaltOnFailure = false;
    private JUnitTest fJunitTest;
    private PrintStream fSystemError;
    private PrintStream fSystemOut;
    private Exception fException;
    private int fRetCode = 0;

    public static void main(String[] args) throws IOException {
        System.exit(EclipseTestRunner.run(args));
    }

    public static int run(String[] args) throws IOException {
        String className = null;
        String testPluginName = null;
        boolean haltError = false;
        boolean haltFail = false;
        Properties props = new Properties();
        int startArgs = 0;
        if (args.length > 0 && !args[0].startsWith("-")) {
            className = args[0];
            ++startArgs;
        }
        int i = startArgs;
        while (i < args.length) {
            if (args[i].toLowerCase().equals("-classname")) {
                if (i < args.length - 1) {
                    className = args[i + 1];
                }
                ++i;
            } else if (args[i].toLowerCase().equals("-testpluginname")) {
                if (i < args.length - 1) {
                    testPluginName = args[i + 1];
                }
                ++i;
            } else if (args[i].startsWith("haltOnError=")) {
                haltError = Project.toBoolean((String)args[i].substring(12));
            } else if (args[i].startsWith("haltOnFailure=")) {
                haltFail = Project.toBoolean((String)args[i].substring(14));
            } else if (args[i].startsWith("formatter=")) {
                try {
                    EclipseTestRunner.createAndStoreFormatter(args[i].substring(10));
                }
                catch (BuildException be) {
                    System.err.println(be.getMessage());
                    return 2;
                }
            } else if (args[i].startsWith("propsfile=")) {
                FileInputStream in = new FileInputStream(args[i].substring(10));
                props.load(in);
                in.close();
            } else if (args[i].equals("-testlistener")) {
                System.err.println("The -testlistener option is no longer supported\nuse the formatter= option instead");
                return 2;
            }
            ++i;
        }
        if (className == null) {
            throw new IllegalArgumentException("Test class name not specified");
        }
        JUnitTest t = new JUnitTest(className);
        Properties p = System.getProperties();
        Enumeration e = ((Hashtable)p).keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            props.put(key, ((Hashtable)p).get(key));
        }
        t.setProperties((Hashtable)props);
        EclipseTestRunner runner = new EclipseTestRunner(t, testPluginName, haltError, haltFail);
        EclipseTestRunner.transferFormatters(runner);
        runner.run();
        return runner.getRetCode();
    }

    public EclipseTestRunner(JUnitTest test, String testPluginName, boolean haltOnError, boolean haltOnFailure) {
        this.fJunitTest = test;
        this.fTestPluginName = testPluginName;
        this.fHaltOnError = haltOnError;
        this.fHaltOnFailure = haltOnFailure;
        try {
            this.fSuite = this.getTest(test.getName());
        }
        catch (Exception e) {
            this.fRetCode = 2;
            this.fException = e;
        }
    }

    protected Test getTest(String suiteClassName) throws TestFailedException {
        if (suiteClassName.length() <= 0) {
            this.clearStatus();
            return null;
        }
        Class testClass = null;
        try {
            testClass = this.loadSuiteClass(suiteClassName);
        }
        catch (ClassNotFoundException e) {
            String clazz = e.getMessage();
            if (clazz == null) {
                clazz = suiteClassName;
            }
            this.runFailed("Class not found \"" + clazz + "\"");
            return null;
        }
        catch (Exception e) {
            this.runFailed("Error: " + e.toString());
            return null;
        }
        Method suiteMethod = null;
        try {
            suiteMethod = testClass.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception exception) {
            this.clearStatus();
            return new TestSuite(testClass);
        }
        Test test = null;
        try {
            test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (InvocationTargetException e) {
            this.runFailed("Failed to invoke suite():" + e.getTargetException().toString());
            return null;
        }
        catch (IllegalAccessException e) {
            this.runFailed("Failed to invoke suite():" + e.toString());
            return null;
        }
        this.clearStatus();
        return test;
    }

    protected void runFailed(String message) throws TestFailedException {
        System.err.println(message);
        throw new TestFailedException(message);
    }

    protected void clearStatus() {
    }

    protected Class loadSuiteClass(String suiteClassName) throws ClassNotFoundException {
        if (this.fTestPluginName == null) {
            return Class.forName(suiteClassName);
        }
        ClassLoader loader = this.getPluginClassLoader(this.fTestPluginName);
        return loader.loadClass(suiteClassName);
    }

    public ClassLoader getPluginClassLoader(String pluginName) {
        if (Platform.getPluginRegistry().getPluginDescriptor(pluginName) != null) {
            return Platform.getPluginRegistry().getPluginDescriptor(pluginName).getPluginClassLoader();
        }
        throw new IllegalArgumentException("No ClassLoader found for testplugin: " + pluginName);
    }

    public void run() {
        this.fTestResult = new TestResult();
        this.fTestResult.addListener((TestListener)this);
        int i = 0;
        while (i < this.formatters.size()) {
            this.fTestResult.addListener((TestListener)this.formatters.elementAt(i));
            ++i;
        }
        long start = System.currentTimeMillis();
        this.fireStartTestSuite();
        if (this.fException != null) {
            int i2 = 0;
            while (i2 < this.formatters.size()) {
                ((TestListener)this.formatters.elementAt(i2)).addError(null, (Throwable)this.fException);
                ++i2;
            }
            this.fJunitTest.setCounts(1L, 0L, 1L);
            this.fJunitTest.setRunTime(0L);
        } else {
            ByteArrayOutputStream errStrm = new ByteArrayOutputStream();
            this.fSystemError = new PrintStream(errStrm);
            ByteArrayOutputStream outStrm = new ByteArrayOutputStream();
            this.fSystemOut = new PrintStream(outStrm);
            try {
                this.fSuite.run(this.fTestResult);
            }
            finally {
                this.fSystemError.close();
                this.fSystemError = null;
                this.fSystemOut.close();
                this.fSystemOut = null;
                this.sendOutAndErr(new String(outStrm.toByteArray()), new String(errStrm.toByteArray()));
                this.fJunitTest.setCounts((long)this.fTestResult.runCount(), (long)this.fTestResult.failureCount(), (long)this.fTestResult.errorCount());
                this.fJunitTest.setRunTime(System.currentTimeMillis() - start);
            }
        }
        this.fireEndTestSuite();
        if (this.fRetCode != 0 || this.fTestResult.errorCount() != 0) {
            this.fRetCode = 2;
        } else if (this.fTestResult.failureCount() != 0) {
            this.fRetCode = 1;
        }
    }

    public int getRetCode() {
        return this.fRetCode;
    }

    public void addFailure(Test test, AssertionFailedError t) {
        if (this.fHaltOnFailure) {
            this.fTestResult.stop();
        }
    }

    public void addError(Test test, Throwable t) {
        if (this.fHaltOnError) {
            this.fTestResult.stop();
        }
    }

    private void fireStartTestSuite() {
        int i = 0;
        while (i < this.formatters.size()) {
            ((JUnitResultFormatter)this.formatters.elementAt(i)).startTestSuite(this.fJunitTest);
            ++i;
        }
    }

    private void fireEndTestSuite() {
        int i = 0;
        while (i < this.formatters.size()) {
            ((JUnitResultFormatter)this.formatters.elementAt(i)).endTestSuite(this.fJunitTest);
            ++i;
        }
    }

    public void addFormatter(JUnitResultFormatter f) {
        this.formatters.addElement(f);
    }

    private static void createAndStoreFormatter(String line) throws BuildException {
        String formatterClassName = null;
        File formatterFile = null;
        int pos = line.indexOf(44);
        if (pos == -1) {
            formatterClassName = line;
        } else {
            formatterClassName = line.substring(0, pos);
            formatterFile = new File(line.substring(pos + 1));
        }
        fgFromCmdLine.addElement(EclipseTestRunner.createFormatter(formatterClassName, formatterFile));
    }

    private static void transferFormatters(EclipseTestRunner runner) {
        int i = 0;
        while (i < fgFromCmdLine.size()) {
            runner.addFormatter((JUnitResultFormatter)fgFromCmdLine.elementAt(i));
            ++i;
        }
    }

    private static JUnitResultFormatter createFormatter(String classname, File outfile) throws BuildException {
        OutputStream out = System.out;
        if (classname == null) {
            throw new BuildException("you must specify type or classname");
        }
        Class<?> f = null;
        try {
            f = EclipseTestRunner.class.getClassLoader().loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        Object o = null;
        try {
            o = f.newInstance();
        }
        catch (InstantiationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException((Throwable)e);
        }
        if (!(o instanceof JUnitResultFormatter)) {
            throw new BuildException(String.valueOf(classname) + " is not a JUnitResultFormatter");
        }
        JUnitResultFormatter r = o;
        if (outfile != null) {
            try {
                out = new FileOutputStream(outfile);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        r.setOutput(out);
        return r;
    }

    private void sendOutAndErr(String out, String err) {
        int i = 0;
        while (i < this.formatters.size()) {
            JUnitResultFormatter formatter = (JUnitResultFormatter)this.formatters.elementAt(i);
            formatter.setSystemOutput(out);
            formatter.setSystemError(err);
            ++i;
        }
    }

    protected void handleOutput(String line) {
        if (this.fSystemOut != null) {
            this.fSystemOut.println(line);
        }
    }

    protected void handleErrorOutput(String line) {
        if (this.fSystemError != null) {
            this.fSystemError.println(line);
        }
    }

    public void startTest(Test test) {
        Performance perf = Performance.getDefault();
        this.perfMeter = perf.createPerformanceMeter(test.getClass().getName());
        String tagName = System.getProperty("perf.tagAsGlobalSummary");
        if (tagName != null) {
            perf.tagAsGlobalSummary(this.perfMeter, tagName, Dimension.ELAPSED_PROCESS);
        }
        this.perfMeter.start();
    }

    public void endTest(Test test) {
        if (this.perfMeter != null) {
            this.perfMeter.stop();
            this.perfMeter.commit();
            Performance.getDefault().assertPerformance(this.perfMeter);
            this.perfMeter.dispose();
        }
    }

    class TestFailedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        TestFailedException(String message) {
            super(message);
        }
    }
}

