/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class TestStructuredTextEditor
extends TestCase {
    private final String PROJECT_NAME = "TestStructuredTextEditor";
    private final String FILE_NAME = "testStructuredTextEditor.xml";
    private static StructuredTextEditor fEditor;
    private static IFile fFile;
    private static boolean fIsSetup;
    static /* synthetic */ Class class$0;

    static {
        fIsSetup = false;
    }

    public TestStructuredTextEditor() {
        super("TestStructuredTextEditor");
    }

    protected void setUp() throws Exception {
        if (!fIsSetup) {
            this.createProject("TestStructuredTextEditor");
            fFile = this.getOrCreateFile("TestStructuredTextEditor/testStructuredTextEditor.xml");
            fIsSetup = true;
        }
        if (fIsSetup && fEditor == null) {
            FileEditorInput input;
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            IEditorPart part = page.openEditor((IEditorInput)(input = new FileEditorInput(fFile)), "org.eclipse.wst.sse.ui.StructuredTextEditor", true);
            if (part instanceof StructuredTextEditor) {
                fEditor = (StructuredTextEditor)part;
            } else {
                TestStructuredTextEditor.assertTrue((String)"Unable to open structured text editor", (boolean)false);
            }
        }
    }

    protected void tearDown() throws Exception {
        if (fEditor != null) {
            fEditor.close(false);
            TestStructuredTextEditor.assertTrue((String)"Unable to close editor", (boolean)true);
            fEditor = null;
        }
    }

    private void createProject(String projName) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected IFile getOrCreateFile(String filePath) {
        IFile blankJspFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        if (blankJspFile != null && !blankJspFile.exists()) {
            try {
                blankJspFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return blankJspFile;
    }

    public void testDoSaving() {
        fEditor.doRevertToSaved();
        TestStructuredTextEditor.assertTrue((String)"Unable to revert to saved", (boolean)true);
        fEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        TestStructuredTextEditor.assertTrue((String)"Unable to save", (boolean)true);
    }

    public void testEditorContextMenuAboutToShow() {
        MenuManager menu = new MenuManager();
        fEditor.editorContextMenuAboutToShow((IMenuManager)menu);
        TestStructuredTextEditor.assertTrue((String)"Unable to prepare for context menu about to show", (boolean)true);
        menu.dispose();
        menu = null;
    }

    public void testGetAdapter() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = fEditor.getAdapter((Class)clazz);
        TestStructuredTextEditor.assertTrue((String)"Get adapter for show in target failed", (boolean)(adapter instanceof IShowInTargetList));
    }

    public void testGetSetEditorPart() {
        fEditor.setEditorPart(null);
        TestStructuredTextEditor.assertTrue((String)"Unable to set editor part", (boolean)true);
        IEditorPart part = fEditor.getEditorPart();
        TestStructuredTextEditor.assertTrue((String)"Did not get expected editor part", (boolean)(part instanceof StructuredTextEditor));
    }

    public void testInitializeDocumentProvider() {
        fEditor.initializeDocumentProvider(null);
        TestStructuredTextEditor.assertTrue((String)"Unable to initialize document provider", (boolean)true);
    }

    public void testGetOrientation() {
        int or = fEditor.getOrientation();
        TestStructuredTextEditor.assertEquals((int)0x2000000, (int)or);
    }

    public void testGetSelectionProvider() {
        ISelectionProvider provider = fEditor.getSelectionProvider();
        TestStructuredTextEditor.assertNotNull((String)"Editor's selection provider was null", (Object)provider);
    }

    public void testGetTextViewer() {
        StructuredTextViewer viewer = fEditor.getTextViewer();
        TestStructuredTextEditor.assertNotNull((String)"Editor's text viewer was null", (Object)viewer);
    }

    public void testRememberRestoreSelection() {
        fEditor.rememberSelection();
        TestStructuredTextEditor.assertTrue((String)"Unable to remember editor selection", (boolean)true);
        fEditor.restoreSelection();
        TestStructuredTextEditor.assertTrue((String)"Unable to restore editor selection", (boolean)true);
    }

    public void testSafelySanityCheck() {
        fEditor.safelySanityCheckState(fEditor.getEditorInput());
        TestStructuredTextEditor.assertTrue((String)"Unable to safely sanity check editor state", (boolean)true);
    }

    public void testShowBusy() {
        fEditor.showBusy(false);
        TestStructuredTextEditor.assertTrue((String)"Unable to show editor is busy", (boolean)true);
    }

    public void testUpdate() {
        fEditor.update();
        TestStructuredTextEditor.assertTrue((String)"Unable to update editor", (boolean)true);
    }

    public void testSingleNonUIThreadUpdatesToEditorDocument() throws Exception {
        IFile file = this.getOrCreateFile("TestStructuredTextEditor/testBackgroundChanges.xml");
        ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
        textFileBufferManager.connect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        ITextFileBuffer textFileBuffer = textFileBufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        final IDocument document = textFileBuffer.getDocument();
        document.replace(0, 0, "<?xml encoding=\"UTF-8\" version=\"1.0\"?>\n");
        textFileBuffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
        String testText = String.valueOf(document.get()) + "<c/><b/><a/>";
        final int end = document.getLength();
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart openedEditor = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
        final boolean[] state = new boolean[1];
        Job changer = new Job("text changer"){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        document.replace(end, 0, "<a/>");
                        document.replace(end, 0, "<b/>");
                        document.replace(end, 0, "<c/>");
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.eclipse.wst.sse.ui", e.getMessage());
                        Object var3_4 = null;
                        state[0] = true;
                        return status;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    state[0] = true;
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                    state[0] = true;
                    return Status.OK_STATUS;
                }
            }
        };
        changer.setUser(true);
        changer.setSystem(false);
        changer.schedule();
        while (!state[0]) {
            openedEditor.getSite().getShell().getDisplay().readAndDispatch();
        }
        String finalText = document.get();
        textFileBuffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
        textFileBufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        activePage.closeEditor(openedEditor, false);
        TestStructuredTextEditor.assertEquals((String)"Non-UI changes did not apply", (String)testText, (String)finalText);
    }

    public void testManyNonUIThreadsUpdatingEditorDocument() throws Exception {
        long timeout = 960000L;
        long startTime = System.currentTimeMillis();
        IFile file = this.getOrCreateFile("TestStructuredTextEditor/testManyBackgroundChanges.xml");
        ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
        textFileBufferManager.connect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        ITextFileBuffer textFileBuffer = textFileBufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        final IDocument document = textFileBuffer.getDocument();
        document.replace(0, 0, "<?xml encoding=\"UTF-8\" version=\"1.0\"?>\n");
        textFileBuffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
        final int insertionPoint = document.getLength();
        int testLength = insertionPoint + 3120;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        activePage.showView("org.eclipse.ui.views.ProgressView");
        IEditorPart openedEditor = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
        final int[] finished = new int[]{30};
        Job[] changers = new Job[30];
        int i = 0;
        while (i < changers.length) {
            changers[i] = new Job("Text Changer " + Integer.toString(i)){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            char[] names = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
                            int j = 0;
                            while (j < names.length) {
                                document.replace(insertionPoint + 4 * j, 0, "<" + names[j] + "/>");
                                ++j;
                            }
                        }
                        catch (Exception e) {
                            Status status = new Status(4, "org.eclipse.wst.sse.ui", e.getMessage());
                            Object var4_6 = null;
                            finished[0] = finished[0] - 1;
                            return status;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        finished[0] = finished[0] - 1;
                        throw throwable;
                    }
                    {
                        Object var4_8 = null;
                    }
                    finished[0] = finished[0] - 1;
                    return Status.OK_STATUS;
                }
            };
            changers[i].setUser(true);
            changers[i].setSystem(false);
            changers[i].schedule();
            ++i;
        }
        long runtime = 0L;
        while (finished[0] > 0 && (runtime = System.currentTimeMillis()) - startTime < timeout) {
            openedEditor.getSite().getShell().getDisplay().readAndDispatch();
        }
        TestStructuredTextEditor.assertTrue((String)"Test timed out", (runtime - startTime < timeout ? 1 : 0) != 0);
        int finalLength = document.getLength();
        textFileBuffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
        textFileBufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        activePage.closeEditor(openedEditor, false);
        TestStructuredTextEditor.assertEquals((String)"Some non-UI changes did not apply", (int)testLength, (int)finalLength);
    }
}

