/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.splash;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;

class SplashScreen
extends JWindow
implements ActionListener,
BuildListener {
    private JLabel text;
    private JProgressBar pb;
    private int total;
    private static final int MIN = 0;
    private static final int MAX = 200;

    public SplashScreen(String msg) {
        this.init(null);
        this.setText(msg);
    }

    public SplashScreen(ImageIcon img) {
        this.init(img);
    }

    protected void init(ImageIcon img) {
        JPanel pan = (JPanel)this.getContentPane();
        JLabel piccy = img == null ? new JLabel() : new JLabel(img);
        piccy.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.text = new JLabel("Building....", 0);
        this.text.setFont(new Font("Sans-Serif", 1, 12));
        this.text.setBorder(BorderFactory.createEtchedBorder());
        this.pb = new JProgressBar(0, 200);
        this.pb.setBorder(BorderFactory.createBevelBorder(1));
        JPanel pan2 = new JPanel();
        pan2.setLayout(new BorderLayout());
        pan2.add((Component)this.text, "North");
        pan2.add((Component)this.pb, "South");
        pan.setLayout(new BorderLayout());
        pan.add((Component)piccy, "Center");
        pan.add((Component)pan2, "South");
        pan.setBorder(BorderFactory.createBevelBorder(0));
        this.pack();
        Dimension size = this.getSize();
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (scr.width - size.width) / 2;
        int y = (scr.height - size.height) / 2;
        this.setBounds(x, y, size.width, size.height);
    }

    public void setText(String txt) {
        this.text.setText(txt);
    }

    public void actionPerformed(ActionEvent a) {
        this.total = this.total < 200 ? ++this.total : 0;
        this.pb.setValue(this.total);
    }

    public void buildStarted(BuildEvent event) {
        this.actionPerformed(null);
    }

    public void buildFinished(BuildEvent event) {
        this.pb.setValue(200);
        this.setVisible(false);
        this.dispose();
    }

    public void targetStarted(BuildEvent event) {
        this.actionPerformed(null);
    }

    public void targetFinished(BuildEvent event) {
        this.actionPerformed(null);
    }

    public void taskStarted(BuildEvent event) {
        this.actionPerformed(null);
    }

    public void taskFinished(BuildEvent event) {
        this.actionPerformed(null);
    }

    public void messageLogged(BuildEvent event) {
        this.actionPerformed(null);
    }
}

