/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.tests.j2ee;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.tests.AllTests;
import org.eclipse.jst.server.core.tests.j2ee.ModuleHelper;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class ModuleTestCase
extends TestCase {
    private static final String RUNTIME_TYPE_ID = "org.eclipse.jst.server.core.runtimeType";
    private static final String[] PROJECT_NAMES = new String[]{"PublishTestEAR", "PublishTestEJB", "PublishTestUtil", "PublishTestUtil2", "PublishTestWeb", "PublishTestWeb2", "PublishTestConnector", "PublishTestClient"};
    protected static IRuntime runtime;
    protected static IModule module;
    protected static IEnterpriseApplication ent;
    protected static IWebModule webModule;
    protected static IJ2EEModule j2eeModule;

    public void test000CreateRuntime() throws Exception {
        IRuntimeType rt = ServerCore.findRuntimeType((String)RUNTIME_TYPE_ID);
        IRuntimeWorkingCopy wc = rt.createRuntime("RuntimeLibraries", null);
        wc.setLocation(AllTests.runtimeLocation);
        wc.setName("RuntimeLibraries");
        runtime = wc.save(false, null);
        ModuleTestCase.assertTrue((!runtime.isWorkingCopy() ? 1 : 0) != 0);
    }

    public void test001ImportModules() throws Exception {
        ModuleHelper.importProject("PublishEAR.zip", PROJECT_NAMES);
    }

    public void test002IncrementalBuild() throws Exception {
        ModuleHelper.buildIncremental();
    }

    public void test003NumModules() throws Exception {
        ModuleTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.ear").length, (int)1);
    }

    public void test004NumModules() throws Exception {
        ModuleTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.web").length, (int)2);
    }

    public void test005NumModules() throws Exception {
        ModuleTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.ejb").length, (int)1);
    }

    public void test006NumModules() throws Exception {
        ModuleTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.utility").length, (int)2);
    }

    public void test007NumModules() throws Exception {
        ModuleTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.appclient").length, (int)1);
    }

    public void test008NumModules() throws Exception {
        ModuleTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.connector").length, (int)1);
    }

    public void test020EAR() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestEAR");
        ModuleTestCase.assertNotNull((Object)module);
    }

    public void test021EAR() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/application.xml")) {
            ModuleTestCase.fail();
        }
    }

    public void test022EAR() throws Exception {
        if (!ModuleHelper.fileExists(module, "test.jar")) {
            ModuleTestCase.fail();
        }
    }

    public void test023EAR() throws Exception {
        if (!ModuleHelper.fileExists(module, "jarfolder/test3.jar")) {
            ModuleTestCase.fail();
        }
    }

    public void test024EAR() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)3);
    }

    public void test025EAR() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)2);
    }

    public void test026EAR() throws Exception {
        ModuleTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.ear");
    }

    public void test027EAR() throws Exception {
        ent = (IEnterpriseApplication)module.loadAdapter(IEnterpriseApplication.class, null);
        ModuleTestCase.assertNotNull((Object)ent);
    }

    public void test028EAR() throws Exception {
        ModuleTestCase.assertEquals((int)ent.getResourceFolders().length, (int)1);
    }

    public void test029EAR() throws Exception {
        ModuleTestCase.assertEquals((int)ent.getModules().length, (int)6);
    }

    public void _test030EAR() throws Exception {
        String[] s;
        IModule[] modules = ent.getModules();
        ArrayList<String> list = new ArrayList<String>(modules.length);
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            System.out.println(m.getName());
            list.add(m.getName());
            ++n2;
        }
        String[] stringArray = s = new String[]{"PublishTestEJB", "PublishTestUtil2", "PublishTestWeb", "PublishTestWeb2", "PublishTestConnector", "PublishTestClient"};
        int n3 = s.length;
        n = 0;
        while (n < n3) {
            String ss = stringArray[n];
            if (!list.contains(ss)) {
                ModuleTestCase.fail((String)("EAR does not contain " + ss));
            }
            ++n;
        }
    }

    public void test040Util() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestUtil");
        ModuleTestCase.assertNotNull((Object)module);
    }

    public void test041Util() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void test042Util() throws Exception {
        if (!ModuleHelper.fileExists(module, "test.properties")) {
            ModuleTestCase.fail();
        }
    }

    public void test043Util() throws Exception {
        if (!ModuleHelper.fileExists(module, "publish/TestUtil.class")) {
            ModuleTestCase.fail();
        }
    }

    public void test044Util() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)3);
    }

    public void test045Util() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)2);
    }

    public void test046Util() throws Exception {
        ModuleTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.utility");
    }

    public void test047Util() throws Exception {
        j2eeModule = (IJ2EEModule)module.loadAdapter(IJ2EEModule.class, null);
        ModuleTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test048Util() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test049Util() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test050Util() throws Exception {
        ModuleTestCase.assertFalse((boolean)j2eeModule.isBinary());
    }

    public void test060Util() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestUtil2");
        ModuleTestCase.assertNotNull((Object)module);
    }

    public void test061Util() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void test062Util() throws Exception {
        if (!ModuleHelper.fileExists(module, "temp/test.properties")) {
            ModuleTestCase.fail();
        }
    }

    public void test063Util() throws Exception {
        if (!ModuleHelper.fileExists(module, "publish/TestUtil2.class")) {
            ModuleTestCase.fail();
        }
    }

    public void test064Util() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)3);
    }

    public void test065Util() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)3);
    }

    public void test066Util() throws Exception {
        ModuleTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.utility");
    }

    public void test067Util() throws Exception {
        j2eeModule = (IJ2EEModule)module.loadAdapter(IJ2EEModule.class, null);
        ModuleTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test068Util() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test069Util() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test070Util() throws Exception {
        ModuleTestCase.assertFalse((boolean)j2eeModule.isBinary());
    }

    public void test080EJB() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestEJB");
        ModuleTestCase.assertNotNull((Object)module);
    }

    public void test081EJB() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void test082EJB() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/ejb-jar.xml")) {
            ModuleTestCase.fail();
        }
    }

    public void test083EJB() throws Exception {
        if (!ModuleHelper.fileExists(module, "ejbs/MyBeanLocalHome.class")) {
            ModuleTestCase.fail();
        }
    }

    public void test084EJB() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)7);
    }

    public void test085EJB() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)2);
    }

    public void test086EJB() throws Exception {
        ModuleTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.ejb");
    }

    public void test087EJB() throws Exception {
        j2eeModule = (IJ2EEModule)module.loadAdapter(IJ2EEModule.class, null);
        ModuleTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test088EJB() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test089EJB() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test090EJB() throws Exception {
        ModuleTestCase.assertFalse((boolean)j2eeModule.isBinary());
    }

    public void test100Connector() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestConnector");
        ModuleTestCase.assertNotNull((Object)module);
    }

    public void test101Connector() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void test102Connector() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/ra.xml")) {
            ModuleTestCase.fail();
        }
    }

    public void test103Connector() throws Exception {
        if (!ModuleHelper.fileExists(module, "test/MyOtherConnectorClass.class")) {
            ModuleTestCase.fail();
        }
    }

    public void test104Connector() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)5);
    }

    public void test105Connector() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)3);
    }

    public void test106Connector() throws Exception {
        ModuleTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.connector");
    }

    public void test107Connector() throws Exception {
        j2eeModule = (IJ2EEModule)module.loadAdapter(IJ2EEModule.class, null);
        ModuleTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test108Connector() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test109Connector() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test110Connector() throws Exception {
        ModuleTestCase.assertFalse((boolean)j2eeModule.isBinary());
    }

    public void test120Client() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestClient");
        ModuleTestCase.assertNotNull((Object)module);
    }

    public void test121Client() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void test122Client() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/application-client.xml")) {
            ModuleTestCase.fail();
        }
    }

    public void test123Client() throws Exception {
        if (!ModuleHelper.fileExists(module, "Main.class")) {
            ModuleTestCase.fail();
        }
    }

    public void test124Client() throws Exception {
        if (!ModuleHelper.fileExists(module, "Main2.class")) {
            ModuleTestCase.fail();
        }
    }

    public void test125Client() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)4);
    }

    public void test126Client() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)1);
    }

    public void test127Client() throws Exception {
        ModuleTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.appclient");
    }

    public void test128Client() throws Exception {
        j2eeModule = (IJ2EEModule)module.loadAdapter(IJ2EEModule.class, null);
        ModuleTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test129Client() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test130Client() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test131Client() throws Exception {
        ModuleTestCase.assertFalse((boolean)j2eeModule.isBinary());
    }

    public void test140Web() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestWeb");
        ModuleTestCase.assertNotNull((Object)module);
    }

    public void test141Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void test142Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/web.xml")) {
            ModuleTestCase.fail();
        }
    }

    public void test143Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "test.jsp")) {
            ModuleTestCase.fail();
        }
    }

    public void test144Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/classes/servtest/TestServlet2.class")) {
            ModuleTestCase.fail();
        }
    }

    public void test145Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/classes/servtest/TestServlet.class")) {
            ModuleTestCase.fail();
        }
    }

    public void test146Web() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)5);
    }

    public void test147Web() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)5);
    }

    public void test148Web() throws Exception {
        ModuleTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.web");
    }

    public void test149Web() throws Exception {
        webModule = (IWebModule)module.loadAdapter(IWebModule.class, null);
        j2eeModule = webModule;
        ModuleTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test150Web() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test151Web() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test152Web() throws Exception {
        ModuleTestCase.assertEquals((int)webModule.getModules().length, (int)1);
    }

    public void test153Web() throws Exception {
        ModuleTestCase.assertEquals((String)webModule.getModules()[0].getName(), (String)"PublishTestUtil");
    }

    public void test154Web() throws Exception {
        ModuleTestCase.assertEquals((String)webModule.getContextRoot(), (String)"PublishTestWeb");
    }

    public void test155Web() throws Exception {
        ModuleTestCase.assertFalse((boolean)webModule.isBinary());
    }

    public void test160Web() throws Exception {
        module = ModuleHelper.getModuleFromProject("PublishTestWeb2");
        ModuleTestCase.assertNotNull((Object)module);
    }

    public void test161Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void test162Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/web.xml")) {
            ModuleTestCase.fail();
        }
    }

    public void test163Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/lib/test.jar")) {
            ModuleTestCase.fail();
        }
    }

    public void test164Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/classes/serv/AServlet.class")) {
            ModuleTestCase.fail();
        }
    }

    public void test165Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "WEB-INF/classes/serv/BServlet.class")) {
            ModuleTestCase.fail();
        }
    }

    public void test166Web() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)5);
    }

    public void test167Web() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)5);
    }

    public void test168Web() throws Exception {
        ModuleTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.web");
    }

    public void test169Web() throws Exception {
        webModule = (IWebModule)module.loadAdapter(IWebModule.class, null);
        j2eeModule = webModule;
        ModuleTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test170Web() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test171Web() throws Exception {
        ModuleTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)1);
    }

    public void test172Web() throws Exception {
        ModuleTestCase.assertEquals((int)webModule.getModules().length, (int)0);
    }

    public void test173Web() throws Exception {
        ModuleTestCase.assertEquals((String)webModule.getContextRoot(), (String)"PublishTestWeb2");
    }

    public void test174Web() throws Exception {
        ModuleTestCase.assertFalse((boolean)webModule.isBinary());
    }

    public void test199Cleanup() throws Exception {
        String[] stringArray = PROJECT_NAMES;
        int n = PROJECT_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            ModuleHelper.deleteProject(projectName);
            ++n2;
        }
    }
}

