/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.jsflibraryregistry;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;

public class MaintainDefaultImplementationAdapterTestCases
extends TestCase {
    public MaintainDefaultImplementationAdapterTestCases(String name) {
        super(name);
    }

    protected JSFLibraryRegistry getPreparedJSFLibraryRegistry() {
        JSFLibraryRegistry registry = JSFCoreUtilHelper.getJSFLibraryRegistryFromJSFLibraryHelper();
        registry.getJSFLibraries().clear();
        registry.getPluginProvidedJSFLibraries().clear();
        registry.setDefaultImplementation(null);
        return registry;
    }

    public void testAddingFirstImplSetsNewDefaultImpl() {
        JSFLibraryRegistry registry = this.getPreparedJSFLibraryRegistry();
        JSFLibrary impl1 = JSFCoreUtilHelper.constructJSFLib("impl1", "testfiles/JSFLib", true, false);
        registry.addJSFLibrary(impl1);
        Assert.assertEquals((Object)impl1, (Object)registry.getDefaultImplementation());
    }

    public void testRemovingDefaultImplSetsNewDefaultImpl() {
        JSFLibraryRegistry registry = this.getPreparedJSFLibraryRegistry();
        JSFLibrary impl1 = JSFCoreUtilHelper.constructJSFLib("impl1", "testfiles/JSFLib", true, false);
        registry.addJSFLibrary(impl1);
        JSFLibrary impl2 = JSFCoreUtilHelper.constructJSFLib("impl2", "testfiles/JSFLib", true, false);
        registry.addJSFLibrary(impl2);
        Assert.assertEquals((Object)impl1, (Object)registry.getDefaultImplementation());
        registry.removeJSFLibrary(impl1);
        Assert.assertEquals((Object)impl2, (Object)registry.getDefaultImplementation());
    }

    public void testRemovingLastImplNullsDefaultImpl() {
        JSFLibraryRegistry registry = this.getPreparedJSFLibraryRegistry();
        JSFLibrary impl1 = JSFCoreUtilHelper.constructJSFLib("impl1", "testfiles/JSFLib", true, false);
        registry.addJSFLibrary(impl1);
        Assert.assertEquals((Object)impl1, (Object)registry.getDefaultImplementation());
        registry.removeJSFLibrary(impl1);
        Assert.assertNull((Object)registry.getDefaultImplementation());
    }

    public void testChangingLibToImplSetsNewDefaultImpl() {
        JSFLibraryRegistry registry = this.getPreparedJSFLibraryRegistry();
        JSFLibrary lib1 = JSFCoreUtilHelper.constructJSFLib("lib1", "testfiles/JSFLib", false, false);
        registry.addJSFLibrary(lib1);
        Assert.assertNull((Object)registry.getDefaultImplementation());
        lib1.setImplementation(true);
        Assert.assertEquals((Object)lib1, (Object)registry.getDefaultImplementation());
    }

    public void testChangingImplToLibSetsNewDefaultImpl() {
        JSFLibraryRegistry registry = this.getPreparedJSFLibraryRegistry();
        JSFLibrary impl1 = JSFCoreUtilHelper.constructJSFLib("impl1", "testfiles/JSFLib", true, false);
        registry.addJSFLibrary(impl1);
        JSFLibrary impl2 = JSFCoreUtilHelper.constructJSFLib("impl2", "testfiles/JSFLib", true, false);
        registry.addJSFLibrary(impl2);
        Assert.assertEquals((Object)impl1, (Object)registry.getDefaultImplementation());
        impl1.setImplementation(false);
        Assert.assertEquals((Object)impl2, (Object)registry.getDefaultImplementation());
    }

    public void testChangingLastImplToLibNullsDefaultImpl() {
        JSFLibraryRegistry registry = this.getPreparedJSFLibraryRegistry();
        JSFLibrary impl1 = JSFCoreUtilHelper.constructJSFLib("impl1", "testfiles/JSFLib", true, false);
        registry.addJSFLibrary(impl1);
        Assert.assertEquals((Object)impl1, (Object)registry.getDefaultImplementation());
        impl1.setImplementation(false);
        Assert.assertNull((Object)registry.getDefaultImplementation());
    }
}

