/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tests.tabbed.properties.sections;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.properties.WPETabbedPropertySheetPage;
import org.eclipse.jst.pagedesigner.tests.PageDesignerTestsPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Node;

public class BaseTestCase
extends TestCase {
    private static final String HTML_EDITOR_ID = "org.eclipse.jst.pagedesigner.PageDesignerEditor";
    protected WebProjectTestEnvironment _webProjectTestEnv;
    protected WebProjectTestEnvironment _webProjectTestEnv2;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._webProjectTestEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName());
        this._webProjectTestEnv.createProject(false);
        BaseTestCase.assertNotNull((Object)this._webProjectTestEnv);
        BaseTestCase.assertNotNull((Object)this._webProjectTestEnv.getTestProject());
        BaseTestCase.assertTrue((boolean)this._webProjectTestEnv.getTestProject().isAccessible());
        this._webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/propertypages/testPropPages.tld.data", "/META-INF/testPropPages.tld");
    }

    protected IFile getJSPFile(String srcFileName, String destFileName) throws IOException, CoreException {
        return this.getJSPFile(srcFileName, destFileName, this._webProjectTestEnv);
    }

    private IFile getJSPFile(String srcFileName, String destFileName, WebProjectTestEnvironment webProjectTestEnv) throws IOException, CoreException {
        return (IFile)webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), srcFileName, destFileName);
    }

    protected IFile getJSPFileFromSecondProject(String srcFileName, String destFileName) throws IOException, CoreException {
        this._webProjectTestEnv2 = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName() + "_2");
        this._webProjectTestEnv2.createProject(false);
        BaseTestCase.assertNotNull((Object)this._webProjectTestEnv2);
        BaseTestCase.assertNotNull((Object)this._webProjectTestEnv2.getTestProject());
        BaseTestCase.assertTrue((boolean)this._webProjectTestEnv2.getTestProject().isAccessible());
        this._webProjectTestEnv2.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/propertypages/testPropPages.tld.data", "/META-INF/testPropPages.tld");
        return this.getJSPFile(srcFileName, destFileName, this._webProjectTestEnv2);
    }

    private ContextWrapper getDocumentContext(IFile jspFile, int offset) throws Exception {
        BaseTestCase.assertTrue((boolean)jspFile.exists());
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        model = modelManager.getModelForRead(jspFile);
        BaseTestCase.assertTrue((boolean)(model instanceof DOMModelForJSP));
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)model.getStructuredDocument(), offset);
        return new ContextWrapper(context, model);
    }

    protected IStructuredSelection getSelection(Node node) {
        return new StructuredSelection((Object)node);
    }

    protected ITabbedPropertySheetPageContributor getTabbedPropertyCont() {
        return new ITabbedPropertySheetPageContributor(){

            public String getContributorId() {
                return "org.eclipse.jst.pagedesigner.tabPropertyContributor";
            }
        };
    }

    protected WPETabbedPropertySheetPage getWPETabbedPropertySheetPage(HTMLEditor ed) {
        return (WPETabbedPropertySheetPage)ed.getAdapter(IPropertySheetPage.class);
    }

    protected HTMLEditor openHTMLEditor(IFile file) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        BaseTestCase.assertNotNull((Object)workbenchWindow);
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        try {
            FileEditorInput input = new FileEditorInput(file);
            IEditorPart editor = workbenchPage.openEditor((IEditorInput)input, HTML_EDITOR_ID);
            BaseTestCase.assertTrue((String)"An error condition has occurred probably due to an out of an memory exception.", (boolean)(editor instanceof HTMLEditor));
            return (HTMLEditor)editor;
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IEditorPart openXSDEditor(IFile file) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        BaseTestCase.assertNotNull((Object)workbenchWindow);
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        try {
            FileEditorInput input = new FileEditorInput(file);
            return workbenchPage.openEditor((IEditorInput)input, "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor");
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IViewPart showPropertiesView() {
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = null;
        try {
            view = workbenchPage.showView("org.eclipse.ui.views.PropertySheet");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return view;
    }

    protected Node getNode(IFile file, int offset) throws Exception {
        ContextWrapper wrapper = null;
        Node node = null;
        try {
            wrapper = this.getDocumentContext(file, offset);
            BaseTestCase.assertNotNull((Object)wrapper);
            IStructuredDocumentContext context = wrapper.getContext();
            IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
            node = resolver.getNode();
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
        return node;
    }

    protected void closeEditor(IEditorPart ed) {
        IWorkbenchPage page = ed.getEditorSite().getPage();
        page.closeEditor(ed, false);
    }

    public static class ContextWrapper {
        private final IStructuredDocumentContext context;
        private final IStructuredModel model;

        public ContextWrapper(IStructuredDocumentContext context, IStructuredModel model) {
            this.context = context;
            this.model = model;
        }

        public IStructuredDocumentContext getContext() {
            return this.context;
        }

        public IStructuredModel getModel() {
            return this.model;
        }

        void dispose() {
            this.model.releaseFromRead();
        }
    }
}

