/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tests.tagcreator;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.palette.IDropSourceData;
import org.eclipse.jst.pagedesigner.itemcreation.CreationData;
import org.eclipse.jst.pagedesigner.itemcreation.ITagCreator;
import org.eclipse.jst.pagedesigner.itemcreation.internal.TagCreationFactory;
import org.eclipse.jst.pagedesigner.tests.PageDesignerTestsPlugin;
import org.eclipse.jst.pagedesigner.tests.tagcreator.base.BaseTestClass;
import org.eclipse.jst.pagedesigner.tests.tagcreator.base.MockCreateItemCommand;
import org.eclipse.jst.pagedesigner.tests.tagcreator.base.MockItemCreationTool;
import org.eclipse.jst.pagedesigner.tests.tagcreatorPlugin.TestCreationFactory;
import org.eclipse.jst.pagedesigner.utils.CommandUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class TestTagCreationFactory
extends BaseTestClass {
    public TestTagCreationFactory() {
        super("jsf");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/tagcreator/testCreator.tld.data", "/META-INF/testCreator.tld");
        this._manager.reset();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testEnsureRequiredAttributes() throws Exception {
        IFile jspFile = (IFile)this._webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/tagcreator/testTagCreation.jsp.data", "/testEnsureRequiredAttributes.jsp");
        CreationData creationData = this.getCreationData("org.eclipse.jst.pagedesigner.tests.tagCreatorFactory1", "tagWithRequiredAttr", "test", jspFile, 501, null);
        Element element = CommandUtil.executeInsertion((IDropSourceData)creationData.getTagCreationProvider(), (IDOMModel)creationData.getModel(), (IDOMPosition)creationData.getDomPosition(), (IAdaptable)creationData.getDropCustomizationData());
        TestTagCreationFactory.assertNotNull((Object)element);
        TagIdentifier tagId = TagIdentifierFactory.createDocumentTagWrapper((Element)element);
        TestTagCreationFactory.assertEquals((String)"test:tagWithRequiredAttr", (String)element.getNodeName());
        TestTagCreationFactory.assertNull((Object)element.getAttribute("requiredAttr1"));
        TestTagCreationFactory.assertEquals((String)TestCreationFactory.getDefaultAttributeValue(tagId, "requiredAttr2"), (String)element.getAttribute("requiredAttr2"));
        jspFile = (IFile)this._webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/tagcreator/testTagCreation.jsp.data", "/testEnsureRequiredAttributes2.jsp");
        creationData = this.getCreationData("org.eclipse.jst.pagedesigner.tests.tagCreatorFactory1", "tagWithRequiredAttr2", "test", jspFile, 501, null);
        element = CommandUtil.executeInsertion((IDropSourceData)creationData.getTagCreationProvider(), (IDOMModel)creationData.getModel(), (IDOMPosition)creationData.getDomPosition(), (IAdaptable)creationData.getDropCustomizationData());
        TestTagCreationFactory.assertEquals((String)"foobar", (String)element.getAttribute("requiredAttr1"));
        TestTagCreationFactory.assertEquals((String)"", (String)element.getAttribute("requiredAttr2"));
        TestTagCreationFactory.assertNull((Object)element.getAttribute("notRequiredAttr1"));
    }

    public void testTagCreationMetadata() throws Exception {
        IFile jspFile = (IFile)this._webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/tagcreator/testTagCreation.jsp.data", "/testTagCreationMetadata.jsp");
        CreationData creationData = this.getCreationData("org.eclipse.jst.pagedesigner.tests.tagCreatorFactory1", "tagWithMetadata", "test", jspFile, 501, null);
        Element element = CommandUtil.executeInsertion((IDropSourceData)creationData.getTagCreationProvider(), (IDOMModel)creationData.getModel(), (IDOMPosition)creationData.getDomPosition(), (IAdaptable)creationData.getDropCustomizationData());
        TestTagCreationFactory.assertNotNull((Object)element);
        TestTagCreationFactory.assertEquals((String)"foobar", (String)element.getAttribute("requiredAttr1"));
        TestTagCreationFactory.assertNull((Object)element.getAttribute("requiredAttr2"));
        TestTagCreationFactory.assertEquals((String)"someOtherFooBar", (String)element.getAttribute("notRequiredAttr1"));
        TestTagCreationFactory.assertNull((Object)element.getAttribute("notRequiredAttr2"));
        TestTagCreationFactory.assertEquals((int)1, (int)element.getChildNodes().getLength());
        TestTagCreationFactory.assertEquals((String)"p:outputText", (String)element.getChildNodes().item(0).getNodeName());
    }

    public void testBug197042() throws Exception {
        IFile jspFile = (IFile)this._webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/tagcreator/tagCreator.jspx.data", "/testTagCreationMetadata.jsp");
        String uri = IJSFConstants.TAG_IDENTIFIER_COMMANDBUTTON.getUri();
        String tagName = IJSFConstants.TAG_IDENTIFIER_COMMANDBUTTON.getTagName();
        CreationData creationData = this.getCreationData(uri, tagName, "h", jspFile, 495, null);
        ITagCreator tagCreator = TagCreationFactory.getInstance().createTagCreator(creationData.getTagId());
        Element element = tagCreator.createTag(creationData);
        System.out.println(element.toString());
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        this.getDocumentContext(0, jspFile).getModel().save((OutputStream)resultStream);
        IPath expectedPath = JSFTestUtil.getAbsolutePath((Bundle)PageDesignerTestsPlugin.getDefault().getBundle(), (String)"/testdata/tagcreator/jsf/expectedResult_commandButton.jspx.data");
        String expected = this.getExpectedResult(expectedPath).trim();
        String result = resultStream.toString().trim();
        TestTagCreationFactory.assertEquals((String)expected, (String)result);
    }

    public void testDropCustomizerThatCancels() throws Exception {
        IFile jspFile = (IFile)this._webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/tagcreator/tagCreator.jsp.data", "/testCustomizerCancel.jsp");
        TestCreationFactory.setTestParametersForDropCustomer(Status.CANCEL_STATUS, null);
        MockItemCreationTool tool = this.createMockItemCreationTool(jspFile, 358, TestCreationFactory.TAG_WITH_REQUIRED_ATTR, 8);
        tool.customizeDropAndMaybeExecute(0);
        this.assertExpectedResult(jspFile, "jsp");
    }

    public void testDropCustomizationDataAcquistion() throws Exception {
        IFile jspFile = (IFile)this._webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/tagcreator/tagCreator.jsp.data", "/testCustomizerCancel.jsp");
        IAdaptable adaptable = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (Map.class == adapter) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("color", "red");
                    return map;
                }
                return null;
            }
        };
        TestCreationFactory.setTestParametersForDropCustomer(Status.OK_STATUS, adaptable);
        MockItemCreationTool tool = this.createMockItemCreationTool(jspFile, 358, TestCreationFactory.TAG_WITH_REQUIRED_ATTR, 8);
        tool.customizeDropAndMaybeExecute(0);
        Object[] commands = tool.getDomain().getCommandStack().getCommands();
        TestTagCreationFactory.assertEquals((int)1, (int)commands.length);
        TestTagCreationFactory.assertTrue((boolean)(commands[0] instanceof MockCreateItemCommand));
        IAdaptable value = ((MockCreateItemCommand)((Object)commands[0])).getCustomizationDataTesting();
        TestTagCreationFactory.assertEquals((Object)adaptable, (Object)value);
        Map map = (Map)value.getAdapter(Map.class);
        TestTagCreationFactory.assertNotNull((Object)map);
        TestTagCreationFactory.assertEquals((Object)"red", map.get("color"));
    }

    private void assertExpectedResult(IFile file, String outExt) throws Exception {
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        this.getDocumentContext(0, file).getModel().save((OutputStream)resultStream);
        String expected = this.getExpectedResult("/testdata/tagcreator/tagCreator." + outExt + ".data").trim();
        String result = resultStream.toString("ISO-8859-1").trim();
        TestTagCreationFactory.assertEquals((String)expected, (String)result);
    }
}

