/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.dom;

import junit.framework.TestCase;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AttrImplTests
extends TestCase {
    private static final String contents = "<elementName attrPrefix:local='lorem' />";

    public AttrImplTests() {
    }

    public AttrImplTests(String name) {
        super(name);
    }

    public void testAttrImplPrefix() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element documentElement = model.getDocument().getDocumentElement();
        AttrImplTests.assertNotNull((String)"no document element found", (Object)documentElement);
        NamedNodeMap attributes = documentElement.getAttributes();
        AttrImplTests.assertTrue((String)"no attributes found", (attributes.getLength() > 0 ? 1 : 0) != 0);
        Attr attribute = (Attr)attributes.item(0);
        AttrImplTests.assertEquals((String)"attribute prefix was not as expected", (String)"attrPrefix", (String)attribute.getPrefix());
    }

    public void testAttrImplLocalName() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element documentElement = model.getDocument().getDocumentElement();
        AttrImplTests.assertNotNull((String)"no document element found", (Object)documentElement);
        NamedNodeMap attributes = documentElement.getAttributes();
        AttrImplTests.assertTrue((String)"no attributes found", (attributes.getLength() > 0 ? 1 : 0) != 0);
        Attr attribute = (Attr)attributes.item(0);
        AttrImplTests.assertEquals((String)"attribute local name was not as expected", (String)"local", (String)attribute.getLocalName());
    }

    public void testNamespaceURIOnCreation() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Attr attr = model.getDocument().createAttribute("simple");
        AttrImplTests.assertNull((String)"namespace was found", (Object)attr.getNamespaceURI());
        Attr attr2 = model.getDocument().createAttributeNS("http://lorem.ipsum", "complex");
        AttrImplTests.assertEquals((String)"attribute namespace URI was not as expected", (String)"http://lorem.ipsum", (String)attr2.getNamespaceURI());
        Attr attr3 = model.getDocument().createAttributeNS(null, "complex");
        AttrImplTests.assertEquals((String)"attribute namespace URI was not as expected", null, (String)attr3.getNamespaceURI());
    }

    public void testNullAttributeValue() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        Attr attribute = model.getDocument().createAttribute("attr");
        try {
            attribute.setNodeValue(null);
        }
        catch (NullPointerException nullPointerException) {
            AttrImplTests.fail((String)"Setting a null node value caused a NullPointerException.");
        }
    }
}

