/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.translation;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapter;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapterFactory;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.core.internal.validation.JSPJavaValidator;
import org.eclipse.jst.jsp.core.tests.JSPCoreTestsPlugin;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;
import org.eclipse.jst.jsp.core.tests.validation.ReporterForTest;
import org.eclipse.jst.jsp.core.tests.validation.ValidationContextForTest;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.osgi.framework.Bundle;

public class JSPJavaTranslatorCoreTest
extends TestCase {
    static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
    private static byte[] creationLock = new byte[0];
    String wtp_autotest_noninteractive = null;
    static /* synthetic */ Class class$0;

    public JSPJavaTranslatorCoreTest() {
    }

    public JSPJavaTranslatorCoreTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, this.wtp_autotest_noninteractive);
        }
    }

    public void test_107338() throws Exception {
        JSPTranslationAdapter translationAdapter;
        JSPTranslationExtension translation;
        String projectName = "bug_107338";
        IProject project = BundleResourceUtil.createSimpleProject(projectName, null, null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + projectName, "/" + projectName);
        IFile file = project.getFile("WebContent/test107338.jsp");
        JSPJavaTranslatorCoreTest.assertTrue((boolean)file.exists());
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(file);
        IDOMModel jspModel = (IDOMModel)model;
        String jspSource = model.getStructuredDocument().get();
        JSPJavaTranslatorCoreTest.assertTrue((String)"line delimiters have been converted to Windows [CRLF]", (jspSource.indexOf("\r\n") < 0 ? 1 : 0) != 0);
        JSPJavaTranslatorCoreTest.assertTrue((String)"line delimiters have been converted to Mac [CR]", (jspSource.indexOf("\r") < 0 ? 1 : 0) != 0);
        FactoryRegistry factoryRegistry = model.getFactoryRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.java.IJSPTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (factoryRegistry.getFactoryFor((Object)clazz) == null) {
            JSPTranslationAdapterFactory factory = new JSPTranslationAdapterFactory();
            model.getFactoryRegistry().addFactory((INodeAdapterFactory)factory);
        }
        IDOMDocument xmlDoc = jspModel.getDocument();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.java.IJSPTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JSPJavaTranslatorCoreTest.assertTrue((String)"new-line beginning scriptlet missing from translation", ((translation = (translationAdapter = (JSPTranslationAdapter)xmlDoc.getAdapterFor((Object)clazz2)).getJSPTranslation()).getJavaText().indexOf("int i = 0;") >= 0 ? 1 : 0) != 0);
        model.releaseFromRead();
    }

    public void test_126377() throws Exception {
        String projectName = "bug_126377";
        IProject project = BundleResourceUtil.createSimpleProject(projectName, null, null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + projectName, "/" + projectName);
        IFile file = project.getFile("WebContent/test126377_noerror.jsp");
        JSPJavaTranslatorCoreTest.assertTrue((boolean)file.exists());
        JSPJavaValidator validator = new JSPJavaValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        helper.setURI(file.getFullPath().toOSString());
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPJavaTranslatorCoreTest.assertTrue((String)"found jsp java error within html comments when there are none", (boolean)reporter.getMessages().isEmpty());
        file = project.getFile("WebContent/test126377_error.jsp");
        JSPJavaTranslatorCoreTest.assertTrue((boolean)file.exists());
        helper.setURI(file.getFullPath().toOSString());
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        int errors = reporter.getMessages().size();
        JSPJavaTranslatorCoreTest.assertTrue((String)("found " + errors + " jsp java errors within html comments when there should be 3"), (errors == 3 ? 1 : 0) != 0);
    }

    public void test_174042() throws Exception {
        boolean doValidateSegments = JSPCorePlugin.getDefault().getPluginPreferences().getBoolean("validateFragments");
        String testName = "bug_174042";
        IProject project = BundleResourceUtil.createSimpleProject(testName, null, null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", true);
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + testName, "/" + testName);
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/struts.jar", "/" + testName + "/struts.jar");
        this.waitForBuildAndValidation(project);
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", doValidateSegments);
        IFile main = project.getFile("main.jsp");
        IMarker[] markers = main.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < markers.length) {
            s.append("\nproblem marker on line " + markers[i].getAttribute("lineNumber") + ": \"" + markers[i].getAttribute("message") + "\" ");
            ++i;
        }
        JSPJavaTranslatorCoreTest.assertEquals((String)("problem markers found, " + s.toString()), (int)0, (int)markers.length);
    }

    /*
     * Exception decompiling
     */
    private void waitForBuildAndValidation() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [6 : 202->206)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void waitForBuildAndValidation(IProject project) throws CoreException {
        project.build(15, (IProgressMonitor)new NullProgressMonitor());
        this.waitForBuildAndValidation();
        project.build(6, (IProgressMonitor)new NullProgressMonitor());
        this.waitForBuildAndValidation();
    }

    public void test_178443() throws Exception {
        boolean doValidateSegments = JSPCorePlugin.getDefault().getPluginPreferences().getBoolean("validateFragments");
        String testName = "bug_178443";
        IProject project = BundleResourceUtil.createSimpleProject(testName, Platform.getStateLocation((Bundle)JSPCoreTestsPlugin.getDefault().getBundle()).append(testName), null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", false);
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + testName, "/" + testName);
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/struts.jar", "/" + testName + "/struts.jar");
        this.waitForBuildAndValidation(project);
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", doValidateSegments);
        IFile main = project.getFile("main.jsp");
        IMarker[] markers = main.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < markers.length) {
            s.append("\nproblem on line " + markers[i].getAttribute("lineNumber") + ": " + markers[i].getAttribute("message"));
            ++i;
        }
        JSPJavaTranslatorCoreTest.assertEquals((String)("problem markers found" + s.toString()), (int)0, (int)markers.length);
    }

    public void test_109721() throws Exception {
        boolean doValidateSegments = JSPCorePlugin.getDefault().getPluginPreferences().getBoolean("validateFragments");
        String testName = "bug_109721";
        IProject project = BundleResourceUtil.createSimpleProject(testName, Platform.getStateLocation((Bundle)JSPCoreTestsPlugin.getDefault().getBundle()).append(testName), null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", false);
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + testName, "/" + testName);
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/struts.jar", "/" + testName + "/WebContent/WEB-INF/lib/struts.jar");
        this.waitForBuildAndValidation(project);
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", doValidateSegments);
        IFile main = project.getFile("WebContent/main.jsp");
        ValidationResult result = new JSPJavaValidator().validate((IResource)main, 1, new ValidationState(), (IProgressMonitor)new NullProgressMonitor());
        List messages = result.getReporter(null).getMessages();
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < messages.size()) {
            s.append("\nproblem on line " + ((IMessage)messages.get(i)).getAttribute("lineNumber") + ": " + ((IMessage)messages.get(i)).getText());
            ++i;
        }
        JSPJavaTranslatorCoreTest.assertEquals((String)("problem markers found" + s.toString()), (int)0, (int)messages.size());
    }

    public void test_181057a() throws Exception {
        boolean doValidateSegments = JSPCorePlugin.getDefault().getPluginPreferences().getBoolean("validateFragments");
        String testName = "bug_181057";
        IProject j = BundleResourceUtil.createSimpleProject("j", null, null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)j.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/j", "/j");
        IProject k = BundleResourceUtil.createSimpleProject("k", null, null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)k.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/k", "/k");
        IProject project = BundleResourceUtil.createSimpleProject(testName, Platform.getStateLocation((Bundle)JSPCoreTestsPlugin.getDefault().getBundle()).append(testName), null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", true);
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + testName, "/" + testName);
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/struts.jar", "/" + testName + "/struts.jar");
        this.waitForBuildAndValidation(project);
        JSPCorePlugin.getDefault().getPluginPreferences().setValue("validateFragments", doValidateSegments);
        IFile main = project.getFile("main.jsp");
        IMarker[] markers = main.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < markers.length) {
            s.append("\n" + markers[i].getAttribute("lineNumber") + ":" + markers[i].getAttribute("message"));
            ++i;
        }
        JSPJavaTranslatorCoreTest.assertEquals((String)("problem markers found" + s.toString()), (int)0, (int)markers.length);
    }

    public void test_219761a() throws Exception {
        String testName = "testTranslatorMessagesWithIncludes";
        IProject project = BundleResourceUtil.createSimpleProject(testName, null, null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + testName, "/" + testName);
        this.waitForBuildAndValidation(project);
        ValidationFramework.getDefault().validate(new IProject[]{project}, true, true, (IProgressMonitor)new NullProgressMonitor());
        IFile main = project.getFile("/WebContent/sample.jsp");
        JSPJavaTranslatorCoreTest.assertTrue((String)"sample test file does not exist", (boolean)main.isAccessible());
        IMarker[] markers = main.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        StringBuffer markerText = new StringBuffer();
        int i = 0;
        while (i < markers.length) {
            markerText.append("\nL" + markers[i].getAttribute("lineNumber") + "/o" + markers[i].getAttribute("charStart") + "-" + markers[i].getAttribute("charEnd") + ":" + markers[i].getAttribute("message"));
            ++i;
        }
        int numberOfSyntaxErrors = 0;
        int i2 = 0;
        while (i2 < markers.length) {
            Object message = markers[i2].getAttribute("message");
            JSPJavaTranslatorCoreTest.assertNotNull((String)"Marker message was null!", (Object)message);
            if (message.toString().startsWith("Syntax error")) {
                ++numberOfSyntaxErrors;
                JSPJavaTranslatorCoreTest.assertTrue((String)("Syntax error reported before line 25" + markerText), ((Integer)markers[i2].getAttribute("lineNumber") >= 25 ? 1 : 0) != 0);
            }
            ++i2;
        }
        project.delete(true, true, null);
    }

    public void test_150794() throws Exception {
        String testName = "bug_150794";
        IProject project = BundleResourceUtil.createSimpleProject(testName, null, null);
        JSPJavaTranslatorCoreTest.assertTrue((boolean)project.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/" + testName, "/" + testName);
        IFile main = project.getFile("/WebContent/escapedQuotes.jsp");
        JSPJavaTranslatorCoreTest.assertTrue((String)"sample test file does not exist", (boolean)main.isAccessible());
        JSPJavaValidator validator = new JSPJavaValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        helper.setURI(main.getFullPath().toOSString());
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPJavaTranslatorCoreTest.assertTrue((String)"Unexpected problems found", (reporter.getMessages().size() == 0 ? 1 : 0) != 0);
        project.delete(true, true, null);
    }

    /*
     * Exception decompiling
     */
    public void test_preludes() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 309->313)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void test_codas() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 309->313)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void test_prelude_and_coda() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 363->367)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testVariablesFromIncludedFragments() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 309->313)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testIterationTags() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 407->411)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testIterationTagsIncomplete() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 245->249)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

