/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.instantiation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.internal.instantiation.InitStringAllocation;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.tests.JavaProjectUtil;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;

public class TestStandard
extends TestCase {
    protected BeaninfoNature nature;
    protected ResourceSet rset;
    protected JavaHelpers boolType;

    public TestStandard() {
    }

    public TestStandard(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IProject biProject = JavaProjectUtil.getProject("Test BeanInfo");
        TestStandard.assertNotNull((Object)biProject);
        this.nature = BeaninfoNature.getRuntime((IProject)biProject);
        TestStandard.assertNotNull((Object)this.nature);
        this.rset = this.nature.getResourceSet();
        TestStandard.assertNotNull((Object)this.rset);
        this.boolType = JavaRefFactory.eINSTANCE.reflectType("boolean", this.rset);
        TestStandard.assertNotNull((Object)this.boolType);
    }

    protected JavaClass getTest1Class() {
        return (JavaClass)JavaRefFactory.eINSTANCE.reflectType("org.eclipse.jem.tests.beaninfo.Test1Class", this.rset);
    }

    public void testInit() {
        JavaClass test1Class = this.getTest1Class();
        IJavaObjectInstance ji1 = (IJavaObjectInstance)test1Class.getEPackage().getEFactoryInstance().create((EClass)test1Class);
        ji1.setAllocation((JavaAllocation)InstantiationFactory.eINSTANCE.createInitStringAllocation("new Test1Class()"));
        this.assertInit(ji1);
    }

    private void assertInit(IJavaObjectInstance ji1) {
        TestStandard.assertTrue((boolean)ji1.isSetAllocation());
        InitStringAllocation alloc = (InitStringAllocation)ji1.getAllocation();
        TestStandard.assertEquals((String)"new Test1Class()", (String)alloc.getInitString());
    }

    public void testPropertyAccess() {
        JavaClass test1Class = this.getTest1Class();
        IJavaObjectInstance ji1 = (IJavaObjectInstance)test1Class.getEPackage().getEFactoryInstance().create((EClass)test1Class);
        ji1.setAllocation((JavaAllocation)InstantiationFactory.eINSTANCE.createInitStringAllocation("new Test1Class()"));
        EStructuralFeature setSF = test1Class.getEStructuralFeature("set");
        TestStandard.assertNotNull((Object)setSF);
        TestStandard.assertSame((Object)this.boolType, (Object)setSF.getEType());
        IJavaDataTypeInstance setting = (IJavaDataTypeInstance)setSF.getEType().getEPackage().getEFactoryInstance().create((EClass)setSF.getEType());
        setting.setAllocation((JavaAllocation)InstantiationFactory.eINSTANCE.createInitStringAllocation("true"));
        ji1.eSet(setSF, (Object)setting);
        this.assertProperty(ji1);
    }

    private void assertProperty(IJavaObjectInstance ji1) {
        EStructuralFeature setSF = ji1.eClass().getEStructuralFeature("set");
        Object v = ji1.eGet(setSF);
        TestStandard.assertNotNull((Object)v);
        TestStandard.assertTrue((boolean)(v instanceof IJavaDataTypeInstance));
        IJavaDataTypeInstance dtv = (IJavaDataTypeInstance)v;
        TestStandard.assertSame((Object)this.boolType, (Object)dtv.getJavaType());
        TestStandard.assertTrue((boolean)dtv.isSetAllocation());
        InitStringAllocation alloc = (InitStringAllocation)dtv.getAllocation();
        TestStandard.assertEquals((String)"true", (String)alloc.getInitString());
    }

    protected IJavaObjectInstance setupInstance() {
        JavaClass test1Class = this.getTest1Class();
        IJavaObjectInstance ji1 = (IJavaObjectInstance)test1Class.getEPackage().getEFactoryInstance().create((EClass)test1Class);
        ji1.setAllocation((JavaAllocation)InstantiationFactory.eINSTANCE.createInitStringAllocation("new Test1Class()"));
        EStructuralFeature setSF = test1Class.getEStructuralFeature("set");
        IJavaDataTypeInstance setting = (IJavaDataTypeInstance)setSF.getEType().getEPackage().getEFactoryInstance().create((EClass)setSF.getEType());
        setting.setAllocation((JavaAllocation)InstantiationFactory.eINSTANCE.createInitStringAllocation("true"));
        ji1.eSet(setSF, (Object)setting);
        return ji1;
    }

    protected String setupResource() throws IOException {
        IJavaObjectInstance ji1 = this.setupInstance();
        ProjectResourceSet rswork1 = this.nature.newResourceSet();
        Resource r = rswork1.createResource(URI.createURI((String)"f.xmi"));
        r.getContents().add((Object)ji1);
        r.getContents().add(ji1.eGet(ji1.eClass().getEStructuralFeature("set")));
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        r.save((OutputStream)bo, Collections.EMPTY_MAP);
        return bo.toString();
    }
}

