package oracle.adfdemo.view.faces;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

import java.util.Iterator;
import java.util.Map;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;

import oracle.adf.view.faces.event.DisclosureEvent;
import oracle.adf.view.faces.component.core.layout.CorePanelPage;

import oracle.adf.view.faces.model.UploadedFile;

public class UIBean
{
  public UIBean()
  {
  }

  public CorePanelPage getPanelPage()
  {
    return _panelPage;
  }

  public UIBeanState getState()
  {
    return _state;
  }

  public void setState(UIBeanState state)
  {
    _state = state;
  }

  public void setPanelPage(CorePanelPage panelPage)
  {
    _panelPage = panelPage;
    if (!getState().isTitleSet())
    {
      panelPage.setTitle("Binding works...");
      getState().setTitleSet(true);
    }
  }

  public void fileUploaded(ValueChangeEvent event)
  {
    UploadedFile file = (UploadedFile) event.getNewValue();
    if (file != null)
    {
      FacesContext context = FacesContext.getCurrentInstance();
      FacesMessage message = new FacesMessage(
         "Uploaded file " + file.getFilename() +
         " (" + file.getLength() + " bytes)");
      context.addMessage(event.getComponent().getClientId(context), message);
    }
  }

  public void anActionListener(ActionEvent event)
  {
    _panelPage.setTitle("Action listener works too!");
  }

  public void aDisclosureListener(DisclosureEvent event)
  {
    _panelPage.setTitle("Disclosure listener works too!");
  }

  public void testFailover()
  {
    FacesContext context = FacesContext.getCurrentInstance();
    Map session = context.getExternalContext().getSessionMap();
    Map.Entry writing = null;
    try
    {
      ObjectOutputStream oos =
        new ObjectOutputStream(new ByteArrayOutputStream(2 << 16));
      Iterator entries = session.entrySet().iterator();
      while (entries.hasNext())
      {
        writing = (Map.Entry) entries.next();
        oos.writeObject(writing.getValue());
        context.addMessage(null,
                           new FacesMessage("Successfully serialized " + writing.getValue() + " [at " + writing.getKey() + "]"));
      }
    }
    catch (IOException ioe)
    {
      context.addMessage(null,
           new FacesMessage(FacesMessage.SEVERITY_ERROR,
                            "Failed while outputting object " + writing.getValue()  +
                            " [at " + writing.getKey() + "]",
                            ioe.getMessage()));
    }
  }

  //
  // For testing purposes, here's a series of methods that can
  // be EL-addressed that blow up.  These exceptions should
  // be displayed somewhere (preferably in a logged error
  // message), not swallowed.
  //

  public String actionThatFails()
  {
    throw new IllegalStateException("Calling this action is a bad move");
  }

  public void listenerThatFails(ValueChangeEvent event)
  {
    throw new IllegalStateException("Using this listener is a bad move");
  }

  public String getFailedProperty()
  {
    throw new IllegalStateException("Getting this property is a bad move");
  }


  private CorePanelPage _panelPage;
  private UIBeanState _state;
}
