/*
** Copyright (c) Oracle Corporation 2003. All Rights Reserved.
**
**345678901234567890123456789012345678901234567890123456789012345678901234567890
*/
package oracle.adfdemo.view.faces;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * A basic implementation of TreeNode that exposes the extra magic
 * keys that will be requested by the tree renderer.
 * <p>
 * @version $Name:  $ ($Revision: 1.2 $) $Date: 2004/07/30 00:40:31 $
 * @author Adam Winer
 */
public class TreeNodeImpl implements Serializable
{
  public String getText()
  {
    return _text;
  }

  public void setText(String text)
  {
    _text = text;
  }


  public String getIcon()
  {
    return _icon;
  }

  public void setIcon(String icon)
  {
    _icon = icon;
  }

  public String getDestination()
  {
    return _destination;
  }


  public void setDestination(String destination)
  {
    _destination = destination;
  }

  public void setChildren(List nodes)
  {
    // Clone on the way in.
    _nodes = new ArrayList(nodes);
  }

  public List getChildren()
  {
    if (_nodes == null)
      return null;

    return Collections.unmodifiableList(_nodes);
  }


  private String _text = null;
  private String _destination = null;
  private String _icon = null;
  private List   _nodes;
}
