package oracle.adfdemo.view.faces.survey;

import java.util.List;

/***
 *  class MultChoiceQuestionBean
 *
 * This bean represents a single multiple choice questions.  It has fields for
 * the question prompt, a list of choices, and the correct answer.
 *
 ***/


public class MultChoiceQuestionBean implements java.io.Serializable
{
  
  /** Constructors **/
  
  /**
   *  Class constructor (no arguments).
   */
  public MultChoiceQuestionBean()
  {
  }
  
  /**
   *  Class constructor.
   */
  public MultChoiceQuestionBean(String prompt,
                                List choices,
                                int correctIndex)
  {
    _prompt = prompt;
    _choices = choices;
    _correctIndex = correctIndex;
  }


  /*** Accessors ***/
  /**
   *  returns the question prompt.
   *
   *  @return the question prompt
   */
  public String getPrompt()
  {
    return _prompt;
  }


  /**
    *  returns the list of answer strings.
    */
  public List getAnswerStrings()
  {
    return _choices;
  }


  /**
   * typical toString method
   *
   * @return a String representation of a MultChoiceQuestionBean
   */
  public String toString()
  {
    String str = "[" + _prompt + "; " + _choices.toString() + "]";
    return str;
  }



  /**
   * returns a message describing the correct answer choices.
   *
   * @return a message describing the correct answer choices
   */
  public String getCorrectAnswerMessage()
  {
    return "The correct answer is: " + (String)_choices.get(_correctIndex);
  }

  /**
   * returns the index of the correct answer
   *
   * @return the index of the correct answer
   */
  public int getCorrectIndex()
  {
    return _correctIndex;
  }

  /* The question as a String object */
  private String   _prompt;
  
  /* arbitrary number of possible answer choices (Strings) */
  private List  _choices;

  /* The index of the correct answer */
  private int     _correctIndex;


} //end QuestionBean
