/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.binary;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.binary.BinaryNamedConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.BaseTypeConverterAnnotation;

abstract class BinaryBaseTypeConverterAnnotation
extends BinaryNamedConverterAnnotation
implements BaseTypeConverterAnnotation {
    String dataType = this.buildDataType();
    String objectType = this.buildObjectType();

    BinaryBaseTypeConverterAnnotation(JavaResourcePersistentMember parent, IAnnotation jdtAnnotation) {
        super(parent, jdtAnnotation);
    }

    public void update() {
        super.update();
        this.setDataType_(this.buildDataType());
        this.setObjectType_(this.buildObjectType());
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        throw new UnsupportedOperationException();
    }

    private void setDataType_(String dataType) {
        String old = this.dataType;
        this.dataType = dataType;
        this.firePropertyChanged("dataType", old, dataType);
    }

    private String buildDataType() {
        return (String)this.getJdtMemberValue(this.getDataTypeElementName());
    }

    public TextRange getDataTypeTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    abstract String getDataTypeElementName();

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        throw new UnsupportedOperationException();
    }

    private void setObjectType_(String objectType) {
        String old = this.objectType;
        this.objectType = objectType;
        this.firePropertyChanged("objectType", old, objectType);
    }

    private String buildObjectType() {
        return (String)this.getJdtMemberValue(this.getObjectTypeElementName());
    }

    public TextRange getObjectTypeTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    abstract String getObjectTypeElementName();
}

