/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.dom.DOMAdapter;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.region.Region2AttrAdapter;
import org.eclipse.jst.jsf.core.internal.region.Region2ElementAdapter;
import org.eclipse.jst.jsf.designtime.DTAppManagerUtil;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.resolver.IStructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.designtime.resolver.StructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.JSFValidationContext;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.strategy.AttributeValidatingStrategy;
import org.eclipse.jst.jsf.validation.internal.strategy.ContainmentValidatingStrategy;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class XMLViewDefnValidator
implements IJSFViewValidator {
    static final boolean DEBUG;
    private IStructuredDocumentSymbolResolverFactory _symbolResolverFactory = StructuredDocumentSymbolResolverFactory.getInstance();

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsf.core/validation");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    private void validateTag(IStructuredDocumentRegion container, JSFValidationContext jsfValidationContext, ContainmentValidatingStrategy containmentStrategy) {
        try {
            Region2ElementAdapter regionAdapter = new Region2ElementAdapter((ITextRegion)container);
            if (containmentStrategy.isInteresting((DOMAdapter)regionAdapter)) {
                containmentStrategy.validate((DOMAdapter)regionAdapter);
            }
            AttributeValidatingStrategy strategy = new AttributeValidatingStrategy(jsfValidationContext);
            for (Region2AttrAdapter attrAdapter : regionAdapter.getAttributes().values()) {
                if (!strategy.isInteresting((DOMAdapter)attrAdapter)) continue;
                strategy.validate((DOMAdapter)attrAdapter);
            }
        }
        catch (Region2ElementAdapter.NoElementException noElementException) {}
    }

    public void validateView(IFile viewFile, IJSFViewValidator.IValidationReporter reporter) {
        IStructuredModel model = null;
        if (DEBUG) {
            System.out.println("executing JSPSemanticsValidator.validateFile");
        }
        try {
            JSFValidationContext jsfValidationContext = this.createValidationContext(false, viewFile, reporter);
            if (jsfValidationContext == null) {
                return;
            }
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(viewFile);
                IStructuredDocument structuredDoc = model.getStructuredDocument();
                IStructuredDocumentRegion[] regions = structuredDoc.getStructuredDocumentRegions();
                this.validateRegions(regions, jsfValidationContext, new ContainmentValidatingStrategy(jsfValidationContext));
            }
            catch (CoreException e) {
                JSFCorePlugin.log("Error validating JSF", e);
            }
            catch (IOException e) {
                JSFCorePlugin.log("Error validating JSF", e);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public void validateView(IFile viewFile, IStructuredDocumentRegion[] regions, IJSFViewValidator.IValidationReporter reporter) {
        JSFValidationContext jsfValidationContext = this.createValidationContext(true, viewFile, reporter);
        if (jsfValidationContext == null) {
            return;
        }
        this.validateRegions(regions, jsfValidationContext, new ContainmentValidatingStrategy(jsfValidationContext));
    }

    private void validateRegions(IStructuredDocumentRegion[] regions, JSFValidationContext context, ContainmentValidatingStrategy containmentValidator) {
        IStructuredDocumentRegion[] iStructuredDocumentRegionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            IStructuredDocumentRegion curNode = iStructuredDocumentRegionArray[n2];
            if (curNode.getFirstRegion().getType() == "XML_TAG_OPEN") {
                this.validateTag(curNode, context, containmentValidator);
            }
            ++n2;
        }
    }

    private JSFValidationContext createValidationContext(boolean isIncremental, IFile file, IJSFViewValidator.IValidationReporter reporter) {
        ValidationPreferences prefs = new ValidationPreferences(JSFCorePlugin.getDefault().getPreferenceStore());
        prefs.load();
        DiagnosticFactory diagnosticFactory = new DiagnosticFactory();
        IDTViewHandler viewHandler = DTAppManagerUtil.getViewHandler(file.getProject());
        if (viewHandler == null || !viewHandler.supportsViewDefinition(file)) {
            return null;
        }
        return new JSFValidationContext(isIncremental, prefs, viewHandler, diagnosticFactory, file, reporter, this._symbolResolverFactory);
    }
}

