/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCollectionValueModelAdapter<E>
extends AbstractModel
implements CollectionValueModel<E> {
    protected final ListValueModel<? extends E> listHolder;
    protected final ListChangeListener listChangeListener;
    protected final ArrayList<E> collection;

    public ListCollectionValueModelAdapter(ListValueModel<? extends E> listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.listChangeListener = this.buildListChangeListener();
        this.collection = new ArrayList();
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, CollectionChangeListener.class, "values");
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent event) {
                ListCollectionValueModelAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(ListChangeEvent event) {
                ListCollectionValueModelAdapter.this.itemsRemoved(event);
            }

            public void itemsReplaced(ListChangeEvent event) {
                ListCollectionValueModelAdapter.this.itemsReplaced(event);
            }

            public void itemsMoved(ListChangeEvent event) {
                ListCollectionValueModelAdapter.this.itemsMoved(event);
            }

            public void listCleared(ListChangeEvent event) {
                ListCollectionValueModelAdapter.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                ListCollectionValueModelAdapter.this.listChanged(event);
            }

            public String toString() {
                return "list change listener";
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyIterator<E>(this.collection);
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public void addCollectionChangeListener(CollectionChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(listener);
    }

    @Override
    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        if (collectionName == "values" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addCollectionChangeListener(collectionName, listener);
    }

    @Override
    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        super.removeCollectionChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    @Override
    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        super.removeCollectionChangeListener(collectionName, listener);
        if (collectionName == "values" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("values");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected int lastIdentityIndexOf(Object o) {
        return this.lastIdentityIndexOf(o, this.collection.size());
    }

    protected int lastIdentityIndexOf(Object o, int end) {
        int i = end;
        while (i-- > 0) {
            if (this.collection.get(i) != o) continue;
            return i;
        }
        return -1;
    }

    protected void buildCollection() {
        Iterator<E> stream = this.listHolder.iterator();
        if (stream.hasNext()) {
            this.collection.ensureCapacity(this.listHolder.size());
            while (stream.hasNext()) {
                this.collection.add(stream.next());
            }
        }
    }

    protected void engageModel() {
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
        this.buildCollection();
    }

    protected void disengageModel() {
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
        this.collection.clear();
    }

    protected ListIterator<E> items(ListChangeEvent event) {
        return event.items();
    }

    protected ListIterator<E> replacedItems(ListChangeEvent event) {
        return event.replacedItems();
    }

    protected void itemsAdded(ListChangeEvent event) {
        this.addItemsToCollection(this.items(event), this.collection, "values");
    }

    protected void removeInternalItems(Iterator<E> items) {
        while (items.hasNext()) {
            E removedItem = items.next();
            int index = this.lastIdentityIndexOf(removedItem);
            this.collection.remove(index);
            this.fireItemRemoved("values", removedItem);
        }
    }

    protected void itemsRemoved(ListChangeEvent event) {
        this.removeInternalItems(this.items(event));
    }

    protected void itemsReplaced(ListChangeEvent event) {
        this.removeInternalItems(this.replacedItems(event));
        this.addItemsToCollection(this.items(event), this.collection, "values");
    }

    protected void itemsMoved(ListChangeEvent event) {
    }

    protected void listCleared(ListChangeEvent event) {
        if (!this.collection.isEmpty()) {
            this.collection.clear();
            this.fireCollectionCleared("values");
        }
    }

    protected void listChanged(ListChangeEvent event) {
        if (!this.collection.isEmpty()) {
            ArrayList removedItems = (ArrayList)this.collection.clone();
            this.collection.clear();
            this.fireItemsRemoved("values", removedItems);
        }
        this.buildCollection();
        if (!this.collection.isEmpty()) {
            this.fireItemsAdded("values", this.collection);
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.listHolder);
    }
}

