/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.tests.jspeditor;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jst.jsf.contentassist.tests.ContentAssistTestsPlugin;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsf.ui.internal.jspeditor.ELHyperlinkDetector;
import org.eclipse.jst.jsf.ui.internal.jspeditor.ITestHyperlink;
import org.eclipse.jst.jsf.ui.internal.jspeditor.JSPSourceUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class TestELHyperlinkDetector
extends TestCase {
    private WebProjectTestEnvironment _testEnv;
    private IFile _jspFile;
    private IType _myBeanType;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._testEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName());
        this._testEnv.createProject(false);
        TestELHyperlinkDetector.assertNotNull((Object)this._testEnv);
        TestELHyperlinkDetector.assertNotNull((Object)this._testEnv.getTestProject());
        TestELHyperlinkDetector.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.1");
        this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/faces-config_basic.xml.data", "/WEB-INF/faces-config.xml");
        this._jspFile = (IFile)this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/basicELExpressions.jsp.data", "/basicELExpressions.jsp");
        TestELHyperlinkDetector.assertNotNull((Object)this._jspFile);
        TestELHyperlinkDetector.assertTrue((boolean)this._jspFile.isAccessible());
        JDTTestEnvironment jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._testEnv);
        TestFileResource resource = new TestFileResource();
        resource.load(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/MyBean.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyBean", resource.toString());
        this._myBeanType = JavaCore.create((IProject)this._testEnv.getTestProject()).findType("beans.MyBean");
        TestELHyperlinkDetector.assertNotNull((Object)this._myBeanType);
        TestELHyperlinkDetector.assertTrue((boolean)this._myBeanType.exists());
    }

    public void testSanity() throws Exception {
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)579, (String)"value", (String)"#{myBean}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)614, (String)"value", (String)"#{myBean.property}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)706, (String)"action", (String)"#{myBean.actionMethod}");
        JSFCoreUtilHelper.assertELVariableSanity((IFile)this._jspFile, (String)"myBean");
    }

    public void testDetectHyperlinks() throws Exception {
        this.testJavaHyperlink(579, 0, "MyBean.java", 7, "MyBean");
        this.testJavaHyperlink(614, 0, "MyBean.java", 7, "MyBean");
        this.testJavaHyperlink(706, 0, "MyBean.java", 7, "MyBean");
        this.testJavaHyperlink(614, 8, "MyBean.java", 9, "getProperty");
        this.testJavaHyperlink(706, 8, "MyBean.java", 9, "actionMethod");
    }

    private void testJavaHyperlink(int regionStartOffset, int relativeOffset, String classFileName, int javaElementType, String javaElementName) throws Exception {
        IWorkbenchPage curPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TestableELHyperlinkDetector hyperlinkDetector = new TestableELHyperlinkDetector();
        JSFCoreUtilHelper.ContextWrapper context = JSFCoreUtilHelper.getDocumentContext((IFile)this._jspFile, (int)regionStartOffset);
        Region elRegion = JSPSourceUtil.findELRegion((IStructuredDocumentContext)context.getContext());
        elRegion = new Region(elRegion.getOffset() + relativeOffset, elRegion.getLength() - relativeOffset);
        IHyperlink[] links = hyperlinkDetector.detectHyperlinks(context.getContext(), (IRegion)elRegion);
        TestELHyperlinkDetector.assertEquals((int)1, (int)links.length);
        IHyperlink link = links[0];
        TestELHyperlinkDetector.assertTrue((boolean)(link instanceof ITestHyperlink));
        TestELHyperlinkDetector.assertNotNull((Object)link.getHyperlinkRegion());
        TestELHyperlinkDetector.assertNull((Object)link.getTypeLabel());
        TestELHyperlinkDetector.assertNull((Object)link.getHyperlinkText());
        ITestHyperlink testHyperlink = (ITestHyperlink)link;
        IJavaElement javaElement = testHyperlink.determineJavaElement();
        TestELHyperlinkDetector.assertNotNull((Object)javaElement);
        TestELHyperlinkDetector.assertEquals((int)javaElementType, (int)javaElement.getElementType());
        TestELHyperlinkDetector.assertEquals((String)javaElementName, (String)javaElement.getElementName());
        link.open();
        IEditorPart editorPart = curPage.getActiveEditor();
        TestELHyperlinkDetector.assertNotNull((Object)editorPart);
        IEditorInput editorInput = editorPart.getEditorInput();
        TestELHyperlinkDetector.assertTrue((boolean)(editorInput instanceof FileEditorInput));
        IFile file = ((FileEditorInput)editorInput).getFile();
        TestELHyperlinkDetector.assertEquals((String)classFileName, (String)file.getName());
        curPage.closeEditor(editorPart, false);
    }

    private static class TestableELHyperlinkDetector
    extends ELHyperlinkDetector {
        private TestableELHyperlinkDetector() {
        }

        public IHyperlink[] detectHyperlinks(IStructuredDocumentContext context, IRegion region) {
            return super.detectHyperlinks(context, region);
        }
    }
}

