/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SecurityIdentityType;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.internal.EJBAnnotationReader;
import org.eclipse.jst.jee.model.internal.common.AbstractAnnotationModelProvider;
import org.eclipse.jst.jee.model.tests.AbstractAnnotationModelTest;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.TestUtils;

public class SecurityRolesTest
extends AbstractAnnotationModelTest {
    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite(SecurityRolesTest.class);
        SecurityRolesTest.setUpProject();
        return suite;
    }

    public static void setUpProject() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(SecurityRolesTest.class.getSimpleName());
        if (!project.exists()) {
            project = ProjectUtil.createEJBProject(SecurityRolesTest.class.getSimpleName(), null, 30, true);
            SecurityRolesTest.createProjectContent(project);
        }
    }

    public static void tearDownAfterClass() throws InterruptedException {
        AbstractTest.deleteProject(SecurityRolesTest.class.getSimpleName());
    }

    private static void createProjectContent(IProject project) throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder comFolder = javaProject.getProject().getFolder("ejbModule/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void setUp() throws Exception {
        SecurityRolesTest.setUpProject();
        super.setUp();
        this.fixture = new EJBAnnotationReader(this.facetedProject, this.clientProject);
    }

    protected void tearDown() throws Exception {
        ((AbstractAnnotationModelProvider)this.fixture).dispose();
    }

    public void testDeclareRoles() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testDeclareRoles.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@DeclareRoles(value = {\"role1\", \"role2\"}) @Stateless public class testDeclareRoles implements SessionBeanLocal {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testDeclareRoles");
        SecurityRole role1 = TestUtils.findSecurityRole(this.getEJBJar().getAssemblyDescriptor().getSecurityRoles(), "role1");
        SecurityRole role2 = TestUtils.findSecurityRole(this.getEJBJar().getAssemblyDescriptor().getSecurityRoles(), "role2");
        SecurityRolesTest.assertNotNull((Object)role1);
        SecurityRolesTest.assertNotNull((Object)role2);
        SecurityRoleRef role1Ref = TestUtils.findSecurityRoleRef(result.getSecurityRoleRefs(), "role1");
        SecurityRolesTest.assertNotNull((Object)role1Ref);
        SecurityRoleRef role2Ref = TestUtils.findSecurityRoleRef(result.getSecurityRoleRefs(), "role2");
        SecurityRolesTest.assertNotNull((Object)role2Ref);
        this.deleteFileAndUpdate(beanFile);
        SecurityRolesTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testDeclareRoles"));
        SecurityRolesTest.assertNull((Object)TestUtils.findSecurityRole(this.getEJBJar().getAssemblyDescriptor().getSecurityRoles(), "role1"));
        SecurityRolesTest.assertNull((Object)TestUtils.findSecurityRole(this.getEJBJar().getAssemblyDescriptor().getSecurityRoles(), "role2"));
    }

    public void testDeclareRoleOnManyBeans() throws Exception {
        IFile bean1File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testDeclareRoleOnManyBeans1.java");
        IFile bean2File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testDeclareRoleOnManyBeans2.java");
        this.saveFileAndUpdate(bean1File, "package com.sap;@DeclareRoles(value = {\"role1\"}) @Stateless public class testDeclareRoleOnManyBeans1 implements SessionBeanLocal {}");
        this.saveFileAndUpdate(bean2File, "package com.sap;@DeclareRoles(value = {\"role1\"}) @Stateless public class testDeclareRoleOnManyBeans2 implements SessionBeanLocal {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testDeclareRoleOnManyBeans1");
        SecurityRole role1 = TestUtils.findSecurityRole(this.getEJBJar().getAssemblyDescriptor().getSecurityRoles(), "role1");
        SecurityRolesTest.assertNotNull((Object)role1);
        SecurityRoleRef role1Ref = TestUtils.findSecurityRoleRef(result.getSecurityRoleRefs(), "role1");
        SecurityRolesTest.assertNotNull((Object)role1Ref);
        this.deleteFileAndUpdate(bean1File);
        SecurityRolesTest.assertNotNull((Object)TestUtils.findSecurityRole(this.getEJBJar().getAssemblyDescriptor().getSecurityRoles(), "role1"));
        this.deleteFileAndUpdate(bean2File);
        SecurityRolesTest.assertNull((Object)TestUtils.findSecurityRole(this.getEJBJar().getAssemblyDescriptor().getSecurityRoles(), "role1"));
    }

    public void testRunAs() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testRunAs.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@DeclareRoles(value = {\"role1\"}) @RunAs(value = \"role1\") @Stateless public class testRunAs implements SessionBeanLocal {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testRunAs");
        SecurityRole role1 = TestUtils.findSecurityRole(this.getEJBJar().getAssemblyDescriptor().getSecurityRoles(), "role1");
        SecurityRolesTest.assertNotNull((Object)role1);
        SecurityRoleRef role1Ref = TestUtils.findSecurityRoleRef(result.getSecurityRoleRefs(), "role1");
        SecurityRolesTest.assertNotNull((Object)role1Ref);
        SecurityIdentityType identity = result.getSecurityIdentities();
        SecurityRolesTest.assertNotNull((Object)identity);
        RunAs runAs = identity.getRunAs();
        SecurityRolesTest.assertNotNull((Object)runAs);
        SecurityRolesTest.assertEquals((String)"role1", (String)runAs.getRoleName());
        this.deleteFileAndUpdate(beanFile);
        SecurityRolesTest.assertNull((Object)TestUtils.findSecurityRole(this.getEJBJar().getAssemblyDescriptor().getSecurityRoles(), "role1"));
    }

    public void testRunAsMessageBean() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testRunAsMessageBean.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@RunAs(value = \"role1\") @MessageDriven public class testRunAsMessageBean implements SessionBeanLocal {}");
        MessageDrivenBean result = TestUtils.getMessageDrivenBean(this.getEJBJar(), "testRunAsMessageBean");
        SecurityIdentityType identity = result.getSecurityIdentity();
        SecurityRolesTest.assertNotNull((Object)identity);
        RunAs runAs = identity.getRunAs();
        SecurityRolesTest.assertNotNull((Object)runAs);
        SecurityRolesTest.assertEquals((String)"role1", (String)runAs.getRoleName());
        this.deleteFileAndUpdate(beanFile);
        SecurityRolesTest.assertNull((Object)TestUtils.getMessageDrivenBean(this.getEJBJar(), "testRunAsMessageBean"));
    }
}

