/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tests;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.dtmanager.DTManager;
import org.eclipse.jst.pagedesigner.dtmanager.IDTInfo;
import org.eclipse.jst.pagedesigner.dtmanager.dtinfo.TagConvertInfo;
import org.eclipse.jst.pagedesigner.dtmanager.dtinfo.TagDecorateInfo;
import org.eclipse.jst.pagedesigner.tests.PageDesignerTestsPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Test_DTManager
extends TestCase {
    private WebProjectTestEnvironment webProjectTestEnv;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this.webProjectTestEnv = new WebProjectTestEnvironment("Test_DTManager_" + this.getName());
        this.webProjectTestEnv.createProject(false);
        Test_DTManager.assertNotNull((Object)this.webProjectTestEnv);
        Test_DTManager.assertNotNull((Object)this.webProjectTestEnv.getTestProject());
        Test_DTManager.assertTrue((boolean)this.webProjectTestEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacetedTestEnv = new JSFFacetedTestEnvironment(this.webProjectTestEnv);
        jsfFacetedTestEnv.initialize("1.1");
        this.webProjectTestEnv.loadResourceInWebRoot(PageDesignerTestsPlugin.getDefault().getBundle(), "/testdata/Test_DTManager.jsp.data", "/Test_DTManager.jsp");
        Test_DTManager.assertTrue((boolean)JSFCoreUtilHelper.addJSFRuntimeJarsToClasspath((JSFVersion)JSFVersion.V1_1, (JSFFacetedTestEnvironment)jsfFacetedTestEnv));
    }

    public void testSanity() {
        ContextWrapper wrapper = null;
        try {
            try {
                wrapper = this.getDocumentContext("/WebContent/Test_DTManager.jsp", 477);
                IStructuredDocumentContext context = wrapper.getContext();
                IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
                Node node = resolver.getNode();
                Test_DTManager.assertTrue((boolean)(node instanceof Element));
                Test_DTManager.assertTrue((boolean)node.getPrefix().equals("h"));
                Test_DTManager.assertTrue((boolean)node.getLocalName().equals("outputText"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Test_DTManager.fail((String)ex.getLocalizedMessage());
                if (wrapper != null) {
                    wrapper.dispose();
                }
            }
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    public void testGetTagConverter() {
        ContextWrapper wrapper = null;
        try {
            try {
                wrapper = this.getDocumentContext("/WebContent/Test_DTManager.jsp", 477);
                IStructuredDocumentContext context = wrapper.getContext();
                IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
                Node node = resolver.getNode();
                Test_DTManager.assertTrue((boolean)(node instanceof Element));
                Test_DTManager.assertTrue((boolean)node.getPrefix().equals("h"));
                Test_DTManager.assertTrue((boolean)node.getLocalName().equals("outputText"));
                Element element = (Element)node;
                IStructuredModel model = wrapper.getModel();
                Test_DTManager.assertTrue((boolean)(model instanceof IDOMModel));
                IDOMDocument document = ((IDOMModel)model).getDocument();
                Test_DTManager.assertNotNull((Object)document);
                ITagConverter tagConverter = DTManager.getInstance().getTagConverter(element, 0, document);
                Test_DTManager.assertNotNull((Object)tagConverter);
                tagConverter.convertRefresh(null);
                Element resultElement = tagConverter.getResultElement();
                Test_DTManager.assertNotNull((Object)resultElement);
                Test_DTManager.assertTrue((boolean)resultElement.getLocalName().equals("span"));
                Test_DTManager.assertNull((Object)resultElement.getAttributeNode("value"));
                NodeList childNodes = resultElement.getChildNodes();
                Test_DTManager.assertTrue((childNodes.getLength() == 1 ? 1 : 0) != 0);
                Node childNode = childNodes.item(0);
                Test_DTManager.assertTrue((boolean)(childNode instanceof Text));
                Test_DTManager.assertTrue((boolean)((Text)childNode).getData().equals("valueValue"));
                Test_DTManager.assertNull((Object)resultElement.getAttributeNode("styleClass"));
                Test_DTManager.assertNotNull((Object)resultElement.getAttributeNode("class"));
                Test_DTManager.assertTrue((boolean)resultElement.getAttribute("class").equals("classValue"));
                Test_DTManager.assertNotNull((Object)resultElement.getAttributeNode("attr1"));
                Test_DTManager.assertTrue((boolean)resultElement.getAttribute("attr1").equals("attr1Value"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Test_DTManager.fail((String)ex.getLocalizedMessage());
                if (wrapper != null) {
                    wrapper.dispose();
                }
            }
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    public void testGetDTInfo() {
        ContextWrapper wrapper = null;
        try {
            try {
                wrapper = this.getDocumentContext("/WebContent/Test_DTManager.jsp", 477);
                IStructuredDocumentContext context = wrapper.getContext();
                IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
                Node node = resolver.getNode();
                Test_DTManager.assertTrue((boolean)(node instanceof Element));
                Test_DTManager.assertTrue((boolean)node.getPrefix().equals("h"));
                Test_DTManager.assertTrue((boolean)node.getLocalName().equals("outputText"));
                Element element = (Element)node;
                IDTInfo dtInfo = DTManager.getInstance().getDTInfo(element);
                Test_DTManager.assertNotNull((Object)dtInfo);
                TagConvertInfo tcInfo = dtInfo.getTagConvertInfo();
                EList operations = tcInfo.getOperations();
                Test_DTManager.assertNotNull((Object)operations);
                Test_DTManager.assertEquals((int)4, (int)operations.size());
                List tdInfos = dtInfo.getTagDecorateInfos();
                Test_DTManager.assertEquals((int)2, (int)tdInfos.size());
                TagDecorateInfo tdInfoDesign = dtInfo.getTagDecorateInfo("vpd-decorate-design");
                Test_DTManager.assertNotNull((Object)tdInfoDesign);
                Test_DTManager.assertTrue((boolean)tdInfoDesign.isNeedBorderDecorator());
                Test_DTManager.assertTrue((boolean)tdInfoDesign.isMultiLevel());
                Test_DTManager.assertTrue((boolean)tdInfoDesign.isWidget());
                Test_DTManager.assertTrue((boolean)tdInfoDesign.isSetNonVisualChildElements());
                TagDecorateInfo tdInfoPreview = dtInfo.getTagDecorateInfo("vpd-decorate-preview");
                Test_DTManager.assertNotNull((Object)tdInfoPreview);
                Test_DTManager.assertTrue((boolean)tdInfoPreview.isResolveChildText());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Test_DTManager.fail((String)ex.getLocalizedMessage());
                if (wrapper != null) {
                    wrapper.dispose();
                }
            }
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    private ContextWrapper getDocumentContext(String path, int offset) throws Exception {
        IProject project = this.webProjectTestEnv.getTestProject();
        IFile jspFile = project.getFile((IPath)new Path(path));
        Test_DTManager.assertTrue((boolean)jspFile.exists());
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        model = modelManager.getModelForRead(jspFile);
        Test_DTManager.assertTrue((boolean)(model instanceof DOMModelForJSP));
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)model.getStructuredDocument(), offset);
        return new ContextWrapper(context, model);
    }

    private static class ContextWrapper {
        private final IStructuredDocumentContext context;
        private final IStructuredModel model;

        ContextWrapper(IStructuredDocumentContext context, IStructuredModel model) {
            this.context = context;
            this.model = model;
        }

        IStructuredDocumentContext getContext() {
            return this.context;
        }

        IStructuredModel getModel() {
            return this.model;
        }

        void dispose() {
            this.model.releaseFromRead();
        }
    }
}

