/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.internal.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.validation.test.BVTValidationException;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.internal.registry.BVTValidationRegistryReader;
import org.eclipse.jst.validation.test.internal.registry.ITestcaseMetaData;
import org.eclipse.jst.validation.test.internal.registry.OperationTestcase;
import org.eclipse.jst.validation.test.internal.registry.TestcaseUtility;
import org.eclipse.jst.validation.test.internal.registry.ValidatorTestcase;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;

public final class BVTValidationUtility {
    private BVTValidationUtility() {
    }

    public static ValidatorMetaData getValidatorMetaData(IMarker marker) {
        String validatorClassName = null;
        try {
            validatorClassName = marker.getAttribute("owner").toString();
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorClassName);
            return vmd;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static IMarker[] getValidationTasks(IResource resource) {
        try {
            IMarker[] allMarkers = resource.findMarkers("org.eclipse.wst.validation.problemmarker", false, 2);
            return allMarkers;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static void removeAllValidationMarkers() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IMarker[] markers = BVTValidationUtility.getValidationTasks((IResource)root);
        if (markers != null) {
            try {
                workspace.deleteMarkers(markers);
            }
            catch (CoreException coreException) {}
        }
    }

    public static String getProjectName(File file) {
        String fileName = file.getName();
        int extIndex = fileName.indexOf(46);
        if (extIndex > 0) {
            return fileName.substring(0, extIndex);
        }
        return fileName;
    }

    public static String getQualifiedLogName(String logFileName) {
        String dir = BVTValidationPlugin.getPlugin().getStateLocation().toOSString();
        File dirWithFile = new File(dir, logFileName);
        return dirWithFile.toString();
    }

    public static IProject[] getProjects(ITestcaseMetaData[] tmds) {
        ArrayList<IProject> sortedList = new ArrayList<IProject>();
        int i = 0;
        while (i < tmds.length) {
            IProject p = TestcaseUtility.findProject(tmds[i]);
            if (p != null && p.exists() && p.isOpen() && !sortedList.contains(p)) {
                sortedList.add(p);
            }
            ++i;
        }
        Collections.sort(sortedList, new Comparator(){

            public int compare(Object a, Object b) {
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
                if (a instanceof IProject && b instanceof IProject) {
                    return ((IProject)a).getName().compareTo(((IProject)b).getName());
                }
                return -1;
            }
        });
        IProject[] result = new IProject[sortedList.size()];
        sortedList.toArray(result);
        return result;
    }

    public static ITestcaseMetaData[] getTests(ITestcaseMetaData[] tmds, IProject p) {
        ITestcaseMetaData[] temp = new ITestcaseMetaData[tmds.length];
        int count = 0;
        int i = 0;
        while (i < tmds.length) {
            ITestcaseMetaData tmd = tmds[i];
            if (tmd.getProjectName().equals(p.getName())) {
                temp[count++] = tmd;
            }
            ++i;
        }
        ITestcaseMetaData[] result = new ITestcaseMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public static int numValidatorTests(IProgressMonitor monitor, IProject[] projects) throws BVTValidationException {
        BVTValidationRegistryReader reader = BVTValidationRegistryReader.getReader();
        int totalTests = 0;
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            ValidatorTestcase[] tests = reader.getValidatorTests(monitor, project);
            if (tests != null && tests.length != 0) {
                totalTests += tests.length;
            }
            ++i;
        }
        return totalTests;
    }

    public static ValidatorTestcase[] getValidatorTests(IProgressMonitor monitor, IProject[] projects) {
        HashSet<ValidatorTestcase> testSet = new HashSet<ValidatorTestcase>();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            ValidatorTestcase[] tests = BVTValidationUtility.getValidatorTests(monitor, project);
            if (tests.length != 0) {
                int j = 0;
                while (j < tests.length) {
                    ValidatorTestcase vt = tests[j];
                    testSet.add(vt);
                    ++j;
                }
            }
            ++i;
        }
        ValidatorTestcase[] result = new ValidatorTestcase[testSet.size()];
        testSet.toArray(result);
        return result;
    }

    public static ValidatorTestcase[] getValidatorTests(IProgressMonitor monitor, IProject project) {
        BVTValidationRegistryReader reader = BVTValidationRegistryReader.getReader();
        ValidatorTestcase[] tests = reader.getValidatorTests(monitor, project);
        if (tests == null) {
            return new ValidatorTestcase[0];
        }
        return tests;
    }

    public static OperationTestcase[] getOperationTests(IProgressMonitor monitor) {
        return BVTValidationRegistryReader.getReader().getOperationTests(monitor, (String)null);
    }

    public static OperationTestcase[] getOperationTests(IProgressMonitor monitor, IProject project) {
        BVTValidationRegistryReader reader = BVTValidationRegistryReader.getReader();
        OperationTestcase[] tests = reader.getOperationTests(monitor, project);
        if (tests == null) {
            return new OperationTestcase[0];
        }
        return tests;
    }

    public static ValidatorTestcase[] getValidatorTests(IProgressMonitor monitor) {
        return BVTValidationRegistryReader.getReader().getValidatorTests(monitor, (String)null);
    }

    public static ValidatorTestcase[] getValidatorTests(IProgressMonitor monitor, ValidatorMetaData vmd) {
        ValidatorTestcase[] allTests = BVTValidationRegistryReader.getReader().getValidatorTests(monitor, (String)null);
        ValidatorTestcase[] temp = new ValidatorTestcase[allTests.length];
        int count = 0;
        int i = 0;
        while (i < allTests.length) {
            ValidatorTestcase testvmd = allTests[i];
            if (vmd.equals(testvmd.getValidatorMetaData())) {
                temp[count++] = testvmd;
            }
            ++i;
        }
        ValidatorTestcase[] result = new ValidatorTestcase[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public static ValidatorMetaData[] getValidatorsThatHaveTests(IProgressMonitor monitor) {
        ValidatorTestcase[] tests = BVTValidationUtility.getValidatorTests(monitor);
        HashSet<ValidatorMetaData> temp = new HashSet<ValidatorMetaData>();
        int i = 0;
        while (i < tests.length) {
            ValidatorTestcase vt = tests[i];
            temp.add(vt.getValidatorMetaData());
            ++i;
        }
        ValidatorMetaData[] vmds = new ValidatorMetaData[temp.size()];
        temp.toArray(vmds);
        return vmds;
    }
}

