/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.performance;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.parser.XMLSourceParser;

public class TestParserPerformance
extends PerformanceTestCase {
    public TestParserPerformance(String name) {
        super(name);
    }

    public void testBigStyle() throws IOException {
        this.doJSPParser("bigStyle.jsp");
        this.doJSPParser("testfiles/company300k.jsp");
        this.doXMLParser("bigStyle.jsp");
        this.doXMLParser("testfiles/company300k.html");
        this.doXMLParser("testfiles/company300k.xml");
        String[] yourCompanyFiles = new String[]{"testfiles/YourCoIndex.html", "testfiles/YourCoIntro.html", "testfiles/YourCoMenu.html", "testfiles/YourCoTitle.html"};
        this.doXMLParser(yourCompanyFiles);
    }

    private void doXMLParser(String filename) throws IOException {
        String[] filenames = new String[]{filename};
        this.doXMLParser(filenames);
    }

    private void doJSPParser(String filename) throws IOException {
        String[] filenames = new String[]{filename};
        this.doJSPParser(filenames);
    }

    private void doXMLParser(String[] filenames) throws IOException {
        Runtime rt = Runtime.getRuntime();
        XMLSourceParser[] parsers = new XMLSourceParser[filenames.length];
        String[] texts = new String[filenames.length];
        IModelManager modelManager = StructuredModelManager.getModelManager();
        int k = 0;
        while (k < filenames.length) {
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filenames[k]);
            IStructuredModel sModel = modelManager.getModelForEdit(filenames[k], inStream, null);
            IStructuredDocument structuredDocument = sModel.getStructuredDocument();
            texts[k] = structuredDocument.getText();
            parsers[k] = (XMLSourceParser)structuredDocument.getParser();
            sModel.releaseFromEdit();
            ++k;
        }
        int numTrials = 101;
        long totalTime = 0L;
        long totalMemory = 0L;
        this.startMeasuring();
        int i = 0;
        while (i < numTrials) {
            rt.gc();
            long startMem = rt.totalMemory() - rt.freeMemory();
            long startTime = System.currentTimeMillis();
            int j = 0;
            while (j < filenames.length) {
                parsers[j].reset(texts[j]);
                parsers[j].getDocumentRegions();
                ++j;
            }
            long endTime = System.currentTimeMillis();
            long endMem = rt.totalMemory() - rt.freeMemory();
            long diffTime = endTime - startTime;
            long diffMem = endMem - startMem;
            if (i > 0) {
                totalTime += diffTime;
                totalMemory += diffMem;
            }
            ++i;
        }
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
        System.out.println("");
        System.out.println("---------------------------");
        System.out.println("XMLParser performance for > ");
        int l = 0;
        while (l < filenames.length) {
            System.out.print(String.valueOf(filenames[l]) + " ");
            ++l;
        }
        System.out.println("number of trials >\t\t" + (numTrials - 1));
        System.out.println("getNodes() ave time >\t" + totalTime / (long)(numTrials - 1));
        System.out.println("ave memory >\t\t\t" + totalMemory / (long)(numTrials - 1));
    }

    protected void doJSPParser(String[] filenames) throws IOException {
        Runtime rt = Runtime.getRuntime();
        JSPSourceParser[] parsers = new JSPSourceParser[filenames.length];
        String[] texts = new String[filenames.length];
        IModelManager modelManager = StructuredModelManager.getModelManager();
        int k = 0;
        while (k < filenames.length) {
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filenames[k]);
            IStructuredModel sModel = modelManager.getModelForEdit(filenames[k], inStream, null);
            IStructuredDocument structuredDocument = sModel.getStructuredDocument();
            texts[k] = structuredDocument.getText();
            parsers[k] = (JSPSourceParser)structuredDocument.getParser();
            sModel.releaseFromEdit();
            ++k;
        }
        int numTrials = 101;
        long totalTime = 0L;
        long totalMemory = 0L;
        this.startMeasuring();
        int i = 0;
        while (i < numTrials) {
            rt.gc();
            long startMem = rt.totalMemory() - rt.freeMemory();
            long startTime = System.currentTimeMillis();
            int j = 0;
            while (j < filenames.length) {
                parsers[j].reset(texts[j]);
                parsers[j].getDocumentRegions();
                ++j;
            }
            long endTime = System.currentTimeMillis();
            long endMem = rt.totalMemory() - rt.freeMemory();
            long diffTime = endTime - startTime;
            long diffMem = endMem - startMem;
            if (i > 0) {
                totalTime += diffTime;
                totalMemory += diffMem;
            }
            ++i;
        }
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
        System.out.println("");
        System.out.println("---------------------------");
        System.out.println("JSPParser performance for > ");
        int l = 0;
        while (l < filenames.length) {
            System.out.print(String.valueOf(filenames[l]) + " ");
            ++l;
        }
        System.out.println("number of trials >\t\t" + (numTrials - 1));
        System.out.println("getNodes() ave time >\t" + totalTime / (long)(numTrials - 1));
        System.out.println("ave memory >\t\t\t" + totalMemory / (long)(numTrials - 1));
    }
}

