/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.tests.j2ee;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.server.core.tests.TestsPlugin;
import org.eclipse.jst.server.core.tests.j2ee.ProjectUnzipUtil;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.osgi.framework.Bundle;

public class ModuleHelper {
    protected static IPath getLocalPath(IPath path) {
        try {
            URL url = FileLocator.find((Bundle)TestsPlugin.instance.getBundle(), (IPath)path, null);
            url = FileLocator.toFileURL((URL)url);
            return new Path(url.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean importProject(String zipName, String[] projectNames) {
        IPath zipPath = ModuleHelper.getLocalPath(new Path("data").append(zipName));
        ProjectUnzipUtil util = new ProjectUnzipUtil(zipPath, projectNames);
        return util.createProjects();
    }

    public static void deleteProject(String projectName) throws Exception {
        class DeleteJob
        extends Job {
            private final /* synthetic */ String val$projectName;

            public DeleteJob(String string) {
                this.val$projectName = string;
                super("Deleting project");
                IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
                this.setRule(ruleFactory.createRule((IResource)ResourcesPlugin.getWorkspace().getRoot()));
            }

            protected IStatus run(IProgressMonitor monitor) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.val$projectName);
                try {
                    project.delete(true, null);
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
                return Status.OK_STATUS;
            }
        }
        DeleteJob job = new DeleteJob(projectName);
        job.schedule();
        job.join();
    }

    public static void buildIncremental() throws CoreException {
        ResourcesPlugin.getWorkspace().build(10, null);
        boolean interrupted = true;
        while (interrupted) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void buildFull() throws CoreException {
        ResourcesPlugin.getWorkspace().build(6, null);
        boolean interrupted = true;
        while (interrupted) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void buildClean() throws CoreException {
        ResourcesPlugin.getWorkspace().build(15, null);
        boolean interrupted = true;
        while (interrupted) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static IModule getModuleFromProject(String name) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        IModule module = ServerUtil.getModule((IProject)project);
        if (module == null) {
            throw new Exception("No module in project");
        }
        return module;
    }

    public static IModule getModule(String type, String name) throws Exception {
        IModule[] modules;
        IModule[] iModuleArray = modules = ServerUtil.getModules((String)type);
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            if (module.getName().equals(name)) {
                return module;
            }
            ++n2;
        }
        return null;
    }

    public static int countFiles(IModule module) throws CoreException {
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
        IModuleResource[] mr = pm.members();
        int count = 0;
        IModuleResource[] iModuleResourceArray = mr;
        int n = mr.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResource m = iModuleResourceArray[n2];
            count = m instanceof IModuleFolder ? (count += ModuleHelper.countFiles((IModuleFolder)m)) : ++count;
            ++n2;
        }
        return count;
    }

    protected static int countFiles(IModuleFolder mf) {
        int count = 0;
        IModuleResource[] mr = mf.members();
        if (mr == null) {
            return 0;
        }
        IModuleResource[] iModuleResourceArray = mr;
        int n = mr.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResource m = iModuleResourceArray[n2];
            count = m instanceof IModuleFolder ? (count += ModuleHelper.countFiles((IModuleFolder)m)) : ++count;
            ++n2;
        }
        return count;
    }

    public static int countFolders(IModule module) throws CoreException {
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
        IModuleResource[] mr = pm.members();
        int count = 0;
        IModuleResource[] iModuleResourceArray = mr;
        int n = mr.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResource m = iModuleResourceArray[n2];
            if (m instanceof IModuleFolder) {
                ++count;
                count += ModuleHelper.countFolders((IModuleFolder)m);
            }
            ++n2;
        }
        return count;
    }

    protected static int countFolders(IModuleFolder mf) {
        int count = 0;
        IModuleResource[] mr = mf.members();
        if (mr == null) {
            return 0;
        }
        IModuleResource[] iModuleResourceArray = mr;
        int n = mr.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResource m = iModuleResourceArray[n2];
            if (m instanceof IModuleFolder) {
                ++count;
                count += ModuleHelper.countFolders((IModuleFolder)m);
            }
            ++n2;
        }
        return count;
    }

    public static int countFilesInDelta(IModuleResourceDelta delta) throws CoreException {
        IModuleResourceDelta[] children;
        int count = 0;
        if (delta.getModuleResource() instanceof IModuleFile) {
            ++count;
        }
        IModuleResourceDelta[] iModuleResourceDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResourceDelta child = iModuleResourceDeltaArray[n2];
            count += ModuleHelper.countFilesInDelta(child);
            ++n2;
        }
        return count;
    }

    public static IModuleFile getModuleFile(IModule module, IPath path) throws CoreException {
        IModuleResource[] mr;
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
        IModuleResource[] iModuleResourceArray = mr = pm.members();
        int n = mr.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleFile mf2;
            IModuleResource m = iModuleResourceArray[n2];
            if (m.getModuleRelativePath().append(m.getName()).equals((Object)path)) {
                if (m instanceof IModuleFile) {
                    return (IModuleFile)m;
                }
                return null;
            }
            if (m.getModuleRelativePath().isPrefixOf(path) && m instanceof IModuleFolder && (mf2 = ModuleHelper.getModuleFile((IModuleFolder)m, path)) != null) {
                return mf2;
            }
            ++n2;
        }
        return null;
    }

    protected static IModuleFile getModuleFile(IModuleFolder mf, IPath path) {
        IModuleResource[] mr = mf.members();
        if (mr == null) {
            return null;
        }
        IModuleResource[] iModuleResourceArray = mr;
        int n = mr.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleFile mf2;
            IModuleResource m = iModuleResourceArray[n2];
            if (m.getModuleRelativePath().append(m.getName()).equals((Object)path)) {
                if (m instanceof IModuleFile) {
                    return (IModuleFile)m;
                }
                return null;
            }
            if (m.getModuleRelativePath().isPrefixOf(path) && m instanceof IModuleFolder && (mf2 = ModuleHelper.getModuleFile((IModuleFolder)m, path)) != null) {
                return mf2;
            }
            ++n2;
        }
        return null;
    }

    public static boolean fileExists(IModule module, IPath path) throws CoreException {
        return ModuleHelper.getModuleFile(module, path) != null;
    }

    public static boolean fileExists(IModule module, String path) throws CoreException {
        return ModuleHelper.fileExists(module, (IPath)new Path(path));
    }

    public static IModuleFolder getModuleFolder(IModule module, IPath path) throws CoreException {
        IModuleResource[] mr;
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
        IModuleResource[] iModuleResourceArray = mr = pm.members();
        int n = mr.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleFolder mf2;
            IModuleResource m = iModuleResourceArray[n2];
            if (m.getModuleRelativePath().append(m.getName()).equals((Object)path)) {
                if (m instanceof IModuleFolder) {
                    return (IModuleFolder)m;
                }
                return null;
            }
            if (m.getModuleRelativePath().isPrefixOf(path) && m instanceof IModuleFolder && (mf2 = ModuleHelper.getModuleFolder((IModuleFolder)m, path)) != null) {
                return mf2;
            }
            ++n2;
        }
        return null;
    }

    protected static IModuleFolder getModuleFolder(IModuleFolder mf, IPath path) {
        IModuleResource[] mr = mf.members();
        if (mr == null) {
            return null;
        }
        IModuleResource[] iModuleResourceArray = mr;
        int n = mr.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleFolder mf2;
            IModuleResource m = iModuleResourceArray[n2];
            if (m.getModuleRelativePath().append(m.getName()).equals((Object)path)) {
                if (m instanceof IModuleFolder) {
                    return (IModuleFolder)m;
                }
                return null;
            }
            if (m.getModuleRelativePath().isPrefixOf(path) && m instanceof IModuleFolder && (mf2 = ModuleHelper.getModuleFolder((IModuleFolder)m, path)) != null) {
                return mf2;
            }
            ++n2;
        }
        return null;
    }

    public static boolean folderExists(IModule module, IPath path) throws CoreException {
        return ModuleHelper.getModuleFile(module, path) != null;
    }

    public static boolean folderExists(IModule module, String path) throws CoreException {
        return ModuleHelper.folderExists(module, (IPath)new Path(path));
    }

    public static void listModule(IModule module) throws CoreException {
        IModuleResource[] mr;
        System.out.println("--- Contents of " + module.getName() + "/" + module.getId() + "---");
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
        IModuleResource[] iModuleResourceArray = mr = pm.members();
        int n = mr.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResource m = iModuleResourceArray[n2];
            if (m instanceof IModuleFile) {
                System.out.println(m.getName());
            } else {
                System.out.println(String.valueOf(m.getName()) + "/");
                ModuleHelper.listFolder((IModuleFolder)m, "  ");
            }
            ++n2;
        }
        System.out.println("------");
    }

    protected static void listFolder(IModuleFolder mf, String pad) {
        IModuleResource[] mr = mf.members();
        if (mr == null) {
            return;
        }
        IModuleResource[] iModuleResourceArray = mr;
        int n = mr.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResource m = iModuleResourceArray[n2];
            if (m instanceof IModuleFile) {
                System.out.println(String.valueOf(pad) + m.getName());
            } else {
                System.out.println(String.valueOf(pad) + m.getName() + "/");
                ModuleHelper.listFolder((IModuleFolder)m, String.valueOf(pad) + "  ");
            }
            ++n2;
        }
    }
}

