/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.facet;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarFile;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.facet.UserLibraryVersionValidatorProxy;
import org.osgi.framework.Bundle;

public abstract class LibraryValidatorTest
extends TestCase {
    private String classNameIdentifyingJarToUse;
    private String jarPath;
    private String jarPathWithoutImplementationVersionEntry;
    private String jarPathWithNonstandardImplementationVersionEntry;
    private String expectedLibraryVersion;
    private UserLibraryVersionValidatorProxy validator;

    public LibraryValidatorTest(String name) {
        super(name);
    }

    public LibraryValidatorTest(String name, String classNameIdentifyingJarToUse, String jarPath, String jarPathWithoutImplementationVersionEntry, String jarPathWithNonstandardImplementationVersionEntry, String expectedLibraryVersion) {
        super(name);
        this.classNameIdentifyingJarToUse = classNameIdentifyingJarToUse;
        this.jarPath = jarPath;
        this.jarPathWithoutImplementationVersionEntry = jarPathWithoutImplementationVersionEntry;
        this.jarPathWithNonstandardImplementationVersionEntry = jarPathWithNonstandardImplementationVersionEntry;
        this.expectedLibraryVersion = expectedLibraryVersion;
        this.validator = new UserLibraryVersionValidatorProxy(this.classNameIdentifyingJarToUse);
    }

    public void testVersionStringSuffixMatch() {
        LibraryValidatorTest.assertNotNull((Object)((Object)this.validator));
        IStatus status = this.validator.validateVersionStrings("1.2", "1.1.2");
        LibraryValidatorTest.assertEquals((int)4, (int)status.getSeverity());
    }

    public void testVersionStringPrefixMatch() {
        LibraryValidatorTest.assertNotNull((Object)((Object)this.validator));
        IStatus status = this.validator.validateVersionStrings("1.2", "1.2.11");
        LibraryValidatorTest.assertEquals((int)0, (int)status.getSeverity());
    }

    public void testNullLibraryVersionString() {
        LibraryValidatorTest.assertNotNull((Object)((Object)this.validator));
        IStatus status = this.validator.validateVersionStrings("1.2", null);
        LibraryValidatorTest.assertEquals((int)2, (int)status.getSeverity());
    }

    public void testNullFacetVersionString() {
        LibraryValidatorTest.assertNotNull((Object)((Object)this.validator));
        try {
            this.validator.validateVersionStrings(null, "1.0.1.2.11");
        }
        catch (IllegalArgumentException e) {
            LibraryValidatorTest.assertEquals((String)"Cannot read facet version", (String)e.getLocalizedMessage());
            return;
        }
        LibraryValidatorTest.fail();
    }

    protected File getFileFromPlugin(String relativePathToFile, Plugin plugin) throws IOException, URISyntaxException {
        Bundle bundle = TestsPlugin.getDefault().getBundle();
        URL bundleUrl = bundle.getEntry(relativePathToFile);
        LibraryValidatorTest.assertNotNull((Object)bundleUrl);
        URL fileUrl = FileLocator.toFileURL((URL)bundleUrl);
        File file = new File(fileUrl.getPath());
        LibraryValidatorTest.assertTrue((boolean)file.exists());
        return file;
    }

    public void testReadLibraryVersionFromJarWithManifestEntry() throws IOException, URISyntaxException {
        JarFile jarFile = new JarFile(this.getFileFromPlugin(this.jarPath, (Plugin)TestsPlugin.getDefault()));
        LibraryValidatorTest.assertEquals((String)this.expectedLibraryVersion, (String)this.validator.getLibraryVersion(jarFile));
    }

    public void testReadLibraryVersionFromJarWithoutManifestEntry() throws IOException, URISyntaxException {
        JarFile jarFile = new JarFile(this.getFileFromPlugin(this.jarPathWithoutImplementationVersionEntry, (Plugin)TestsPlugin.getDefault()));
        LibraryValidatorTest.assertNull((String)"Was expecting library-version string to be null", (Object)this.validator.getLibraryVersion(jarFile));
    }

    public void testReadLibraryVersionFromJarWithNonstandardImplementationVersion() throws IOException, URISyntaxException {
        JarFile jarFile = new JarFile(this.getFileFromPlugin(this.jarPathWithNonstandardImplementationVersionEntry, (Plugin)TestsPlugin.getDefault()));
        LibraryValidatorTest.assertNotNull((String)"Was expecting library-version string to be non-null", (Object)this.validator.getLibraryVersion(jarFile));
        LibraryValidatorTest.assertEquals((String)this.expectedLibraryVersion, (String)this.validator.getLibraryVersion(jarFile));
    }
}

