package oracle.adfdemo.view.faces;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

import oracle.adf.view.faces.component.UIXCollection;
import oracle.adf.view.faces.component.UIXTree;
import oracle.adf.view.faces.component.UIXTable;
import oracle.adf.view.faces.model.CurrencySet;

public class TableBean
{
  public UIComponent getTable()
  {
    return _table;
  }

  public void setTable(UIComponent hgrid)
  {
    _table = hgrid;
  }

  public void performReport(ActionEvent action)
  {
    UIXCollection table = (UIXCollection) _table;
    final CurrencySet state;
    if (table instanceof UIXTable)
      state = ((UIXTable) table).getSelectionState();
    else
      state = ((UIXTree) table).getSelectionState();
    Iterator selection = state.getKeySet().iterator();
    Object oldKey = table.getRowKey();
    _selection = new ArrayList();
    while (selection.hasNext())
    {
      table.setRowKey(selection.next());
      _selection.add(table.getRowData());
    }
    table.setRowKey(oldKey);
    FacesContext context = FacesContext.getCurrentInstance();
    FacesMessage message =
      new FacesMessage("Report Performed","Report was performed on "+
                       _selection.size()+" records");
    context.addMessage(null, message);
  }

  public List getReportItems()
  {
    return _selection;
  }

  private UIComponent _table = null;
  private List _selection = Collections.EMPTY_LIST;
}
