/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov.osgi.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.BundleReference;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.OsgiBundlesContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public final class OsgiBundlesContainerImpl
implements IClasspathContainer {
    private final IPath containerPath;
    private final IProjectFacet facet;
    private final IClasspathEntry[] entries;
    private final String description;

    private OsgiBundlesContainerImpl(IJavaProject project, IPath containerPath) {
        this.containerPath = containerPath;
        String fid = containerPath.segment(1);
        this.facet = ProjectFacetsManager.getProjectFacet((String)fid);
        IProject pj = project.getProject();
        String desc = OsgiBundlesContainer.getContainerLabel(pj, this.facet);
        if (desc == null) {
            desc = NLS.bind((String)Resources.containerLabel, (Object)this.facet.getLabel());
        }
        this.description = desc;
        List<BundleReference> bundleReferences = OsgiBundlesContainer.getBundleReferences(pj, this.facet);
        ArrayList<IClasspathEntry> entriesList = new ArrayList<IClasspathEntry>();
        for (BundleReference bundleReference : bundleReferences) {
            Bundle bundle = bundleReference.getBundle();
            if (bundle == null) continue;
            File file = null;
            try {
                file = FileLocator.getBundleFile((Bundle)bundle);
            }
            catch (IOException iOException) {}
            if (file == null) continue;
            entriesList.add(JavaCore.newLibraryEntry((IPath)new Path(file.getPath()), null, null));
        }
        this.entries = entriesList.toArray(new IClasspathEntry[entriesList.size()]);
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.entries;
    }

    public String getDescription() {
        return this.description;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.containerPath;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OsgiBundlesContainerImpl)) {
            return false;
        }
        return this.entries.equals(((OsgiBundlesContainerImpl)obj).entries);
    }

    /* synthetic */ OsgiBundlesContainerImpl(IJavaProject iJavaProject, IPath iPath, OsgiBundlesContainerImpl osgiBundlesContainerImpl) {
        this(iJavaProject, iPath);
    }

    public static final class Initializer
    extends ClasspathContainerInitializer {
        public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
            OsgiBundlesContainerImpl container = new OsgiBundlesContainerImpl(project, containerPath, null);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    private static final class Resources
    extends NLS {
        public static String containerLabel;

        static {
            Resources.initializeMessages((String)OsgiBundlesContainerImpl.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

