/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.log;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.wsi.internal.core.ToolInfo;
import org.eclipse.wst.wsi.internal.core.common.impl.AddStyleSheetImpl;
import org.eclipse.wst.wsi.internal.core.document.DocumentFactory;
import org.eclipse.wst.wsi.internal.core.log.Log;
import org.eclipse.wst.wsi.internal.core.log.MessageEntry;
import org.eclipse.wst.wsi.internal.core.log.MimeParts;
import org.eclipse.wst.wsi.internal.core.log.RequestHandler;
import org.eclipse.wst.wsi.internal.core.log.impl.LogImpl;
import org.eclipse.wst.wsi.internal.core.log.impl.LogWriterImpl;
import org.eclipse.wst.wsi.internal.core.log.impl.MessageEntryImpl;
import org.eclipse.wst.wsi.internal.core.monitor.config.MonitorConfig;
import org.eclipse.wst.wsi.internal.core.monitor.config.impl.CommentImpl;
import org.eclipse.wst.wsi.internal.core.monitor.config.impl.ManInTheMiddleImpl;
import org.eclipse.wst.wsi.internal.core.util.Utils;

public class LogBuilder {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    protected int conversationId = 1;
    protected int id = 1;
    protected Log log = null;
    protected IFile ifile;
    private static final String TOOL_NAME = "Monitor";
    private static final String TOOL_VERSION = "1.0";
    private static final String TOOL_RELEASE_DATE = "2003-03-20";
    private static final String TOOL_IMPLEMENTER = "IBM";
    private static final String TOOL_LOCATION = "";
    public static final SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public LogBuilder(IFile ifile) {
        this.ifile = ifile;
    }

    public Log buildLog(List requestResponses) {
        this.log = new LogImpl();
        this.logMonitorInformation();
        Iterator i = requestResponses.iterator();
        while (i.hasNext()) {
            RequestHandler rr = (RequestHandler)i.next();
            if (rr == null) continue;
            try {
                this.logRequestResponse(rr);
            }
            catch (Exception exception) {}
        }
        return this.log;
    }

    public void logMonitorInformation() {
    }

    protected void logRequestResponse(RequestHandler rr) {
        if (rr != null) {
            byte[] requestHeaderBytes = rr.getRequestHeader();
            byte[] responseHeaderBytes = rr.getResponseHeader();
            if (requestHeaderBytes != null || responseHeaderBytes != null) {
                long timestamp = rr.getDate().getTime();
                String localHostAndPort = "localhost:" + rr.getLocalPort();
                String remoteHostAndPort = String.valueOf(rr.getRemoteHost()) + ":" + rr.getRemotePort();
                int conversationId = this.getNextAvailableConversationId();
                try {
                    if (requestHeaderBytes != null) {
                        String requestHeader = new String(requestHeaderBytes);
                        byte[] unchunkedRequestBody = rr.getRequestContent();
                        int requestId = this.getNextAvailableId();
                        MessageEntry messageEntryRequest = this.createMessageEntry(requestId, conversationId, "request", timestamp, localHostAndPort, remoteHostAndPort, unchunkedRequestBody, requestHeader);
                        if (messageEntryRequest != null) {
                            this.log.addLogEntry(messageEntryRequest);
                        }
                    }
                    if (responseHeaderBytes != null) {
                        String responseHeader = new String(responseHeaderBytes);
                        byte[] unchunkedResponseBody = rr.getResponseContent();
                        int responseId = this.getNextAvailableId();
                        MessageEntry messageEntryResponse = this.createMessageEntry(responseId, conversationId, "response", timestamp + rr.getResponseTime(), remoteHostAndPort, localHostAndPort, unchunkedResponseBody, responseHeader);
                        if (messageEntryResponse != null) {
                            this.log.addLogEntry(messageEntryResponse);
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isMessageWithBrackets(String message) {
        return message != null && message.indexOf("<") != -1 && message.indexOf(">") != -1;
    }

    protected String getHeader(byte[] requestOrResponse, int headerLength) {
        String result = null;
        if (requestOrResponse != null && headerLength > 0 && requestOrResponse.length >= headerLength) {
            byte[] header = new byte[headerLength];
            System.arraycopy(requestOrResponse, 0, header, 0, headerLength);
            result = new String(header);
        }
        return result;
    }

    protected String getBody(byte[] requestOrResponse, int headerLength) {
        String result = null;
        if (requestOrResponse != null && headerLength > 0 && requestOrResponse.length > headerLength) {
            int bodyLength = requestOrResponse.length - headerLength;
            byte[] body = new byte[bodyLength];
            System.arraycopy(requestOrResponse, headerLength, body, 0, bodyLength);
            result = new String(body);
        }
        return result;
    }

    protected MessageEntry createMessageEntry(int id, int conversationId, String type, long timestamp, String senderHostAndPort, String receiverHostAndPort, byte[] messageContent, String header) {
        MessageEntryImpl messageEntry = new MessageEntryImpl();
        messageEntry.setId(String.valueOf(id));
        messageEntry.setConversationId(String.valueOf(conversationId));
        messageEntry.setType(type);
        messageEntry.setTimestamp(LogBuilder.getTimestamp(new Date(timestamp)));
        messageEntry.setSenderHostAndPort(senderHostAndPort);
        messageEntry.setReceiverHostAndPort(receiverHostAndPort);
        messageEntry.setEncoding("UTF-8");
        messageEntry.setHTTPHeaders(header);
        if (Utils.isMultipartRelatedMessage(header)) {
            MimeParts mimeParts = Utils.parseMultipartRelatedMessage(messageContent, header, "UTF-8");
            if (mimeParts == null) {
                if (messageContent != null) {
                    messageEntry.setMessage(new String(messageContent));
                } else {
                    messageEntry.setMessage(TOOL_LOCATION);
                }
                messageEntry.setMimeContent(false);
            } else {
                messageEntry.setMimeParts(mimeParts);
                messageEntry.setMimeContent(true);
            }
        } else {
            if (messageContent != null) {
                messageEntry.setMessage(new String(messageContent));
            } else {
                messageEntry.setMessage(TOOL_LOCATION);
            }
            messageEntry.setMimeContent(false);
        }
        return messageEntry;
    }

    protected int getNextAvailableId() {
        return this.id++;
    }

    protected int getNextAvailableConversationId() {
        return this.conversationId++;
    }

    public int getHeaderLength(Integer obj) {
        int result = 0;
        if (obj != null) {
            result = obj;
        }
        return result;
    }

    public void writeLog(Log log) {
        try {
            LogWriterImpl logWriter = new LogWriterImpl();
            logWriter.setWriter(this.ifile.getLocation().toString());
            logWriter.write(new StringReader(log.getStartXMLString(TOOL_LOCATION)));
            String monitorInfo = this.generateMonitorToolInfo();
            logWriter.write(new StringReader(monitorInfo));
            int i = 0;
            while (i < log.getEntryCount()) {
                MessageEntry me = log.getLogEntry(i);
                logWriter.write(new StringReader(me.toXMLString(TOOL_LOCATION)));
                ++i;
            }
            logWriter.write(new StringReader(log.getEndXMLString(TOOL_LOCATION)));
            logWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Exception thrown when printing log file.");
        }
    }

    protected String generateMonitorToolInfo() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            ToolInfo toolInfo = new ToolInfo(TOOL_NAME, TOOL_VERSION, TOOL_RELEASE_DATE, TOOL_IMPLEMENTER, TOOL_LOCATION);
            DocumentFactory documentFactory = DocumentFactory.newInstance();
            MonitorConfig monitorConfig = documentFactory.newMonitorConfig();
            CommentImpl comment = new CommentImpl();
            comment.setText("Comment");
            monitorConfig.setComment(comment);
            monitorConfig.setLogLocation("URL");
            monitorConfig.setReplaceLog(true);
            AddStyleSheetImpl addStyleSheet = new AddStyleSheetImpl();
            monitorConfig.setAddStyleSheet(addStyleSheet);
            monitorConfig.setLogDuration(600);
            monitorConfig.setTimeout(3);
            ManInTheMiddleImpl manInTheMiddle = new ManInTheMiddleImpl();
            monitorConfig.setManInTheMiddle(manInTheMiddle);
            monitorConfig.setLocation("documentURI");
            monitorConfig.setVerboseOption(false);
            pw.print(toolInfo.getStartXMLString(TOOL_LOCATION));
            pw.print(monitorConfig.toXMLString("wsi-monConfig"));
            pw.println(toolInfo.getEndXMLString(TOOL_LOCATION));
        }
        catch (Exception exception) {}
        return sw.toString();
    }

    public static String getTimestamp(Date date) {
        timestampFormat.setTimeZone(TimeZone.getDefault());
        return timestampFormat.format(date);
    }
}

