/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogs.CommonResourceDialog;
import org.eclipse.jst.jsf.common.ui.internal.utils.PathUtil;
import org.eclipse.jst.jsf.common.ui.internal.utils.WebrootUtil;
import org.eclipse.swt.widgets.Shell;

public class ResourceButtonDialogField
extends StringButtonDialogField {
    private IProject _project;
    private String[] _suffixs;
    private String _resourceDescription;
    private IFile _referredFile;
    private boolean _isWebPath = false;
    private IFolder _folder;
    private String _separator = "";

    public ResourceButtonDialogField(IProject project) {
        this(null, project);
        this.setStringButtonAdapter(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                String oldValue = ResourceButtonDialogField.this.getText();
                String newValue = ResourceButtonDialogField.this.browseButtonPressed();
                if (newValue != null && !newValue.equals(oldValue)) {
                    ResourceButtonDialogField.this.setText(newValue);
                }
            }
        });
    }

    public ResourceButtonDialogField(IStringButtonAdapter adapter, IProject project) {
        super(adapter);
        this._project = project;
    }

    protected String browseButtonPressed() {
        Shell shell = this.getShell();
        CommonResourceDialog dialog = null;
        int style = "".equals(this._separator) ? 0 : 770;
        dialog = this._folder != null ? new CommonResourceDialog(shell, this._folder.getProject(), style) : new CommonResourceDialog(shell, this._project, style);
        dialog.setTitle(JSFUICommonPlugin.getResourceString("DialogField.ResourceButton.SelectFile"));
        dialog.setSuffixs(this._suffixs);
        dialog.setResourceDescription(this._resourceDescription);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < result.length) {
                String newValue = null;
                IPath path = ((IFile)result[i]).getLocation();
                IPath referredPath = null;
                referredPath = this._referredFile != null ? this._referredFile.getLocation() : this._project.getLocation();
                if (this._isWebPath) {
                    IFile selectedFile = (IFile)result[i];
                    newValue = WebrootUtil.getWebPath(selectedFile.getFullPath());
                } else {
                    newValue = PathUtil.convertToRelativePath(path.toString(), referredPath.toString());
                }
                buffer.append(newValue);
                buffer.append(this._separator);
                ++i;
            }
            if (buffer.length() > 0) {
                return buffer.substring(0, buffer.length() - this._separator.length());
            }
        }
        return null;
    }

    public IProject getProject() {
        return this._project;
    }

    public void setProject(IProject project) {
        this._project = project;
    }

    public IFolder getFolder() {
        return this._folder;
    }

    public void setFolder(IFolder folder) {
        this._folder = folder;
    }

    public IFile getReferredFile() {
        return this._referredFile;
    }

    public void setReferredFile(IFile referredFile) {
        this._referredFile = referredFile;
    }

    public String getResourceDescription() {
        return this._resourceDescription;
    }

    public void setResourceDescription(String resourceDescription) {
        this._resourceDescription = resourceDescription;
    }

    public String[] getSuffixs() {
        return this._suffixs;
    }

    public void setSuffixs(String[] suffixs) {
        this._suffixs = suffixs;
    }

    public void setWebPath(boolean isWebPath) {
        this._isWebPath = isWebPath;
    }

    public String getSeparator() {
        return this._separator;
    }

    public void setSeparator(String separator) {
        this._separator = separator;
    }
}

