/*******************************************************************************
 * Copyright (c) 2008, 2009 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.ui.internal.menus;

import java.util.Iterator;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.details.AttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.DefaultAttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.DefaultMappingUiProvider;
import org.eclipse.jpt.ui.details.MappingUiProvider;
import org.eclipse.jpt.ui.internal.commands.PersistentAttributeMapAsHandler;
import org.eclipse.ui.menus.CommandContributionItemParameter;

/**
 * This menu contribution is responsible to populate the Map As menu with the
 * registered attribute mapping types defined in the <code>JptPlatformUi</code>
 * for <code>PersistentAttribute</code> objects.
 *
 * @see PersistentAttributeMapAsHandler
 * @see PersistentAttribute
 *
 * @version 2.2
 * @since 2.0
 */
public class PersistentAttributeMapAsContribution extends MapAsContribution
{
	/**
	 * Creates a new <code>PersistentAttributeMapAsContribution</code>.
	 */
	public PersistentAttributeMapAsContribution() {
		super();
	}

	@Override
	protected String getCommandId() {
		return PersistentAttributeMapAsHandler.COMMAND_ID;
	}
	
	@Override
	protected String getCommandParameterId() {
		return PersistentAttributeMapAsHandler.SPECIFIED_MAPPING_COMMAND_PARAMETER_ID;
	}
	
	@Override
	protected CommandContributionItemParameter createParameter(MappingUiProvider<?> mappingUiProvider) {
		CommandContributionItemParameter parameter = super.createParameter(mappingUiProvider);
		String defaultKey = null;
		if (mappingUiProvider instanceof DefaultMappingUiProvider<?>) {
			defaultKey = ((DefaultMappingUiProvider<?>) mappingUiProvider).getDefaultKey();
		}
		parameter.parameters.put(PersistentAttributeMapAsHandler.DEFAULT_MAPPING_COMMAND_PARAMETER_ID, defaultKey);
		return parameter;
	}
	
	@Override
	protected Iterator<? extends AttributeMappingUiProvider<?>> 
			mappingUiProviders(JpaPlatformUi jpaPlatformUi, IContentType contentType) {
		return jpaPlatformUi.attributeMappingUiProviders(contentType);
	}
	
	@Override
	protected DefaultAttributeMappingUiProvider<?> getDefaultProvider(JpaPlatformUi jpaPlatformUi, JpaStructureNode node) {
		return getDefaultProvider(jpaPlatformUi, ((PersistentAttribute) node).getDefaultMappingKey(), node.getContentType());
	}
	
	protected DefaultAttributeMappingUiProvider<?> getDefaultProvider(JpaPlatformUi jpaPlatformUi, String defaultKey, IContentType contentType) {
		return jpaPlatformUi.getDefaultAttributeMappingUiProvider(defaultKey, contentType);
	}
}
