/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectFrameworkEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectFrameworkListener;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectFrameworkImpl;
import org.eclipse.wst.common.project.facet.core.util.internal.VersionExpr2;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class FacetedProjectFramework {
    public static final String PLUGIN_ID = "org.eclipse.wst.common.project.facet.core";
    public static final String DEFAULT_CONFIGURATION_PRESET_ID = "default.configuration";
    private static FacetedProjectFrameworkImpl impl = null;

    private FacetedProjectFramework() {
    }

    public static IFacetedProjectWorkingCopy createNewProject() {
        FacetedProjectFramework.initialize();
        return impl.createNewProject();
    }

    public static boolean isFacetedProject(IProject project) throws CoreException {
        return project.isAccessible() && project.isNatureEnabled("org.eclipse.wst.common.project.facet.core.nature");
    }

    public static boolean hasProjectFacet(IProject project, String fid) throws CoreException {
        return FacetedProjectFramework.hasProjectFacet(project, fid, null);
    }

    public static boolean hasProjectFacet(IProject project, String fid, String vexpr) throws CoreException {
        if (project.isAccessible() && project.isNatureEnabled("org.eclipse.wst.common.project.facet.core.nature")) {
            FacetedProjectFramework.initialize();
            IFacetedProject fproj = ProjectFacetsManager.create(project);
            if (fproj != null) {
                if (ProjectFacetsManager.isProjectFacetDefined(fid)) {
                    IProjectFacet f = ProjectFacetsManager.getProjectFacet(fid);
                    if (vexpr == null) {
                        return fproj.hasProjectFacet(f);
                    }
                    IProjectFacetVersion fv = fproj.getInstalledVersion(f);
                    if (fv != null) {
                        VersionExpr2 expr = new VersionExpr2(vexpr);
                        return expr.check(fv.getVersionString());
                    }
                } else {
                    for (IProjectFacetVersion fv : fproj.getProjectFacets()) {
                        IProjectFacet f = fv.getProjectFacet();
                        if (!f.getId().equals(fid)) continue;
                        if (vexpr == null) {
                            return true;
                        }
                        VersionExpr2 expr = new VersionExpr2(vexpr);
                        return expr.check(fv.getVersionString());
                    }
                }
            }
        }
        return false;
    }

    public static void addListener(IFacetedProjectListener listener, IFacetedProjectEvent.Type ... types) {
        FacetedProjectFramework.initialize();
        impl.addListener(listener, types);
    }

    public static void addListener(IFacetedProjectFrameworkListener listener, IFacetedProjectFrameworkEvent.Type ... types) {
        FacetedProjectFramework.initialize();
        impl.addListener(listener, types);
    }

    public static void removeListener(IFacetedProjectListener listener) {
        FacetedProjectFramework.initialize();
        impl.removeListener(listener);
    }

    public static void removeListener(IFacetedProjectFrameworkListener listener) {
        FacetedProjectFramework.initialize();
        impl.removeListener(listener);
    }

    public static Preferences getPreferences(IProjectFacet facet) throws BackingStoreException {
        FacetedProjectFramework.initialize();
        return impl.getPreferences(facet);
    }

    private static synchronized void initialize() {
        if (impl == null) {
            impl = FacetedProjectFrameworkImpl.getInstance();
        }
    }
}

